/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64Codec;
import com.nimbusds.jose.util.BigIntegerUtils;
import java.math.BigInteger;
import net.jcip.annotations.Immutable;

@Immutable
public class Base64URL
extends Base64 {
    public Base64URL(String base64URL) {
        super(base64URL);
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof Base64URL && this.toString().equals(object.toString());
    }

    public static Base64URL encode(byte[] bytes2) {
        return new Base64URL(Base64Codec.encodeToString(bytes2, true));
    }

    public static Base64URL encode(BigInteger bigInt) {
        return Base64URL.encode(BigIntegerUtils.toBytesUnsigned(bigInt));
    }

    public static Base64URL encode(String text) {
        return Base64URL.encode(text.getBytes(CHARSET));
    }

    public static /* bridge */ /* synthetic */ Base64 encode(String string2) {
        return Base64URL.encode(string2);
    }

    public static /* bridge */ /* synthetic */ Base64 encode(BigInteger bigInteger) {
        return Base64URL.encode(bigInteger);
    }

    public static /* bridge */ /* synthetic */ Base64 encode(byte[] byArray) {
        return Base64URL.encode(byArray);
    }
}

