/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.CharsetUtil;
import io.netty.util.internal.Cleaner;
import io.netty.util.internal.CleanerJava6;
import io.netty.util.internal.CleanerJava9;
import io.netty.util.internal.ConstantTimeUtils;
import io.netty.util.internal.LongAdderCounter;
import io.netty.util.internal.LongCounter;
import io.netty.util.internal.OutOfDirectMemoryError;
import io.netty.util.internal.PlatformDependent0;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadLocalRandom;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscChunkedArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscUnboundedArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.SpscLinkedQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscGrowableAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscUnboundedAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.SpscLinkedAtomicQueue;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PlatformDependent {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PlatformDependent.class);
    private static final Pattern MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN = Pattern.compile("\\s*-XX:MaxDirectMemorySize\\s*=\\s*([0-9]+)\\s*([kKmMgG]?)\\s*$");
    private static final boolean IS_WINDOWS = PlatformDependent.isWindows0();
    private static final boolean IS_OSX = PlatformDependent.isOsx0();
    private static final boolean IS_J9_JVM = PlatformDependent.isJ9Jvm0();
    private static final boolean IS_IVKVM_DOT_NET = PlatformDependent.isIkvmDotNet0();
    private static final boolean MAYBE_SUPER_USER;
    private static final boolean CAN_ENABLE_TCP_NODELAY_BY_DEFAULT;
    private static final Throwable UNSAFE_UNAVAILABILITY_CAUSE;
    private static final boolean DIRECT_BUFFER_PREFERRED;
    private static final long MAX_DIRECT_MEMORY;
    private static final int MPSC_CHUNK_SIZE = 1024;
    private static final int MIN_MAX_MPSC_CAPACITY = 2048;
    private static final int MAX_ALLOWED_MPSC_CAPACITY = 0x40000000;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final File TMPDIR;
    private static final int BIT_MODE;
    private static final String NORMALIZED_ARCH;
    private static final String NORMALIZED_OS;
    private static final String[] ALLOWED_LINUX_OS_CLASSIFIERS;
    private static final Set<String> LINUX_OS_CLASSIFIERS;
    private static final int ADDRESS_SIZE;
    private static final boolean USE_DIRECT_BUFFER_NO_CLEANER;
    private static final AtomicLong DIRECT_MEMORY_COUNTER;
    private static final long DIRECT_MEMORY_LIMIT;
    private static final ThreadLocalRandomProvider RANDOM_PROVIDER;
    private static final Cleaner CLEANER;
    private static final int UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD;
    public static final boolean BIG_ENDIAN_NATIVE_ORDER;
    private static final Cleaner NOOP;

    public static boolean hasDirectBufferNoCleanerConstructor() {
        return PlatformDependent0.hasDirectBufferNoCleanerConstructor();
    }

    public static byte[] allocateUninitializedArray(int size2) {
        return UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD < 0 || UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD > size2 ? new byte[size2] : PlatformDependent0.allocateUninitializedArray(size2);
    }

    public static boolean isAndroid() {
        return PlatformDependent0.isAndroid();
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isOsx() {
        return IS_OSX;
    }

    public static boolean maybeSuperUser() {
        return MAYBE_SUPER_USER;
    }

    public static int javaVersion() {
        return PlatformDependent0.javaVersion();
    }

    public static boolean canEnableTcpNoDelayByDefault() {
        return CAN_ENABLE_TCP_NODELAY_BY_DEFAULT;
    }

    public static boolean hasUnsafe() {
        return UNSAFE_UNAVAILABILITY_CAUSE == null;
    }

    public static Throwable getUnsafeUnavailabilityCause() {
        return UNSAFE_UNAVAILABILITY_CAUSE;
    }

    public static boolean isUnaligned() {
        return PlatformDependent0.isUnaligned();
    }

    public static boolean directBufferPreferred() {
        return DIRECT_BUFFER_PREFERRED;
    }

    public static long maxDirectMemory() {
        return DIRECT_MEMORY_LIMIT;
    }

    public static long usedDirectMemory() {
        return DIRECT_MEMORY_COUNTER != null ? DIRECT_MEMORY_COUNTER.get() : -1L;
    }

    public static File tmpdir() {
        return TMPDIR;
    }

    public static int bitMode() {
        return BIT_MODE;
    }

    public static int addressSize() {
        return ADDRESS_SIZE;
    }

    public static long allocateMemory(long size2) {
        return PlatformDependent0.allocateMemory(size2);
    }

    public static void freeMemory(long address2) {
        PlatformDependent0.freeMemory(address2);
    }

    public static long reallocateMemory(long address2, long newSize) {
        return PlatformDependent0.reallocateMemory(address2, newSize);
    }

    public static void throwException(Throwable t) {
        if (PlatformDependent.hasUnsafe()) {
            PlatformDependent0.throwException(t);
        } else {
            PlatformDependent.throwException0(t);
        }
    }

    private static <E extends Throwable> void throwException0(Throwable t) throws E {
        throw t;
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static LongCounter newLongCounter() {
        if (PlatformDependent.javaVersion() >= 8) {
            return new LongAdderCounter();
        }
        return new AtomicLongCounter();
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int initialCapacity, float loadFactor) {
        return new ConcurrentHashMap(initialCapacity, loadFactor);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(Map<? extends K, ? extends V> map) {
        return new ConcurrentHashMap<K, V>(map);
    }

    public static void freeDirectBuffer(ByteBuffer buffer) {
        CLEANER.freeDirectBuffer(buffer);
    }

    public static long directBufferAddress(ByteBuffer buffer) {
        return PlatformDependent0.directBufferAddress(buffer);
    }

    public static ByteBuffer directBuffer(long memoryAddress, int size2) {
        if (PlatformDependent0.hasDirectBufferNoCleanerConstructor()) {
            return PlatformDependent0.newDirectBuffer(memoryAddress, size2);
        }
        throw new UnsupportedOperationException("sun.misc.Unsafe or java.nio.DirectByteBuffer.<init>(long, int) not available");
    }

    public static Object getObject(Object object, long fieldOffset) {
        return PlatformDependent0.getObject(object, fieldOffset);
    }

    public static int getInt(Object object, long fieldOffset) {
        return PlatformDependent0.getInt(object, fieldOffset);
    }

    public static byte getByte(long address2) {
        return PlatformDependent0.getByte(address2);
    }

    public static short getShort(long address2) {
        return PlatformDependent0.getShort(address2);
    }

    public static int getInt(long address2) {
        return PlatformDependent0.getInt(address2);
    }

    public static long getLong(long address2) {
        return PlatformDependent0.getLong(address2);
    }

    public static byte getByte(byte[] data, int index2) {
        return PlatformDependent0.getByte(data, index2);
    }

    public static short getShort(byte[] data, int index2) {
        return PlatformDependent0.getShort(data, index2);
    }

    public static int getInt(byte[] data, int index2) {
        return PlatformDependent0.getInt(data, index2);
    }

    public static long getLong(byte[] data, int index2) {
        return PlatformDependent0.getLong(data, index2);
    }

    private static long getLongSafe(byte[] bytes2, int offset2) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return (long)bytes2[offset2] << 56 | ((long)bytes2[offset2 + 1] & 0xFFL) << 48 | ((long)bytes2[offset2 + 2] & 0xFFL) << 40 | ((long)bytes2[offset2 + 3] & 0xFFL) << 32 | ((long)bytes2[offset2 + 4] & 0xFFL) << 24 | ((long)bytes2[offset2 + 5] & 0xFFL) << 16 | ((long)bytes2[offset2 + 6] & 0xFFL) << 8 | (long)bytes2[offset2 + 7] & 0xFFL;
        }
        return (long)bytes2[offset2] & 0xFFL | ((long)bytes2[offset2 + 1] & 0xFFL) << 8 | ((long)bytes2[offset2 + 2] & 0xFFL) << 16 | ((long)bytes2[offset2 + 3] & 0xFFL) << 24 | ((long)bytes2[offset2 + 4] & 0xFFL) << 32 | ((long)bytes2[offset2 + 5] & 0xFFL) << 40 | ((long)bytes2[offset2 + 6] & 0xFFL) << 48 | (long)bytes2[offset2 + 7] << 56;
    }

    private static int getIntSafe(byte[] bytes2, int offset2) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return bytes2[offset2] << 24 | (bytes2[offset2 + 1] & 0xFF) << 16 | (bytes2[offset2 + 2] & 0xFF) << 8 | bytes2[offset2 + 3] & 0xFF;
        }
        return bytes2[offset2] & 0xFF | (bytes2[offset2 + 1] & 0xFF) << 8 | (bytes2[offset2 + 2] & 0xFF) << 16 | bytes2[offset2 + 3] << 24;
    }

    private static short getShortSafe(byte[] bytes2, int offset2) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return (short)(bytes2[offset2] << 8 | bytes2[offset2 + 1] & 0xFF);
        }
        return (short)(bytes2[offset2] & 0xFF | bytes2[offset2 + 1] << 8);
    }

    private static int hashCodeAsciiCompute(CharSequence value2, int offset2, int hash2) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return hash2 * -862048943 + PlatformDependent.hashCodeAsciiSanitizeInt(value2, offset2 + 4) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(value2, offset2);
        }
        return hash2 * -862048943 + PlatformDependent.hashCodeAsciiSanitizeInt(value2, offset2) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(value2, offset2 + 4);
    }

    private static int hashCodeAsciiSanitizeInt(CharSequence value2, int offset2) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return value2.charAt(offset2 + 3) & 0x1F | (value2.charAt(offset2 + 2) & 0x1F) << 8 | (value2.charAt(offset2 + 1) & 0x1F) << 16 | (value2.charAt(offset2) & 0x1F) << 24;
        }
        return (value2.charAt(offset2 + 3) & 0x1F) << 24 | (value2.charAt(offset2 + 2) & 0x1F) << 16 | (value2.charAt(offset2 + 1) & 0x1F) << 8 | value2.charAt(offset2) & 0x1F;
    }

    private static int hashCodeAsciiSanitizeShort(CharSequence value2, int offset2) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return value2.charAt(offset2 + 1) & 0x1F | (value2.charAt(offset2) & 0x1F) << 8;
        }
        return (value2.charAt(offset2 + 1) & 0x1F) << 8 | value2.charAt(offset2) & 0x1F;
    }

    private static int hashCodeAsciiSanitizeByte(char value2) {
        return value2 & 0x1F;
    }

    public static void putByte(long address2, byte value2) {
        PlatformDependent0.putByte(address2, value2);
    }

    public static void putShort(long address2, short value2) {
        PlatformDependent0.putShort(address2, value2);
    }

    public static void putInt(long address2, int value2) {
        PlatformDependent0.putInt(address2, value2);
    }

    public static void putLong(long address2, long value2) {
        PlatformDependent0.putLong(address2, value2);
    }

    public static void putByte(byte[] data, int index2, byte value2) {
        PlatformDependent0.putByte(data, index2, value2);
    }

    public static void putShort(byte[] data, int index2, short value2) {
        PlatformDependent0.putShort(data, index2, value2);
    }

    public static void putInt(byte[] data, int index2, int value2) {
        PlatformDependent0.putInt(data, index2, value2);
    }

    public static void putLong(byte[] data, int index2, long value2) {
        PlatformDependent0.putLong(data, index2, value2);
    }

    public static void putObject(Object o, long offset2, Object x) {
        PlatformDependent0.putObject(o, offset2, x);
    }

    public static long objectFieldOffset(Field field2) {
        return PlatformDependent0.objectFieldOffset(field2);
    }

    public static void copyMemory(long srcAddr, long dstAddr, long length2) {
        PlatformDependent0.copyMemory(srcAddr, dstAddr, length2);
    }

    public static void copyMemory(byte[] src, int srcIndex, long dstAddr, long length2) {
        PlatformDependent0.copyMemory(src, BYTE_ARRAY_BASE_OFFSET + (long)srcIndex, null, dstAddr, length2);
    }

    public static void copyMemory(long srcAddr, byte[] dst, int dstIndex, long length2) {
        PlatformDependent0.copyMemory(null, srcAddr, dst, BYTE_ARRAY_BASE_OFFSET + (long)dstIndex, length2);
    }

    public static void setMemory(byte[] dst, int dstIndex, long bytes2, byte value2) {
        PlatformDependent0.setMemory(dst, BYTE_ARRAY_BASE_OFFSET + (long)dstIndex, bytes2, value2);
    }

    public static void setMemory(long address2, long bytes2, byte value2) {
        PlatformDependent0.setMemory(address2, bytes2, value2);
    }

    public static ByteBuffer allocateDirectNoCleaner(int capacity) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        PlatformDependent.incrementMemoryCounter(capacity);
        try {
            return PlatformDependent0.allocateDirectNoCleaner(capacity);
        }
        catch (Throwable e) {
            PlatformDependent.decrementMemoryCounter(capacity);
            PlatformDependent.throwException(e);
            return null;
        }
    }

    public static ByteBuffer reallocateDirectNoCleaner(ByteBuffer buffer, int capacity) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        int len = capacity - buffer.capacity();
        PlatformDependent.incrementMemoryCounter(len);
        try {
            return PlatformDependent0.reallocateDirectNoCleaner(buffer, capacity);
        }
        catch (Throwable e) {
            PlatformDependent.decrementMemoryCounter(len);
            PlatformDependent.throwException(e);
            return null;
        }
    }

    public static void freeDirectNoCleaner(ByteBuffer buffer) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        int capacity = buffer.capacity();
        PlatformDependent0.freeMemory(PlatformDependent0.directBufferAddress(buffer));
        PlatformDependent.decrementMemoryCounter(capacity);
    }

    private static void incrementMemoryCounter(int capacity) {
        long newUsedMemory;
        if (DIRECT_MEMORY_COUNTER != null && (newUsedMemory = DIRECT_MEMORY_COUNTER.addAndGet(capacity)) > DIRECT_MEMORY_LIMIT) {
            DIRECT_MEMORY_COUNTER.addAndGet(-capacity);
            throw new OutOfDirectMemoryError("failed to allocate " + capacity + " byte(s) of direct memory (used: " + (newUsedMemory - (long)capacity) + ", max: " + DIRECT_MEMORY_LIMIT + ')');
        }
    }

    private static void decrementMemoryCounter(int capacity) {
        if (DIRECT_MEMORY_COUNTER != null) {
            long usedMemory = DIRECT_MEMORY_COUNTER.addAndGet(-capacity);
            assert (usedMemory >= 0L);
        }
    }

    public static boolean useDirectBufferNoCleaner() {
        return USE_DIRECT_BUFFER_NO_CLEANER;
    }

    public static boolean equals(byte[] bytes1, int startPos1, byte[] bytes2, int startPos2, int length2) {
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? PlatformDependent.equalsSafe(bytes1, startPos1, bytes2, startPos2, length2) : PlatformDependent0.equals(bytes1, startPos1, bytes2, startPos2, length2);
    }

    public static boolean isZero(byte[] bytes2, int startPos, int length2) {
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? PlatformDependent.isZeroSafe(bytes2, startPos, length2) : PlatformDependent0.isZero(bytes2, startPos, length2);
    }

    public static int equalsConstantTime(byte[] bytes1, int startPos1, byte[] bytes2, int startPos2, int length2) {
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? ConstantTimeUtils.equalsConstantTime(bytes1, startPos1, bytes2, startPos2, length2) : PlatformDependent0.equalsConstantTime(bytes1, startPos1, bytes2, startPos2, length2);
    }

    public static int hashCodeAscii(byte[] bytes2, int startPos, int length2) {
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? PlatformDependent.hashCodeAsciiSafe(bytes2, startPos, length2) : PlatformDependent0.hashCodeAscii(bytes2, startPos, length2);
    }

    public static int hashCodeAscii(CharSequence bytes2) {
        int length2 = bytes2.length();
        int remainingBytes = length2 & 7;
        int hash2 = -1028477387;
        if (length2 >= 32) {
            for (int i2 = length2 - 8; i2 >= remainingBytes; i2 -= 8) {
                hash2 = PlatformDependent.hashCodeAsciiCompute(bytes2, i2, hash2);
            }
        } else if (length2 >= 8) {
            hash2 = PlatformDependent.hashCodeAsciiCompute(bytes2, length2 - 8, hash2);
            if (length2 >= 16) {
                hash2 = PlatformDependent.hashCodeAsciiCompute(bytes2, length2 - 16, hash2);
                if (length2 >= 24) {
                    hash2 = PlatformDependent.hashCodeAsciiCompute(bytes2, length2 - 24, hash2);
                }
            }
        }
        if (remainingBytes == 0) {
            return hash2;
        }
        int offset2 = 0;
        if (remainingBytes != 2 & remainingBytes != 4 & remainingBytes != 6) {
            hash2 = hash2 * -862048943 + PlatformDependent.hashCodeAsciiSanitizeByte(bytes2.charAt(0));
            offset2 = 1;
        }
        if (remainingBytes != 1 & remainingBytes != 4 & remainingBytes != 5) {
            hash2 = hash2 * (offset2 == 0 ? -862048943 : 461845907) + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.hashCodeAsciiSanitizeShort(bytes2, offset2));
            offset2 += 2;
        }
        if (remainingBytes >= 4) {
            return hash2 * (offset2 == 0 | offset2 == 3 ? -862048943 : 461845907) + PlatformDependent.hashCodeAsciiSanitizeInt(bytes2, offset2);
        }
        return hash2;
    }

    public static <T> Queue<T> newMpscQueue() {
        return Mpsc.newMpscQueue();
    }

    public static <T> Queue<T> newMpscQueue(int maxCapacity) {
        return Mpsc.newMpscQueue(maxCapacity);
    }

    public static <T> Queue<T> newSpscQueue() {
        return PlatformDependent.hasUnsafe() ? new SpscLinkedQueue() : new SpscLinkedAtomicQueue();
    }

    public static <T> Queue<T> newFixedMpscQueue(int capacity) {
        return PlatformDependent.hasUnsafe() ? new MpscArrayQueue(capacity) : new MpscAtomicArrayQueue(capacity);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        return PlatformDependent0.getClassLoader(clazz);
    }

    public static ClassLoader getContextClassLoader() {
        return PlatformDependent0.getContextClassLoader();
    }

    public static ClassLoader getSystemClassLoader() {
        return PlatformDependent0.getSystemClassLoader();
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public static <C> Deque<C> newConcurrentDeque() {
        if (PlatformDependent.javaVersion() < 7) {
            return new LinkedBlockingDeque();
        }
        return new ConcurrentLinkedDeque();
    }

    public static Random threadLocalRandom() {
        return RANDOM_PROVIDER.current();
    }

    private static boolean isWindows0() {
        boolean windows = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).contains("win");
        if (windows) {
            logger.debug("Platform: Windows");
        }
        return windows;
    }

    private static boolean isOsx0() {
        boolean osx;
        String osname = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
        boolean bl = osx = osname.startsWith("macosx") || osname.startsWith("osx");
        if (osx) {
            logger.debug("Platform: MacOS");
        }
        return osx;
    }

    private static boolean maybeSuperUser0() {
        String username = SystemPropertyUtil.get("user.name");
        if (PlatformDependent.isWindows()) {
            return "Administrator".equals(username);
        }
        return "root".equals(username) || "toor".equals(username);
    }

    private static Throwable unsafeUnavailabilityCause0() {
        if (PlatformDependent.isAndroid()) {
            logger.debug("sun.misc.Unsafe: unavailable (Android)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (Android)");
        }
        if (PlatformDependent.isIkvmDotNet()) {
            logger.debug("sun.misc.Unsafe: unavailable (IKVM.NET)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (IKVM.NET)");
        }
        Throwable cause2 = PlatformDependent0.getUnsafeUnavailabilityCause();
        if (cause2 != null) {
            return cause2;
        }
        try {
            boolean hasUnsafe = PlatformDependent0.hasUnsafe();
            logger.debug("sun.misc.Unsafe: {}", (Object)(hasUnsafe ? "available" : "unavailable"));
            return hasUnsafe ? null : PlatformDependent0.getUnsafeUnavailabilityCause();
        }
        catch (Throwable t) {
            logger.trace("Could not determine if Unsafe is available", t);
            return new UnsupportedOperationException("Could not determine if Unsafe is available", t);
        }
    }

    public static boolean isJ9Jvm() {
        return IS_J9_JVM;
    }

    private static boolean isJ9Jvm0() {
        String vmName = SystemPropertyUtil.get("java.vm.name", "").toLowerCase();
        return vmName.startsWith("ibm j9") || vmName.startsWith("eclipse openj9");
    }

    public static boolean isIkvmDotNet() {
        return IS_IVKVM_DOT_NET;
    }

    private static boolean isIkvmDotNet0() {
        String vmName = SystemPropertyUtil.get("java.vm.name", "").toUpperCase(Locale.US);
        return vmName.equals("IKVM.NET");
    }

    private static long maxDirectMemory0() {
        long maxDirectMemory = 0L;
        ClassLoader systemClassLoader = null;
        try {
            systemClassLoader = PlatformDependent.getSystemClassLoader();
            String vmName = SystemPropertyUtil.get("java.vm.name", "").toLowerCase();
            if (!vmName.startsWith("ibm j9") && !vmName.startsWith("eclipse openj9")) {
                Class<?> vmClass = Class.forName("sun.misc.VM", true, systemClassLoader);
                Method m = vmClass.getDeclaredMethod("maxDirectMemory", new Class[0]);
                maxDirectMemory = ((Number)m.invoke(null, new Object[0])).longValue();
            }
        }
        catch (Throwable vmName) {
            // empty catch block
        }
        if (maxDirectMemory > 0L) {
            return maxDirectMemory;
        }
        try {
            Class<?> mgmtFactoryClass = Class.forName("java.lang.management.ManagementFactory", true, systemClassLoader);
            Class<?> runtimeClass = Class.forName("java.lang.management.RuntimeMXBean", true, systemClassLoader);
            Object runtime2 = mgmtFactoryClass.getDeclaredMethod("getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]);
            List vmArgs = (List)runtimeClass.getDeclaredMethod("getInputArguments", new Class[0]).invoke(runtime2, new Object[0]);
            for (int i2 = vmArgs.size() - 1; i2 >= 0; --i2) {
                Matcher m = MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN.matcher((CharSequence)vmArgs.get(i2));
                if (!m.matches()) continue;
                maxDirectMemory = Long.parseLong(m.group(1));
                switch (m.group(2).charAt(0)) {
                    case 'K': 
                    case 'k': {
                        maxDirectMemory *= 1024L;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        maxDirectMemory *= 0x100000L;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        maxDirectMemory *= 0x40000000L;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (maxDirectMemory <= 0L) {
            maxDirectMemory = Runtime.getRuntime().maxMemory();
            logger.debug("maxDirectMemory: {} bytes (maybe)", (Object)maxDirectMemory);
        } else {
            logger.debug("maxDirectMemory: {} bytes", (Object)maxDirectMemory);
        }
        return maxDirectMemory;
    }

    private static File tmpdir0() {
        File f;
        try {
            f = PlatformDependent.toDirectory(SystemPropertyUtil.get("io.netty.tmpdir"));
            if (f != null) {
                logger.debug("-Dio.netty.tmpdir: {}", (Object)f);
                return f;
            }
            f = PlatformDependent.toDirectory(SystemPropertyUtil.get("java.io.tmpdir"));
            if (f != null) {
                logger.debug("-Dio.netty.tmpdir: {} (java.io.tmpdir)", (Object)f);
                return f;
            }
            if (PlatformDependent.isWindows()) {
                f = PlatformDependent.toDirectory(System.getenv("TEMP"));
                if (f != null) {
                    logger.debug("-Dio.netty.tmpdir: {} (%TEMP%)", (Object)f);
                    return f;
                }
                String userprofile = System.getenv("USERPROFILE");
                if (userprofile != null) {
                    f = PlatformDependent.toDirectory(userprofile + "\\AppData\\Local\\Temp");
                    if (f != null) {
                        logger.debug("-Dio.netty.tmpdir: {} (%USERPROFILE%\\AppData\\Local\\Temp)", (Object)f);
                        return f;
                    }
                    f = PlatformDependent.toDirectory(userprofile + "\\Local Settings\\Temp");
                    if (f != null) {
                        logger.debug("-Dio.netty.tmpdir: {} (%USERPROFILE%\\Local Settings\\Temp)", (Object)f);
                        return f;
                    }
                }
            } else {
                f = PlatformDependent.toDirectory(System.getenv("TMPDIR"));
                if (f != null) {
                    logger.debug("-Dio.netty.tmpdir: {} ($TMPDIR)", (Object)f);
                    return f;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        f = PlatformDependent.isWindows() ? new File("C:\\Windows\\Temp") : new File("/tmp");
        logger.warn("Failed to get the temporary directory; falling back to: {}", (Object)f);
        return f;
    }

    private static File toDirectory(String path2) {
        if (path2 == null) {
            return null;
        }
        File f = new File(path2);
        f.mkdirs();
        if (!f.isDirectory()) {
            return null;
        }
        try {
            return f.getAbsoluteFile();
        }
        catch (Exception ignored) {
            return f;
        }
    }

    private static int bitMode0() {
        int bitMode = SystemPropertyUtil.getInt("io.netty.bitMode", 0);
        if (bitMode > 0) {
            logger.debug("-Dio.netty.bitMode: {}", (Object)bitMode);
            return bitMode;
        }
        bitMode = SystemPropertyUtil.getInt("sun.arch.data.model", 0);
        if (bitMode > 0) {
            logger.debug("-Dio.netty.bitMode: {} (sun.arch.data.model)", (Object)bitMode);
            return bitMode;
        }
        bitMode = SystemPropertyUtil.getInt("com.ibm.vm.bitmode", 0);
        if (bitMode > 0) {
            logger.debug("-Dio.netty.bitMode: {} (com.ibm.vm.bitmode)", (Object)bitMode);
            return bitMode;
        }
        String arch = SystemPropertyUtil.get("os.arch", "").toLowerCase(Locale.US).trim();
        if ("amd64".equals(arch) || "x86_64".equals(arch)) {
            bitMode = 64;
        } else if ("i386".equals(arch) || "i486".equals(arch) || "i586".equals(arch) || "i686".equals(arch)) {
            bitMode = 32;
        }
        if (bitMode > 0) {
            logger.debug("-Dio.netty.bitMode: {} (os.arch: {})", (Object)bitMode, (Object)arch);
        }
        String vm = SystemPropertyUtil.get("java.vm.name", "").toLowerCase(Locale.US);
        Pattern bitPattern = Pattern.compile("([1-9][0-9]+)-?bit");
        Matcher m = bitPattern.matcher(vm);
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        return 64;
    }

    private static int addressSize0() {
        if (!PlatformDependent.hasUnsafe()) {
            return -1;
        }
        return PlatformDependent0.addressSize();
    }

    private static long byteArrayBaseOffset0() {
        if (!PlatformDependent.hasUnsafe()) {
            return -1L;
        }
        return PlatformDependent0.byteArrayBaseOffset();
    }

    private static boolean equalsSafe(byte[] bytes1, int startPos1, byte[] bytes2, int startPos2, int length2) {
        int end2 = startPos1 + length2;
        while (startPos1 < end2) {
            if (bytes1[startPos1] != bytes2[startPos2]) {
                return false;
            }
            ++startPos1;
            ++startPos2;
        }
        return true;
    }

    private static boolean isZeroSafe(byte[] bytes2, int startPos, int length2) {
        int end2 = startPos + length2;
        while (startPos < end2) {
            if (bytes2[startPos] != 0) {
                return false;
            }
            ++startPos;
        }
        return true;
    }

    static int hashCodeAsciiSafe(byte[] bytes2, int startPos, int length2) {
        int hash2 = -1028477387;
        int remainingBytes = length2 & 7;
        int end2 = startPos + remainingBytes;
        for (int i2 = startPos - 8 + length2; i2 >= end2; i2 -= 8) {
            hash2 = PlatformDependent0.hashCodeAsciiCompute(PlatformDependent.getLongSafe(bytes2, i2), hash2);
        }
        switch (remainingBytes) {
            case 7: {
                return ((hash2 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(bytes2[startPos])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(bytes2, startPos + 1))) * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(bytes2, startPos + 3));
            }
            case 6: {
                return (hash2 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(bytes2, startPos))) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(bytes2, startPos + 2));
            }
            case 5: {
                return (hash2 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(bytes2[startPos])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(bytes2, startPos + 1));
            }
            case 4: {
                return hash2 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(bytes2, startPos));
            }
            case 3: {
                return (hash2 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(bytes2[startPos])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(bytes2, startPos + 1));
            }
            case 2: {
                return hash2 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(bytes2, startPos));
            }
            case 1: {
                return hash2 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(bytes2[startPos]);
            }
        }
        return hash2;
    }

    public static String normalizedArch() {
        return NORMALIZED_ARCH;
    }

    public static String normalizedOs() {
        return NORMALIZED_OS;
    }

    public static Set<String> normalizedLinuxClassifiers() {
        return LINUX_OS_CLASSIFIERS;
    }

    private static void addClassifier(Set<String> allowed, Set<String> dest, String ... maybeClassifiers) {
        for (String id2 : maybeClassifiers) {
            if (!allowed.contains(id2)) continue;
            dest.add(id2);
        }
    }

    private static String normalizeOsReleaseVariableValue(String value2) {
        return value2.trim().replaceAll("[\"']", "");
    }

    private static String normalize(String value2) {
        return value2.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private static String normalizeArch(String value2) {
        if ((value2 = PlatformDependent.normalize(value2)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (value2.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (value2.matches("^(ia64|itanium64)$")) {
            return "itanium_64";
        }
        if (value2.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (value2.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (value2.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(value2)) {
            return "aarch_64";
        }
        if (value2.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if ("ppc64".equals(value2)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(value2)) {
            return "ppcle_64";
        }
        if ("s390".equals(value2)) {
            return "s390_32";
        }
        if ("s390x".equals(value2)) {
            return "s390_64";
        }
        return "unknown";
    }

    private static String normalizeOs(String value2) {
        if ((value2 = PlatformDependent.normalize(value2)).startsWith("aix")) {
            return "aix";
        }
        if (value2.startsWith("hpux")) {
            return "hpux";
        }
        if (value2.startsWith("os400") && (value2.length() <= 5 || !Character.isDigit(value2.charAt(5)))) {
            return "os400";
        }
        if (value2.startsWith("linux")) {
            return "linux";
        }
        if (value2.startsWith("macosx") || value2.startsWith("osx")) {
            return "osx";
        }
        if (value2.startsWith("freebsd")) {
            return "freebsd";
        }
        if (value2.startsWith("openbsd")) {
            return "openbsd";
        }
        if (value2.startsWith("netbsd")) {
            return "netbsd";
        }
        if (value2.startsWith("solaris") || value2.startsWith("sunos")) {
            return "sunos";
        }
        if (value2.startsWith("windows")) {
            return "windows";
        }
        return "unknown";
    }

    private PlatformDependent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        CAN_ENABLE_TCP_NODELAY_BY_DEFAULT = !PlatformDependent.isAndroid();
        UNSAFE_UNAVAILABILITY_CAUSE = PlatformDependent.unsafeUnavailabilityCause0();
        MAX_DIRECT_MEMORY = PlatformDependent.maxDirectMemory0();
        BYTE_ARRAY_BASE_OFFSET = PlatformDependent.byteArrayBaseOffset0();
        TMPDIR = PlatformDependent.tmpdir0();
        BIT_MODE = PlatformDependent.bitMode0();
        NORMALIZED_ARCH = PlatformDependent.normalizeArch(SystemPropertyUtil.get("os.arch", ""));
        NORMALIZED_OS = PlatformDependent.normalizeOs(SystemPropertyUtil.get("os.name", ""));
        ALLOWED_LINUX_OS_CLASSIFIERS = new String[]{"fedora", "suse", "arch"};
        ADDRESS_SIZE = PlatformDependent.addressSize0();
        BIG_ENDIAN_NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        NOOP = new Cleaner(){

            @Override
            public void freeDirectBuffer(ByteBuffer buffer) {
            }
        };
        RANDOM_PROVIDER = PlatformDependent.javaVersion() >= 7 ? new ThreadLocalRandomProvider(){

            @Override
            @SuppressJava6Requirement(reason="Usage guarded by java version check")
            public Random current() {
                return java.util.concurrent.ThreadLocalRandom.current();
            }
        } : new ThreadLocalRandomProvider(){

            @Override
            public Random current() {
                return ThreadLocalRandom.current();
            }
        };
        long maxDirectMemory = SystemPropertyUtil.getLong("io.netty.maxDirectMemory", -1L);
        if (maxDirectMemory == 0L || !PlatformDependent.hasUnsafe() || !PlatformDependent0.hasDirectBufferNoCleanerConstructor()) {
            USE_DIRECT_BUFFER_NO_CLEANER = false;
            DIRECT_MEMORY_COUNTER = null;
        } else {
            USE_DIRECT_BUFFER_NO_CLEANER = true;
            DIRECT_MEMORY_COUNTER = maxDirectMemory < 0L ? ((maxDirectMemory = MAX_DIRECT_MEMORY) <= 0L ? null : new AtomicLong()) : new AtomicLong();
        }
        logger.debug("-Dio.netty.maxDirectMemory: {} bytes", (Object)maxDirectMemory);
        DIRECT_MEMORY_LIMIT = maxDirectMemory >= 1L ? maxDirectMemory : MAX_DIRECT_MEMORY;
        int tryAllocateUninitializedArray = SystemPropertyUtil.getInt("io.netty.uninitializedArrayAllocationThreshold", 1024);
        UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD = PlatformDependent.javaVersion() >= 9 && PlatformDependent0.hasAllocateArrayMethod() ? tryAllocateUninitializedArray : -1;
        logger.debug("-Dio.netty.uninitializedArrayAllocationThreshold: {}", (Object)UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD);
        MAYBE_SUPER_USER = PlatformDependent.maybeSuperUser0();
        CLEANER = !PlatformDependent.isAndroid() ? (PlatformDependent.javaVersion() >= 9 ? (CleanerJava9.isSupported() ? new CleanerJava9() : NOOP) : (CleanerJava6.isSupported() ? new CleanerJava6() : NOOP)) : NOOP;
        boolean bl = DIRECT_BUFFER_PREFERRED = CLEANER != NOOP && !SystemPropertyUtil.getBoolean("io.netty.noPreferDirect", false);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noPreferDirect: {}", (Object)(!DIRECT_BUFFER_PREFERRED ? 1 : 0));
        }
        if (CLEANER == NOOP && !PlatformDependent0.isExplicitNoUnsafe()) {
            logger.info("Your platform does not provide complete low-level API for accessing direct buffers reliably. Unless explicitly requested, heap buffer will always be preferred to avoid potential system instability.");
        }
        String[] OS_RELEASE_FILES = new String[]{"/etc/os-release", "/usr/lib/os-release"};
        String LINUX_ID_PREFIX = "ID=";
        String LINUX_ID_LIKE_PREFIX = "ID_LIKE=";
        Set<String> allowedClassifiers = new HashSet<String>(Arrays.asList(ALLOWED_LINUX_OS_CLASSIFIERS));
        allowedClassifiers = Collections.unmodifiableSet(allowedClassifiers);
        LinkedHashSet<String> availableClassifiers = new LinkedHashSet<String>();
        for (String osReleaseFileName : OS_RELEASE_FILES) {
            File file2 = new File(osReleaseFileName);
            if (!file2.exists()) continue;
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), CharsetUtil.UTF_8));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("ID=")) {
                        String id2 = PlatformDependent.normalizeOsReleaseVariableValue(line.substring("ID=".length()));
                        PlatformDependent.addClassifier(allowedClassifiers, availableClassifiers, id2);
                        continue;
                    }
                    if (!line.startsWith("ID_LIKE=")) continue;
                    line = PlatformDependent.normalizeOsReleaseVariableValue(line.substring("ID_LIKE=".length()));
                    PlatformDependent.addClassifier(allowedClassifiers, availableClassifiers, line.split("[ ]+"));
                }
                break;
            }
            catch (IOException iOException) {
                break;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        LINUX_OS_CLASSIFIERS = Collections.unmodifiableSet(availableClassifiers);
    }

    private static interface ThreadLocalRandomProvider {
        public Random current();
    }

    private static final class AtomicLongCounter
    extends AtomicLong
    implements LongCounter {
        private static final long serialVersionUID = 4074772784610639305L;

        private AtomicLongCounter() {
        }

        @Override
        public void add(long delta) {
            this.addAndGet(delta);
        }

        @Override
        public void increment() {
            this.incrementAndGet();
        }

        @Override
        public void decrement() {
            this.decrementAndGet();
        }

        @Override
        public long value() {
            return this.get();
        }
    }

    private static final class Mpsc {
        private static final boolean USE_MPSC_CHUNKED_ARRAY_QUEUE;

        private Mpsc() {
        }

        static <T> Queue<T> newMpscQueue(int maxCapacity) {
            int capacity = Math.max(Math.min(maxCapacity, 0x40000000), 2048);
            return USE_MPSC_CHUNKED_ARRAY_QUEUE ? new MpscChunkedArrayQueue(1024, capacity) : new MpscGrowableAtomicArrayQueue(1024, capacity);
        }

        static <T> Queue<T> newMpscQueue() {
            return USE_MPSC_CHUNKED_ARRAY_QUEUE ? new MpscUnboundedArrayQueue(1024) : new MpscUnboundedAtomicArrayQueue(1024);
        }

        static {
            Object unsafe = null;
            if (PlatformDependent.hasUnsafe()) {
                unsafe = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return UnsafeAccess.UNSAFE;
                    }
                });
            }
            if (unsafe == null) {
                logger.debug("org.jctools-core.MpscChunkedArrayQueue: unavailable");
                USE_MPSC_CHUNKED_ARRAY_QUEUE = false;
            } else {
                logger.debug("org.jctools-core.MpscChunkedArrayQueue: available");
                USE_MPSC_CHUNKED_ARRAY_QUEUE = true;
            }
        }
    }
}

