/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.cipher;

import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.apache.commons.crypto.Crypto;
import org.apache.commons.crypto.cipher.OpenSslNative;
import org.apache.commons.crypto.utils.Utils;

final class OpenSsl {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 0;
    private long context = 0L;
    private final int algorithm;
    private final int padding;
    private static final Throwable loadingFailureReason;

    public static Throwable getLoadingFailureReason() {
        return loadingFailureReason;
    }

    private OpenSsl(long context, int algorithm, int padding) {
        this.context = context;
        this.algorithm = algorithm;
        this.padding = padding;
    }

    public static OpenSsl getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (loadingFailureReason != null) {
            throw new IllegalStateException(loadingFailureReason);
        }
        Transform transform = OpenSsl.tokenizeTransformation(transformation);
        int algorithmMode = AlgorithmMode.get(transform.algorithm, transform.mode);
        int padding = Padding.get(transform.padding);
        long context = OpenSslNative.initContext(algorithmMode, padding);
        return new OpenSsl(context, algorithmMode, padding);
    }

    private static Transform tokenizeTransformation(String transformation) throws NoSuchAlgorithmException {
        if (transformation == null) {
            throw new NoSuchAlgorithmException("No transformation given.");
        }
        String[] parts = new String[3];
        int count2 = 0;
        StringTokenizer parser = new StringTokenizer(transformation, "/");
        while (parser.hasMoreTokens() && count2 < 3) {
            parts[count2++] = parser.nextToken().trim();
        }
        if (count2 != 3 || parser.hasMoreTokens()) {
            throw new NoSuchAlgorithmException("Invalid transformation format: " + transformation);
        }
        return new Transform(parts[0], parts[1], parts[2]);
    }

    public void init(int mode2, byte[] key2, byte[] iv) {
        this.context = OpenSslNative.init(this.context, mode2, this.algorithm, this.padding, key2, iv);
    }

    public int update(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        this.checkState();
        Utils.checkArgument(input.isDirect() && output.isDirect(), "Direct buffers are required.");
        int len = OpenSslNative.update(this.context, input, input.position(), input.remaining(), output, output.position(), output.remaining());
        input.position(input.limit());
        output.position(output.position() + len);
        return len;
    }

    public int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.checkState();
        return OpenSslNative.updateByteArray(this.context, input, inputOffset, inputLen, output, outputOffset, output.length - outputOffset);
    }

    public int doFinal(ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.checkState();
        Utils.checkArgument(output.isDirect(), "Direct buffer is required.");
        int len = OpenSslNative.doFinal(this.context, output, output.position(), output.remaining());
        output.position(output.position() + len);
        return len;
    }

    public int doFinal(byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.checkState();
        return OpenSslNative.doFinalByteArray(this.context, output, outputOffset, output.length - outputOffset);
    }

    public void clean() {
        if (this.context != 0L) {
            OpenSslNative.clean(this.context);
            this.context = 0L;
        }
    }

    private void checkState() {
        Utils.checkState(this.context != 0L);
    }

    protected void finalize() throws Throwable {
        this.clean();
    }

    static {
        Throwable loadingFailure = null;
        try {
            if (Crypto.isNativeCodeLoaded()) {
                OpenSslNative.initIDs();
            } else {
                loadingFailure = Crypto.getLoadingError();
            }
        }
        catch (Exception t) {
            loadingFailure = t;
        }
        catch (UnsatisfiedLinkError t) {
            loadingFailure = t;
        }
        finally {
            loadingFailureReason = loadingFailure;
        }
    }

    private static class Transform {
        final String algorithm;
        final String mode;
        final String padding;

        public Transform(String algorithm, String mode2, String padding) {
            this.algorithm = algorithm;
            this.mode = mode2;
            this.padding = padding;
        }
    }

    private static enum Padding {
        NoPadding,
        PKCS5Padding;


        static int get(String padding) throws NoSuchPaddingException {
            try {
                return Padding.valueOf(padding).ordinal();
            }
            catch (Exception e) {
                throw new NoSuchPaddingException("Doesn't support padding: " + padding);
            }
        }
    }

    private static enum AlgorithmMode {
        AES_CTR,
        AES_CBC;


        static int get(String algorithm, String mode2) throws NoSuchAlgorithmException {
            try {
                return AlgorithmMode.valueOf(algorithm + "_" + mode2).ordinal();
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException("Doesn't support algorithm: " + algorithm + " and mode: " + mode2);
            }
        }
    }
}

