/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Duration;
import java.time.Instant;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.RandomAccessFiles;
import org.apache.commons.io.ThreadUtils;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.CleaningPathVisitor;
import org.apache.commons.io.file.CopyDirectoryVisitor;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.DeletingPathVisitor;
import org.apache.commons.io.file.DirectoryStreamFilter;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.io.file.attribute.FileTimes;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOSupplier;

public final class PathUtils {
    private static final OpenOption[] OPEN_OPTIONS_TRUNCATE = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] OPEN_OPTIONS_APPEND = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];
    public static final DeleteOption[] EMPTY_DELETE_OPTION_ARRAY = new DeleteOption[0];
    public static final FileAttribute<?>[] EMPTY_FILE_ATTRIBUTE_ARRAY = new FileAttribute[0];
    public static final FileVisitOption[] EMPTY_FILE_VISIT_OPTION_ARRAY = new FileVisitOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];
    @Deprecated
    public static final LinkOption[] NOFOLLOW_LINK_OPTION_ARRAY = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    static final LinkOption NULL_LINK_OPTION = null;
    public static final OpenOption[] EMPTY_OPEN_OPTION_ARRAY = new OpenOption[0];
    public static final Path[] EMPTY_PATH_ARRAY = new Path[0];

    private static AccumulatorPathVisitor accumulate(Path directory, int maxDepth, FileVisitOption[] fileVisitOptions) throws IOException {
        return PathUtils.visitFileTree(AccumulatorPathVisitor.withLongCounters(), directory, PathUtils.toFileVisitOptionSet(fileVisitOptions), maxDepth);
    }

    public static Counters.PathCounters cleanDirectory(Path directory) throws IOException {
        return PathUtils.cleanDirectory(directory, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters cleanDirectory(Path directory, DeleteOption ... deleteOptions) throws IOException {
        return PathUtils.visitFileTree(new CleaningPathVisitor(Counters.longPathCounters(), deleteOptions, new String[0]), directory).getPathCounters();
    }

    private static int compareLastModifiedTimeTo(Path file2, FileTime fileTime, LinkOption ... options2) throws IOException {
        return PathUtils.getLastModifiedTime(file2, options2).compareTo(fileTime);
    }

    public static long copy(IOSupplier<InputStream> in, Path target, CopyOption ... copyOptions) throws IOException {
        try (InputStream inputStream = in.get();){
            long l = Files.copy(inputStream, target, copyOptions);
            return l;
        }
    }

    public static Counters.PathCounters copyDirectory(Path sourceDirectory, Path targetDirectory, CopyOption ... copyOptions) throws IOException {
        Path absoluteSource = sourceDirectory.toAbsolutePath();
        return PathUtils.visitFileTree(new CopyDirectoryVisitor(Counters.longPathCounters(), absoluteSource, targetDirectory, copyOptions), absoluteSource).getPathCounters();
    }

    public static Path copyFile(URL sourceFile, Path targetFile, CopyOption ... copyOptions) throws IOException {
        PathUtils.copy(sourceFile::openStream, targetFile, copyOptions);
        return targetFile;
    }

    public static Path copyFileToDirectory(Path sourceFile, Path targetDirectory, CopyOption ... copyOptions) throws IOException {
        return Files.copy(sourceFile, targetDirectory.resolve(sourceFile.getFileName()), copyOptions);
    }

    public static Path copyFileToDirectory(URL sourceFile, Path targetDirectory, CopyOption ... copyOptions) throws IOException {
        Path resolve = targetDirectory.resolve(FilenameUtils.getName(sourceFile.getFile()));
        PathUtils.copy(sourceFile::openStream, resolve, copyOptions);
        return resolve;
    }

    public static Counters.PathCounters countDirectory(Path directory) throws IOException {
        return PathUtils.visitFileTree(CountingPathVisitor.withLongCounters(), directory).getPathCounters();
    }

    public static Counters.PathCounters countDirectoryAsBigInteger(Path directory) throws IOException {
        return PathUtils.visitFileTree(CountingPathVisitor.withBigIntegerCounters(), directory).getPathCounters();
    }

    public static Path createParentDirectories(Path path2, FileAttribute<?> ... attrs) throws IOException {
        return PathUtils.createParentDirectories(path2, LinkOption.NOFOLLOW_LINKS, attrs);
    }

    public static Path createParentDirectories(Path path2, LinkOption linkOption, FileAttribute<?> ... attrs) throws IOException {
        Path parent = PathUtils.getParent(path2);
        Path path3 = parent = linkOption == LinkOption.NOFOLLOW_LINKS ? parent : PathUtils.readIfSymbolicLink(parent);
        if (parent == null) {
            return null;
        }
        boolean exists = linkOption == null ? Files.exists(parent, new LinkOption[0]) : Files.exists(parent, linkOption);
        return exists ? parent : Files.createDirectories(parent, attrs);
    }

    public static Path current() {
        return Paths.get(".", new String[0]);
    }

    public static Counters.PathCounters delete(Path path2) throws IOException {
        return PathUtils.delete(path2, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters delete(Path path2, DeleteOption ... deleteOptions) throws IOException {
        return Files.isDirectory(path2, LinkOption.NOFOLLOW_LINKS) ? PathUtils.deleteDirectory(path2, deleteOptions) : PathUtils.deleteFile(path2, deleteOptions);
    }

    public static Counters.PathCounters delete(Path path2, LinkOption[] linkOptions, DeleteOption ... deleteOptions) throws IOException {
        return Files.isDirectory(path2, linkOptions) ? PathUtils.deleteDirectory(path2, linkOptions, deleteOptions) : PathUtils.deleteFile(path2, linkOptions, deleteOptions);
    }

    public static Counters.PathCounters deleteDirectory(Path directory) throws IOException {
        return PathUtils.deleteDirectory(directory, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters deleteDirectory(Path directory, DeleteOption ... deleteOptions) throws IOException {
        LinkOption[] linkOptions = PathUtils.noFollowLinkOptionArray();
        return PathUtils.withPosixFileAttributes(PathUtils.getParent(directory), linkOptions, PathUtils.overrideReadOnly(deleteOptions), pfa -> PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), linkOptions, deleteOptions, new String[0]), directory).getPathCounters());
    }

    public static Counters.PathCounters deleteDirectory(Path directory, LinkOption[] linkOptions, DeleteOption ... deleteOptions) throws IOException {
        return PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), linkOptions, deleteOptions, new String[0]), directory).getPathCounters();
    }

    public static Counters.PathCounters deleteFile(Path file2) throws IOException {
        return PathUtils.deleteFile(file2, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters deleteFile(Path file2, DeleteOption ... deleteOptions) throws IOException {
        return PathUtils.deleteFile(file2, PathUtils.noFollowLinkOptionArray(), deleteOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counters.PathCounters deleteFile(Path file2, LinkOption[] linkOptions, DeleteOption ... deleteOptions) throws NoSuchFileException, IOException {
        if (Files.isDirectory(file2, linkOptions)) {
            throw new NoSuchFileException(file2.toString());
        }
        Counters.PathCounters pathCounts = Counters.longPathCounters();
        boolean exists = PathUtils.exists(file2, linkOptions);
        long size2 = exists && !Files.isSymbolicLink(file2) ? Files.size(file2) : 0L;
        try {
            if (Files.deleteIfExists(file2)) {
                pathCounts.getFileCounter().increment();
                pathCounts.getByteCounter().add(size2);
                return pathCounts;
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        Path parent = PathUtils.getParent(file2);
        PosixFileAttributes posixFileAttributes = null;
        try {
            if (PathUtils.overrideReadOnly(deleteOptions)) {
                posixFileAttributes = PathUtils.readPosixFileAttributes(parent, linkOptions);
                PathUtils.setReadOnly(file2, false, linkOptions);
            }
            long l = size2 = (exists = PathUtils.exists(file2, linkOptions)) && !Files.isSymbolicLink(file2) ? Files.size(file2) : 0L;
            if (Files.deleteIfExists(file2)) {
                pathCounts.getFileCounter().increment();
                pathCounts.getByteCounter().add(size2);
            }
        }
        finally {
            if (posixFileAttributes != null) {
                Files.setPosixFilePermissions(parent, posixFileAttributes.permissions());
            }
        }
        return pathCounts;
    }

    public static void deleteOnExit(Path path2) {
        Objects.requireNonNull(path2.toFile()).deleteOnExit();
    }

    public static boolean directoryAndFileContentEquals(Path path1, Path path2) throws IOException {
        return PathUtils.directoryAndFileContentEquals(path1, path2, EMPTY_LINK_OPTION_ARRAY, EMPTY_OPEN_OPTION_ARRAY, EMPTY_FILE_VISIT_OPTION_ARRAY);
    }

    public static boolean directoryAndFileContentEquals(Path path1, Path path2, LinkOption[] linkOptions, OpenOption[] openOptions, FileVisitOption[] fileVisitOption) throws IOException {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        if (PathUtils.notExists(path1, new LinkOption[0]) && PathUtils.notExists(path2, new LinkOption[0])) {
            return true;
        }
        RelativeSortedPaths relativeSortedPaths = new RelativeSortedPaths(path1, path2, Integer.MAX_VALUE, linkOptions, fileVisitOption);
        if (!relativeSortedPaths.equals) {
            return false;
        }
        List<Path> fileList1 = relativeSortedPaths.relativeFileList1;
        List<Path> fileList2 = relativeSortedPaths.relativeFileList2;
        for (Path path3 : fileList1) {
            int binarySearch = Collections.binarySearch(fileList2, path3);
            if (binarySearch <= -1) {
                throw new IllegalStateException("Unexpected mismatch.");
            }
            if (PathUtils.fileContentEquals(path1.resolve(path3), path2.resolve(path3), linkOptions, openOptions)) continue;
            return false;
        }
        return true;
    }

    public static boolean directoryContentEquals(Path path1, Path path2) throws IOException {
        return PathUtils.directoryContentEquals(path1, path2, Integer.MAX_VALUE, EMPTY_LINK_OPTION_ARRAY, EMPTY_FILE_VISIT_OPTION_ARRAY);
    }

    public static boolean directoryContentEquals(Path path1, Path path2, int maxDepth, LinkOption[] linkOptions, FileVisitOption[] fileVisitOptions) throws IOException {
        return new RelativeSortedPaths((Path)path1, (Path)path2, (int)maxDepth, (LinkOption[])linkOptions, (FileVisitOption[])fileVisitOptions).equals;
    }

    private static boolean exists(Path path2, LinkOption ... options2) {
        Objects.requireNonNull(path2, "path");
        return options2 != null ? Files.exists(path2, options2) : Files.exists(path2, new LinkOption[0]);
    }

    public static boolean fileContentEquals(Path path1, Path path2) throws IOException {
        return PathUtils.fileContentEquals(path1, path2, EMPTY_LINK_OPTION_ARRAY, EMPTY_OPEN_OPTION_ARRAY);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean fileContentEquals(Path path1, Path path2, LinkOption[] linkOptions, OpenOption[] openOptions) throws IOException {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        Path nPath1 = path1.normalize();
        Path nPath2 = path2.normalize();
        boolean path1Exists = PathUtils.exists(nPath1, linkOptions);
        if (path1Exists != PathUtils.exists(nPath2, linkOptions)) {
            return false;
        }
        if (!path1Exists) {
            return true;
        }
        if (Files.isDirectory(nPath1, linkOptions)) {
            throw new IOException("Can't compare directories, only files: " + nPath1);
        }
        if (Files.isDirectory(nPath2, linkOptions)) {
            throw new IOException("Can't compare directories, only files: " + nPath2);
        }
        if (Files.size(nPath1) != Files.size(nPath2)) {
            return false;
        }
        if (path1.equals(path2)) {
            return true;
        }
        try (RandomAccessFile raf1 = RandomAccessFileMode.READ_ONLY.create(path1.toRealPath(linkOptions));){
            boolean bl;
            block34: {
                RandomAccessFile raf2 = RandomAccessFileMode.READ_ONLY.create(path2.toRealPath(linkOptions));
                try {
                    bl = RandomAccessFiles.contentEquals(raf1, raf2);
                    if (raf2 == null) break block34;
                }
                catch (Throwable throwable) {
                    if (raf2 != null) {
                        try {
                            raf2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                raf2.close();
            }
            return bl;
        }
        catch (UnsupportedOperationException e) {
            try (InputStream inputStream1 = Files.newInputStream(nPath1, openOptions);){
                boolean bl;
                block35: {
                    InputStream inputStream2 = Files.newInputStream(nPath2, openOptions);
                    try {
                        bl = IOUtils.contentEquals(inputStream1, inputStream2);
                        if (inputStream2 == null) break block35;
                    }
                    catch (Throwable throwable) {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    inputStream2.close();
                }
                return bl;
            }
        }
    }

    public static Path[] filter(PathFilter filter, Path ... paths) {
        Objects.requireNonNull(filter, "filter");
        if (paths == null) {
            return EMPTY_PATH_ARRAY;
        }
        return PathUtils.filterPaths(filter, Stream.of(paths), Collectors.toList()).toArray(EMPTY_PATH_ARRAY);
    }

    private static <R, A> R filterPaths(PathFilter filter, Stream<Path> stream, Collector<? super Path, A, R> collector) {
        Objects.requireNonNull(filter, "filter");
        Objects.requireNonNull(collector, "collector");
        if (stream == null) {
            return Stream.empty().collect(collector);
        }
        return stream.filter(p2 -> {
            try {
                return p2 != null && filter.accept((Path)p2, PathUtils.readBasicFileAttributes(p2)) == FileVisitResult.CONTINUE;
            }
            catch (IOException e) {
                return false;
            }
        }).collect(collector);
    }

    public static List<AclEntry> getAclEntryList(Path sourcePath) throws IOException {
        AclFileAttributeView fileAttributeView = PathUtils.getAclFileAttributeView(sourcePath, new LinkOption[0]);
        return fileAttributeView == null ? null : fileAttributeView.getAcl();
    }

    public static AclFileAttributeView getAclFileAttributeView(Path path2, LinkOption ... options2) {
        return Files.getFileAttributeView(path2, AclFileAttributeView.class, options2);
    }

    public static DosFileAttributeView getDosFileAttributeView(Path path2, LinkOption ... options2) {
        return Files.getFileAttributeView(path2, DosFileAttributeView.class, options2);
    }

    public static FileTime getLastModifiedFileTime(File file2) throws IOException {
        return PathUtils.getLastModifiedFileTime(file2.toPath(), null, EMPTY_LINK_OPTION_ARRAY);
    }

    public static FileTime getLastModifiedFileTime(Path path2, FileTime defaultIfAbsent, LinkOption ... options2) throws IOException {
        return Files.exists(path2, new LinkOption[0]) ? PathUtils.getLastModifiedTime(path2, options2) : defaultIfAbsent;
    }

    public static FileTime getLastModifiedFileTime(Path path2, LinkOption ... options2) throws IOException {
        return PathUtils.getLastModifiedFileTime(path2, null, options2);
    }

    public static FileTime getLastModifiedFileTime(URI uri) throws IOException {
        return PathUtils.getLastModifiedFileTime(Paths.get(uri), null, EMPTY_LINK_OPTION_ARRAY);
    }

    public static FileTime getLastModifiedFileTime(URL url) throws IOException, URISyntaxException {
        return PathUtils.getLastModifiedFileTime(url.toURI());
    }

    private static FileTime getLastModifiedTime(Path path2, LinkOption ... options2) throws IOException {
        return Files.getLastModifiedTime(Objects.requireNonNull(path2, "path"), options2);
    }

    private static Path getParent(Path path2) {
        return path2 == null ? null : path2.getParent();
    }

    public static PosixFileAttributeView getPosixFileAttributeView(Path path2, LinkOption ... options2) {
        return Files.getFileAttributeView(path2, PosixFileAttributeView.class, options2);
    }

    public static Path getTempDirectory() {
        return Paths.get(FileUtils.getTempDirectoryPath(), new String[0]);
    }

    public static boolean isDirectory(Path path2, LinkOption ... options2) {
        return path2 != null && Files.isDirectory(path2, options2);
    }

    public static boolean isEmpty(Path path2) throws IOException {
        return Files.isDirectory(path2, new LinkOption[0]) ? PathUtils.isEmptyDirectory(path2) : PathUtils.isEmptyFile(path2);
    }

    public static boolean isEmptyDirectory(Path directory) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            boolean bl = !directoryStream.iterator().hasNext();
            return bl;
        }
    }

    public static boolean isEmptyFile(Path file2) throws IOException {
        return Files.size(file2) <= 0L;
    }

    public static boolean isNewer(Path file2, ChronoZonedDateTime<?> czdt, LinkOption ... options2) throws IOException {
        Objects.requireNonNull(czdt, "czdt");
        return PathUtils.isNewer(file2, czdt.toInstant(), options2);
    }

    public static boolean isNewer(Path file2, FileTime fileTime, LinkOption ... options2) throws IOException {
        if (PathUtils.notExists(file2, new LinkOption[0])) {
            return false;
        }
        return PathUtils.compareLastModifiedTimeTo(file2, fileTime, options2) > 0;
    }

    public static boolean isNewer(Path file2, Instant instant, LinkOption ... options2) throws IOException {
        return PathUtils.isNewer(file2, FileTime.from(instant), options2);
    }

    public static boolean isNewer(Path file2, long timeMillis, LinkOption ... options2) throws IOException {
        return PathUtils.isNewer(file2, FileTime.fromMillis(timeMillis), options2);
    }

    public static boolean isNewer(Path file2, Path reference2) throws IOException {
        return PathUtils.isNewer(file2, PathUtils.getLastModifiedTime(reference2, new LinkOption[0]), new LinkOption[0]);
    }

    public static boolean isOlder(Path file2, FileTime fileTime, LinkOption ... options2) throws IOException {
        if (PathUtils.notExists(file2, new LinkOption[0])) {
            return false;
        }
        return PathUtils.compareLastModifiedTimeTo(file2, fileTime, options2) < 0;
    }

    public static boolean isOlder(Path file2, Instant instant, LinkOption ... options2) throws IOException {
        return PathUtils.isOlder(file2, FileTime.from(instant), options2);
    }

    public static boolean isOlder(Path file2, long timeMillis, LinkOption ... options2) throws IOException {
        return PathUtils.isOlder(file2, FileTime.fromMillis(timeMillis), options2);
    }

    public static boolean isOlder(Path file2, Path reference2) throws IOException {
        return PathUtils.isOlder(file2, PathUtils.getLastModifiedTime(reference2, new LinkOption[0]), new LinkOption[0]);
    }

    public static boolean isPosix(Path test2, LinkOption ... options2) {
        return PathUtils.exists(test2, options2) && PathUtils.readPosixFileAttributes(test2, options2) != null;
    }

    public static boolean isRegularFile(Path path2, LinkOption ... options2) {
        return path2 != null && Files.isRegularFile(path2, options2);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir, PathFilter pathFilter) throws IOException {
        return Files.newDirectoryStream(dir, new DirectoryStreamFilter(pathFilter));
    }

    public static OutputStream newOutputStream(Path path2, boolean append2) throws IOException {
        return PathUtils.newOutputStream(path2, EMPTY_LINK_OPTION_ARRAY, append2 ? OPEN_OPTIONS_APPEND : OPEN_OPTIONS_TRUNCATE);
    }

    static OutputStream newOutputStream(Path path2, LinkOption[] linkOptions, OpenOption ... openOptions) throws IOException {
        if (!PathUtils.exists(path2, linkOptions)) {
            PathUtils.createParentDirectories(path2, linkOptions != null && linkOptions.length > 0 ? linkOptions[0] : NULL_LINK_OPTION, new FileAttribute[0]);
        }
        ArrayList<OpenOption> list2 = new ArrayList<OpenOption>(Arrays.asList(openOptions != null ? openOptions : EMPTY_OPEN_OPTION_ARRAY));
        list2.addAll(Arrays.asList(linkOptions != null ? linkOptions : EMPTY_LINK_OPTION_ARRAY));
        return Files.newOutputStream(path2, list2.toArray(EMPTY_OPEN_OPTION_ARRAY));
    }

    public static LinkOption[] noFollowLinkOptionArray() {
        return (LinkOption[])NOFOLLOW_LINK_OPTION_ARRAY.clone();
    }

    private static boolean notExists(Path path2, LinkOption ... options2) {
        return Files.notExists(Objects.requireNonNull(path2, "path"), options2);
    }

    private static boolean overrideReadOnly(DeleteOption ... deleteOptions) {
        if (deleteOptions == null) {
            return false;
        }
        return Stream.of(deleteOptions).anyMatch(e -> e == StandardDeleteOption.OVERRIDE_READ_ONLY);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path2, Class<A> type2, LinkOption ... options2) {
        try {
            return path2 == null ? null : (A)Files.readAttributes(path2, type2, options2);
        }
        catch (IOException | UnsupportedOperationException e) {
            return null;
        }
    }

    public static BasicFileAttributes readBasicFileAttributes(Path path2) throws IOException {
        return Files.readAttributes(path2, BasicFileAttributes.class, new LinkOption[0]);
    }

    public static BasicFileAttributes readBasicFileAttributes(Path path2, LinkOption ... options2) {
        return PathUtils.readAttributes(path2, BasicFileAttributes.class, options2);
    }

    @Deprecated
    public static BasicFileAttributes readBasicFileAttributesUnchecked(Path path2) {
        return PathUtils.readBasicFileAttributes(path2, EMPTY_LINK_OPTION_ARRAY);
    }

    public static DosFileAttributes readDosFileAttributes(Path path2, LinkOption ... options2) {
        return PathUtils.readAttributes(path2, DosFileAttributes.class, options2);
    }

    private static Path readIfSymbolicLink(Path path2) throws IOException {
        return path2 != null ? (Files.isSymbolicLink(path2) ? Files.readSymbolicLink(path2) : path2) : null;
    }

    public static BasicFileAttributes readOsFileAttributes(Path path2, LinkOption ... options2) {
        PosixFileAttributes fileAttributes = PathUtils.readPosixFileAttributes(path2, options2);
        return fileAttributes != null ? fileAttributes : PathUtils.readDosFileAttributes(path2, options2);
    }

    public static PosixFileAttributes readPosixFileAttributes(Path path2, LinkOption ... options2) {
        return PathUtils.readAttributes(path2, PosixFileAttributes.class, options2);
    }

    public static String readString(Path path2, Charset charset) throws IOException {
        return new String(Files.readAllBytes(path2), Charsets.toCharset(charset));
    }

    static List<Path> relativize(Collection<Path> collection, Path parent, boolean sort2, Comparator<? super Path> comparator) {
        Stream<Path> stream = collection.stream().map(parent::relativize);
        if (sort2) {
            stream = comparator == null ? stream.sorted() : stream.sorted(comparator);
        }
        return stream.collect(Collectors.toList());
    }

    private static Path requireExists(Path file2, String fileParamName, LinkOption ... options2) {
        Objects.requireNonNull(file2, fileParamName);
        if (!PathUtils.exists(file2, options2)) {
            throw new IllegalArgumentException("File system element for parameter '" + fileParamName + "' does not exist: '" + file2 + "'");
        }
        return file2;
    }

    private static boolean setDosReadOnly(Path path2, boolean readOnly, LinkOption ... linkOptions) throws IOException {
        DosFileAttributeView dosFileAttributeView = PathUtils.getDosFileAttributeView(path2, linkOptions);
        if (dosFileAttributeView != null) {
            dosFileAttributeView.setReadOnly(readOnly);
            return true;
        }
        return false;
    }

    public static void setLastModifiedTime(Path sourceFile, Path targetFile) throws IOException {
        Objects.requireNonNull(sourceFile, "sourceFile");
        Files.setLastModifiedTime(targetFile, PathUtils.getLastModifiedTime(sourceFile, new LinkOption[0]));
    }

    private static boolean setPosixDeletePermissions(Path parent, boolean enableDeleteChildren, LinkOption ... linkOptions) throws IOException {
        return PathUtils.setPosixPermissions(parent, enableDeleteChildren, Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE), linkOptions);
    }

    private static boolean setPosixPermissions(Path path2, boolean addPermissions, List<PosixFilePermission> updatePermissions, LinkOption ... linkOptions) throws IOException {
        if (path2 != null) {
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path2, linkOptions);
            if (addPermissions) {
                permissions.addAll(updatePermissions);
            } else {
                permissions.removeAll(updatePermissions);
            }
            Files.setPosixFilePermissions(path2, permissions);
            return true;
        }
        return false;
    }

    private static void setPosixReadOnlyFile(Path path2, boolean readOnly, LinkOption ... linkOptions) throws IOException {
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path2, linkOptions);
        List<PosixFilePermission> readPermissions = Arrays.asList(PosixFilePermission.OWNER_READ);
        List<PosixFilePermission> writePermissions = Arrays.asList(PosixFilePermission.OWNER_WRITE);
        if (readOnly) {
            permissions.addAll(readPermissions);
            permissions.removeAll(writePermissions);
        } else {
            permissions.addAll(readPermissions);
            permissions.addAll(writePermissions);
        }
        Files.setPosixFilePermissions(path2, permissions);
    }

    public static Path setReadOnly(Path path2, boolean readOnly, LinkOption ... linkOptions) throws IOException {
        try {
            if (PathUtils.setDosReadOnly(path2, readOnly, linkOptions)) {
                return path2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path parent = PathUtils.getParent(path2);
        if (!PathUtils.isPosix(parent, linkOptions)) {
            throw new IOException(String.format("DOS or POSIX file operations not available for '%s' %s", path2, Arrays.toString(linkOptions)));
        }
        if (readOnly) {
            PathUtils.setPosixReadOnlyFile(path2, readOnly, linkOptions);
            PathUtils.setPosixDeletePermissions(parent, false, linkOptions);
        } else {
            PathUtils.setPosixDeletePermissions(parent, true, linkOptions);
        }
        return path2;
    }

    public static long sizeOf(Path path2) throws IOException {
        PathUtils.requireExists(path2, "path", new LinkOption[0]);
        return Files.isDirectory(path2, new LinkOption[0]) ? PathUtils.sizeOfDirectory(path2) : Files.size(path2);
    }

    public static BigInteger sizeOfAsBigInteger(Path path2) throws IOException {
        PathUtils.requireExists(path2, "path", new LinkOption[0]);
        return Files.isDirectory(path2, new LinkOption[0]) ? PathUtils.sizeOfDirectoryAsBigInteger(path2) : BigInteger.valueOf(Files.size(path2));
    }

    public static long sizeOfDirectory(Path directory) throws IOException {
        return PathUtils.countDirectory(directory).getByteCounter().getLong();
    }

    public static BigInteger sizeOfDirectoryAsBigInteger(Path directory) throws IOException {
        return PathUtils.countDirectoryAsBigInteger(directory).getByteCounter().getBigInteger();
    }

    static Set<FileVisitOption> toFileVisitOptionSet(FileVisitOption ... fileVisitOptions) {
        return fileVisitOptions == null ? EnumSet.noneOf(FileVisitOption.class) : Stream.of(fileVisitOptions).collect(Collectors.toSet());
    }

    public static Path touch(Path file2) throws IOException {
        Objects.requireNonNull(file2, "file");
        if (!Files.exists(file2, new LinkOption[0])) {
            PathUtils.createParentDirectories(file2, new FileAttribute[0]);
            Files.createFile(file2, new FileAttribute[0]);
        } else {
            FileTimes.setLastModifiedTime(file2);
        }
        return file2;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T visitor, Path directory) throws IOException {
        Files.walkFileTree(directory, visitor);
        return visitor;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T visitor, Path start2, Set<FileVisitOption> options2, int maxDepth) throws IOException {
        Files.walkFileTree(start2, options2, maxDepth, visitor);
        return visitor;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T visitor, String first2, String ... more) throws IOException {
        return PathUtils.visitFileTree(visitor, Paths.get(first2, more));
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T visitor, URI uri) throws IOException {
        return PathUtils.visitFileTree(visitor, Paths.get(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitFor(Path file2, Duration timeout2, LinkOption ... options2) {
        Objects.requireNonNull(file2, "file");
        Instant finishInstant = Instant.now().plus(timeout2);
        boolean interrupted = false;
        long minSleepMillis = 100L;
        try {
            while (!PathUtils.exists(file2, options2)) {
                Instant now = Instant.now();
                if (now.isAfter(finishInstant)) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    ThreadUtils.sleep(Duration.ofMillis(Math.min(100L, finishInstant.minusMillis(now.toEpochMilli()).toEpochMilli())));
                }
                catch (InterruptedException ignore) {
                    interrupted = true;
                }
                catch (Exception ex) {
                    break;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return PathUtils.exists(file2, options2);
    }

    public static Stream<Path> walk(Path start2, PathFilter pathFilter, int maxDepth, boolean readAttributes, FileVisitOption ... options2) throws IOException {
        return Files.walk(start2, maxDepth, options2).filter(path2 -> pathFilter.accept((Path)path2, readAttributes ? PathUtils.readBasicFileAttributesUnchecked(path2) : null) == FileVisitResult.CONTINUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R> R withPosixFileAttributes(Path path2, LinkOption[] linkOptions, boolean overrideReadOnly, IOFunction<PosixFileAttributes, R> function) throws IOException {
        PosixFileAttributes posixFileAttributes = overrideReadOnly ? PathUtils.readPosixFileAttributes(path2, linkOptions) : null;
        try {
            R r = function.apply(posixFileAttributes);
            return r;
        }
        finally {
            if (posixFileAttributes != null && path2 != null && Files.exists(path2, linkOptions)) {
                Files.setPosixFilePermissions(path2, posixFileAttributes.permissions());
            }
        }
    }

    public static Path writeString(Path path2, CharSequence charSequence, Charset charset, OpenOption ... openOptions) throws IOException {
        Objects.requireNonNull(path2, "path");
        Objects.requireNonNull(charSequence, "charSequence");
        Files.write(path2, String.valueOf(charSequence).getBytes(Charsets.toCharset(charset)), openOptions);
        return path2;
    }

    private PathUtils() {
    }

    private static final class RelativeSortedPaths {
        final boolean equals;
        final List<Path> relativeFileList1;
        final List<Path> relativeFileList2;

        private RelativeSortedPaths(Path dir1, Path dir2, int maxDepth, LinkOption[] linkOptions, FileVisitOption[] fileVisitOptions) throws IOException {
            List<Path> tmpRelativeFileList1 = null;
            List<Path> tmpRelativeFileList2 = null;
            if (dir1 == null && dir2 == null) {
                this.equals = true;
            } else if (dir1 == null ^ dir2 == null) {
                this.equals = false;
            } else {
                boolean parentDirNotExists1 = Files.notExists(dir1, linkOptions);
                boolean parentDirNotExists2 = Files.notExists(dir2, linkOptions);
                if (parentDirNotExists1 || parentDirNotExists2) {
                    this.equals = parentDirNotExists1 && parentDirNotExists2;
                } else {
                    AccumulatorPathVisitor visitor1 = PathUtils.accumulate(dir1, maxDepth, fileVisitOptions);
                    AccumulatorPathVisitor visitor2 = PathUtils.accumulate(dir2, maxDepth, fileVisitOptions);
                    if (visitor1.getDirList().size() != visitor2.getDirList().size() || visitor1.getFileList().size() != visitor2.getFileList().size()) {
                        this.equals = false;
                    } else {
                        List<Path> tmpRelativeDirList2;
                        List<Path> tmpRelativeDirList1 = visitor1.relativizeDirectories(dir1, true, null);
                        if (!tmpRelativeDirList1.equals(tmpRelativeDirList2 = visitor2.relativizeDirectories(dir2, true, null))) {
                            this.equals = false;
                        } else {
                            tmpRelativeFileList1 = visitor1.relativizeFiles(dir1, true, null);
                            tmpRelativeFileList2 = visitor2.relativizeFiles(dir2, true, null);
                            this.equals = tmpRelativeFileList1.equals(tmpRelativeFileList2);
                        }
                    }
                }
            }
            this.relativeFileList1 = tmpRelativeFileList1;
            this.relativeFileList2 = tmpRelativeFileList2;
        }
    }
}

