/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.file.PathVisitor;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.function.IOSupplier;

public abstract class AbstractFileFilter
implements IOFileFilter,
PathVisitor {
    private final FileVisitResult onAccept;
    private final FileVisitResult onReject;

    static FileVisitResult toDefaultFileVisitResult(boolean accept2) {
        return accept2 ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
    }

    public AbstractFileFilter() {
        this(FileVisitResult.CONTINUE, FileVisitResult.TERMINATE);
    }

    protected AbstractFileFilter(FileVisitResult onAccept, FileVisitResult onReject) {
        this.onAccept = onAccept;
        this.onReject = onReject;
    }

    @Override
    public boolean accept(File file2) {
        Objects.requireNonNull(file2, "file");
        return this.accept(file2.getParentFile(), file2.getName());
    }

    @Override
    public boolean accept(File dir, String name2) {
        Objects.requireNonNull(name2, "name");
        return this.accept(new File(dir, name2));
    }

    void append(List<?> list2, StringBuilder buffer) {
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            if (i2 > 0) {
                buffer.append(",");
            }
            buffer.append(list2.get(i2));
        }
    }

    void append(Object[] array, StringBuilder buffer) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (i2 > 0) {
                buffer.append(",");
            }
            buffer.append(array[i2]);
        }
    }

    FileVisitResult get(IOSupplier<FileVisitResult> supplier) {
        try {
            return supplier.get();
        }
        catch (IOException e) {
            return this.handle(e);
        }
    }

    protected FileVisitResult handle(Throwable t) {
        return FileVisitResult.TERMINATE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) throws IOException {
        return this.accept(dir, attributes);
    }

    FileVisitResult toFileVisitResult(boolean accept2) {
        return accept2 ? this.onAccept : this.onReject;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public FileVisitResult visitFile(Path file2, BasicFileAttributes attributes) throws IOException {
        return this.accept(file2, attributes);
    }

    @Override
    public FileVisitResult visitFileFailed(Path file2, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

