/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntPredicate;
import org.apache.commons.io.input.AbstractCharacterFilterReader;

public class CharacterSetFilterReader
extends AbstractCharacterFilterReader {
    private static IntPredicate toIntPredicate(Set<Integer> skip2) {
        if (skip2 == null) {
            return SKIP_NONE;
        }
        Set<Integer> unmodifiableSet = Collections.unmodifiableSet(skip2);
        return c -> unmodifiableSet.contains(c);
    }

    public CharacterSetFilterReader(Reader reader, Integer ... skip2) {
        this(reader, new HashSet<Integer>(Arrays.asList(skip2)));
    }

    public CharacterSetFilterReader(Reader reader, Set<Integer> skip2) {
        super(reader, CharacterSetFilterReader.toIntPredicate(skip2));
    }
}

