/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.UUID;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.output.ProxyWriter;

public class TaggedWriter
extends ProxyWriter {
    private final Serializable tag = UUID.randomUUID();

    public TaggedWriter(Writer proxy2) {
        super(proxy2);
    }

    @Override
    protected void handleIOException(IOException e) throws IOException {
        throw new TaggedIOException(e, this.tag);
    }

    public boolean isCauseOf(Exception exception2) {
        return TaggedIOException.isTaggedWith(exception2, this.tag);
    }

    public void throwIfCauseOf(Exception exception2) throws IOException {
        TaggedIOException.throwCauseIfTaggedWith(exception2, this.tag);
    }
}

