/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.UncheckedIllegalAccessException;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.apache.commons.lang3.function.FailableBiFunction;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailableSupplier;

public final class MethodInvokers {
    public static <T, U> BiConsumer<T, U> asBiConsumer(Method method2) {
        return MethodInvokers.asInterfaceInstance(BiConsumer.class, method2);
    }

    public static <T, U, R> BiFunction<T, U, R> asBiFunction(Method method2) {
        return MethodInvokers.asInterfaceInstance(BiFunction.class, method2);
    }

    public static <T, U> FailableBiConsumer<T, U, Throwable> asFailableBiConsumer(Method method2) {
        return MethodInvokers.asInterfaceInstance(FailableBiConsumer.class, method2);
    }

    public static <T, U, R> FailableBiFunction<T, U, R, Throwable> asFailableBiFunction(Method method2) {
        return MethodInvokers.asInterfaceInstance(FailableBiFunction.class, method2);
    }

    public static <T, R> FailableFunction<T, R, Throwable> asFailableFunction(Method method2) {
        return MethodInvokers.asInterfaceInstance(FailableFunction.class, method2);
    }

    public static <R> FailableSupplier<R, Throwable> asFailableSupplier(Method method2) {
        return MethodInvokers.asInterfaceInstance(FailableSupplier.class, method2);
    }

    public static <T, R> Function<T, R> asFunction(Method method2) {
        return MethodInvokers.asInterfaceInstance(Function.class, method2);
    }

    public static <T> T asInterfaceInstance(Class<T> interfaceClass, Method method2) {
        return MethodHandleProxies.asInterfaceInstance(Objects.requireNonNull(interfaceClass, "interfaceClass"), MethodInvokers.unreflectUnchecked(method2));
    }

    public static <R> Supplier<R> asSupplier(Method method2) {
        return MethodInvokers.asInterfaceInstance(Supplier.class, method2);
    }

    private static Method requireMethod(Method method2) {
        return Objects.requireNonNull(method2, "method");
    }

    private static MethodHandle unreflect(Method method2) throws IllegalAccessException {
        return MethodHandles.lookup().unreflect(MethodInvokers.requireMethod(method2));
    }

    private static MethodHandle unreflectUnchecked(Method method2) {
        try {
            return MethodInvokers.unreflect(method2);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedIllegalAccessException(e);
        }
    }

    private MethodInvokers() {
    }
}

