/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.curator.RetryLoop;
import org.apache.curator.TimeTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.Watching;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetDataBuilderImpl
implements GetDataBuilder,
BackgroundOperation<String> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFrameworkImpl client;
    private Stat responseStat;
    private Watching watching;
    private Backgrounding backgrounding;
    private boolean decompress;

    GetDataBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.responseStat = null;
        this.watching = new Watching();
        this.backgrounding = new Backgrounding();
        this.decompress = false;
    }

    @Override
    public GetDataWatchBackgroundStatable decompressed() {
        this.decompress = true;
        return new GetDataWatchBackgroundStatable(){

            @Override
            public Pathable<byte[]> inBackground() {
                return GetDataBuilderImpl.this.inBackground();
            }

            @Override
            public Pathable<byte[]> inBackground(BackgroundCallback callback, Object context) {
                return GetDataBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public Pathable<byte[]> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return GetDataBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public Pathable<byte[]> inBackground(Object context) {
                return GetDataBuilderImpl.this.inBackground(context);
            }

            @Override
            public Pathable<byte[]> inBackground(BackgroundCallback callback) {
                return GetDataBuilderImpl.this.inBackground(callback);
            }

            @Override
            public Pathable<byte[]> inBackground(BackgroundCallback callback, Executor executor) {
                return GetDataBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public byte[] forPath(String path2) throws Exception {
                return GetDataBuilderImpl.this.forPath(path2);
            }

            @Override
            public WatchPathable<byte[]> storingStatIn(Stat stat2) {
                return GetDataBuilderImpl.this.storingStatIn(stat2);
            }

            @Override
            public BackgroundPathable<byte[]> watched() {
                return GetDataBuilderImpl.this.watched();
            }

            @Override
            public BackgroundPathable<byte[]> usingWatcher(Watcher watcher) {
                return GetDataBuilderImpl.this.usingWatcher(watcher);
            }

            @Override
            public BackgroundPathable<byte[]> usingWatcher(CuratorWatcher watcher) {
                return GetDataBuilderImpl.this.usingWatcher(watcher);
            }
        };
    }

    @Override
    public WatchPathable<byte[]> storingStatIn(Stat stat2) {
        this.responseStat = stat2;
        return new WatchPathable<byte[]>(){

            @Override
            public byte[] forPath(String path2) throws Exception {
                return GetDataBuilderImpl.this.forPath(path2);
            }

            @Override
            public Pathable<byte[]> watched() {
                GetDataBuilderImpl.this.watched();
                return GetDataBuilderImpl.this;
            }

            @Override
            public Pathable<byte[]> usingWatcher(Watcher watcher) {
                GetDataBuilderImpl.this.usingWatcher(watcher);
                return GetDataBuilderImpl.this;
            }

            @Override
            public Pathable<byte[]> usingWatcher(CuratorWatcher watcher) {
                GetDataBuilderImpl.this.usingWatcher(watcher);
                return GetDataBuilderImpl.this;
            }
        };
    }

    @Override
    public Pathable<byte[]> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public Pathable<byte[]> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public Pathable<byte[]> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public Pathable<byte[]> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public Pathable<byte[]> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<byte[]> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public BackgroundPathable<byte[]> watched() {
        this.watching = new Watching(true);
        return this;
    }

    @Override
    public BackgroundPathable<byte[]> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public BackgroundPathable<byte[]> usingWatcher(CuratorWatcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("GetDataBuilderImpl-Background");
        AsyncCallback.DataCallback callback = new AsyncCallback.DataCallback(){

            @Override
            public void processResult(int rc, String path2, Object ctx, byte[] data, Stat stat2) {
                trace.commit();
                if (GetDataBuilderImpl.this.decompress && data != null) {
                    try {
                        data = GetDataBuilderImpl.this.client.getCompressionProvider().decompress(path2, data);
                    }
                    catch (Exception e) {
                        GetDataBuilderImpl.this.log.error("Decompressing for path: " + path2, e);
                        rc = KeeperException.Code.DATAINCONSISTENCY.intValue();
                    }
                }
                CuratorEventImpl event = new CuratorEventImpl(GetDataBuilderImpl.this.client, CuratorEventType.GET_DATA, rc, path2, null, ctx, stat2, data, null, null, null);
                GetDataBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        };
        if (this.watching.isWatched()) {
            this.client.getZooKeeper().getData(operationAndData.getData(), true, callback, this.backgrounding.getContext());
        } else {
            this.client.getZooKeeper().getData(operationAndData.getData(), this.watching.getWatcher(), callback, this.backgrounding.getContext());
        }
    }

    @Override
    public byte[] forPath(String path2) throws Exception {
        path2 = this.client.fixForNamespace(path2);
        byte[] responseData = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path2, this.backgrounding.getCallback(), null, this.backgrounding.getContext()), null);
        } else {
            responseData = this.pathInForeground(path2);
        }
        return responseData;
    }

    private byte[] pathInForeground(final String path2) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("GetDataBuilderImpl-Foreground");
        byte[] responseData = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                byte[] responseData = GetDataBuilderImpl.this.watching.isWatched() ? GetDataBuilderImpl.this.client.getZooKeeper().getData(path2, true, GetDataBuilderImpl.this.responseStat) : GetDataBuilderImpl.this.client.getZooKeeper().getData(path2, GetDataBuilderImpl.this.watching.getWatcher(), GetDataBuilderImpl.this.responseStat);
                return responseData;
            }
        });
        trace.commit();
        return this.decompress ? this.client.getCompressionProvider().decompress(path2, responseData) : responseData;
    }
}

