/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.utils.InternalACLProvider;
import org.apache.curator.utils.ZKPaths;

public class EnsurePath {
    private final String path;
    private final boolean makeLastNode;
    private final InternalACLProvider aclProvider;
    private final AtomicReference<Helper> helper;
    private static final Helper doNothingHelper = new Helper(){

        @Override
        public void ensure(CuratorZookeeperClient client, String path2, boolean makeLastNode) throws Exception {
        }
    };

    public EnsurePath(String path2) {
        this(path2, null, true, null);
    }

    public EnsurePath(String path2, InternalACLProvider aclProvider) {
        this(path2, null, true, aclProvider);
    }

    public void ensure(CuratorZookeeperClient client) throws Exception {
        Helper localHelper = this.helper.get();
        localHelper.ensure(client, this.path, this.makeLastNode);
    }

    public EnsurePath excludingLast() {
        return new EnsurePath(this.path, this.helper, false, this.aclProvider);
    }

    private EnsurePath(String path2, AtomicReference<Helper> helper, boolean makeLastNode, InternalACLProvider aclProvider) {
        this.path = path2;
        this.makeLastNode = makeLastNode;
        this.aclProvider = aclProvider;
        this.helper = helper != null ? helper : new AtomicReference<InitialHelper>(new InitialHelper());
    }

    public String getPath() {
        return this.path;
    }

    private class InitialHelper
    implements Helper {
        private boolean isSet = false;

        private InitialHelper() {
        }

        @Override
        public synchronized void ensure(final CuratorZookeeperClient client, final String path2, final boolean makeLastNode) throws Exception {
            if (!this.isSet) {
                RetryLoop.callWithRetry(client, new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ZKPaths.mkdirs(client.getZooKeeper(), path2, makeLastNode, EnsurePath.this.aclProvider);
                        EnsurePath.this.helper.set(doNothingHelper);
                        InitialHelper.this.isSet = true;
                        return null;
                    }
                });
            }
        }
    }

    private static interface Helper {
        public void ensure(CuratorZookeeperClient var1, String var2, boolean var3) throws Exception;
    }
}

