/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.util;

import org.apache.directory.api.i18n.I18n;

public class BitString {
    public static final BitString EMPTY_STRING = new BitString(1);
    private int nbUnusedBits;
    private byte[] bytes;
    private int nbBytes;
    private int nbBits;

    public BitString(int length2) {
        if (length2 <= 0) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00029_NULL_OR_NEG_LENGTH_NOT_ALLOWED, (Object[])new Object[0]));
        }
        this.nbBits = length2;
        this.nbBytes = length2 / 8;
        if (length2 % 8 != 0) {
            ++this.nbBytes;
        }
        this.nbUnusedBits = 8 - length2 % 8 & 7;
        this.bytes = new byte[this.nbBytes];
    }

    public BitString(byte[] bytes2) {
        if (bytes2 == null || bytes2.length == 0) {
            this.nbBits = -1;
            return;
        }
        this.setData(bytes2);
    }

    public void setData(byte[] bytes2) {
        if (bytes2 == null || bytes2.length == 0) {
            this.nbBits = -1;
            return;
        }
        this.nbUnusedBits = bytes2[0] & 7;
        this.nbBytes = bytes2.length - 1;
        this.nbBits = this.nbBytes * 8 - this.nbUnusedBits;
        this.bytes = new byte[this.nbBytes];
        for (int i2 = 0; i2 < this.nbBytes; ++i2) {
            this.bytes[i2] = bytes2[i2 + 1];
        }
    }

    public byte[] getData() {
        byte[] copy = new byte[this.bytes.length + 1];
        System.arraycopy(this.bytes, 0, copy, 1, this.bytes.length);
        copy[0] = (byte)this.nbUnusedBits;
        return copy;
    }

    public byte getUnusedBits() {
        return (byte)this.nbUnusedBits;
    }

    public void setBit(int pos2) {
        if (pos2 < 0 || pos2 > this.nbBits) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00030_BIT_NUMBER_OUT_OF_BOUND, (Object[])new Object[0]));
        }
        int posBytes = pos2 >>> 3;
        int bitNumber = 7 - pos2 % 8;
        byte mask = (byte)(1 << bitNumber);
        int n = posBytes;
        this.bytes[n] = (byte)(this.bytes[n] | mask);
    }

    public void clearBit(int pos2) {
        if (pos2 < 0 || pos2 > this.nbBits) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00030_BIT_NUMBER_OUT_OF_BOUND, (Object[])new Object[0]));
        }
        int posBytes = pos2 >>> 3;
        int bitNumber = 7 - pos2 % 8;
        byte mask = (byte)(1 << bitNumber);
        int n = posBytes;
        this.bytes[n] = (byte)(this.bytes[n] & ~mask);
    }

    public boolean getBit(int pos2) {
        if (pos2 > this.nbBits) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00031_CANNOT_FIND_BIT, (Object[])new Object[]{pos2, this.nbBits}));
        }
        int posBytes = pos2 >>> 3;
        int bitNumber = 7 - pos2 % 8;
        byte mask = (byte)(1 << bitNumber);
        int res = this.bytes[posBytes] & mask;
        return res != 0;
    }

    public int size() {
        return this.nbBits;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.nbBits; ++i2) {
            if (this.getBit(i2)) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }
}

