/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.api.util.UnicodeConstants;

public final class Unicode {
    public static int countBytesPerChar(byte[] bytes2, int pos2) {
        if (bytes2 == null) {
            return -1;
        }
        if ((bytes2[pos2] & 0x80) == 0) {
            return 1;
        }
        if ((bytes2[pos2] & 0xE0) == 192) {
            return 2;
        }
        if ((bytes2[pos2] & 0xF0) == 224) {
            return 3;
        }
        if ((bytes2[pos2] & 0xF8) == 240) {
            return 4;
        }
        if ((bytes2[pos2] & 0xFC) == 248) {
            return 5;
        }
        if ((bytes2[pos2] & 0xFE) == 252) {
            return 6;
        }
        return -1;
    }

    public static char bytesToChar(byte[] bytes2) {
        return Unicode.bytesToChar(bytes2, 0);
    }

    public static char bytesToChar(byte[] bytes2, int pos2) {
        if (bytes2 == null) {
            return '\uffff';
        }
        if ((bytes2[pos2] & 0x80) == 0) {
            return (char)bytes2[pos2];
        }
        if ((bytes2[pos2] & 0xE0) == 192) {
            return (char)(((bytes2[pos2] & 0x1C) << 6) + ((bytes2[pos2] & 3) << 6) + (bytes2[pos2 + 1] & 0x3F));
        }
        if ((bytes2[pos2] & 0xF0) == 224) {
            return (char)(((bytes2[pos2] & 0xF) << 12) + ((bytes2[pos2 + 1] & 0x3C) << 6) + ((bytes2[pos2 + 1] & 3) << 6) + (bytes2[pos2 + 2] & 0x3F));
        }
        if ((bytes2[pos2] & 0xF8) == 240) {
            return (char)(((bytes2[pos2] & 7) << 18) + ((bytes2[pos2 + 1] & 0x30) << 16) + ((bytes2[pos2 + 1] & 0xF) << 12) + ((bytes2[pos2 + 2] & 0x3C) << 6) + ((bytes2[pos2 + 2] & 3) << 6) + (bytes2[pos2 + 3] & 0x3F));
        }
        if ((bytes2[pos2] & 0xFC) == 248) {
            return (char)(((bytes2[pos2] & 3) << 24) + ((bytes2[pos2 + 1] & 0x3F) << 18) + ((bytes2[pos2 + 2] & 0x30) << 12) + ((bytes2[pos2 + 2] & 0xF) << 12) + ((bytes2[pos2 + 3] & 0x3C) << 6) + ((bytes2[pos2 + 3] & 3) << 6) + (bytes2[pos2 + 4] & 0x3F));
        }
        if ((bytes2[pos2] & 0xFC) == 248) {
            return (char)(((bytes2[pos2] & 1) << 30) + ((bytes2[pos2 + 1] & 0x3F) << 24) + ((bytes2[pos2 + 2] & 0x3F) << 18) + ((bytes2[pos2 + 3] & 0x30) << 12) + ((bytes2[pos2 + 3] & 0xF) << 12) + ((bytes2[pos2 + 4] & 0x3C) << 6) + ((bytes2[pos2 + 4] & 3) << 6) + (bytes2[pos2 + 5] & 0x3F));
        }
        return '\uffff';
    }

    public static int countNbBytesPerChar(char car) {
        if ((car & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((car & 0xFFFFF800) == 0) {
            return 2;
        }
        if ((car & 0xFFFF0000) == 0) {
            return 3;
        }
        if ((car & 0xFFE00000) == 0) {
            return 4;
        }
        if ((car & 0xFC000000) == 0) {
            return 5;
        }
        if ((car & Integer.MIN_VALUE) == 0) {
            return 6;
        }
        return -1;
    }

    public static int countBytes(char[] chars2) {
        if (chars2 == null) {
            return 0;
        }
        int nbBytes = 0;
        int currentPos = 0;
        while (currentPos < chars2.length) {
            int nbb;
            currentPos += (nbb = Unicode.countNbBytesPerChar(chars2[currentPos])) < 4 ? 1 : 2;
            nbBytes += nbb;
        }
        return nbBytes;
    }

    public static int countChars(byte[] bytes2) {
        if (bytes2 == null) {
            return 0;
        }
        int nbChars = 0;
        int currentPos = 0;
        while (currentPos < bytes2.length) {
            currentPos += Unicode.countBytesPerChar(bytes2, currentPos);
            ++nbChars;
        }
        return nbChars;
    }

    public static byte[] charToBytes(char car) {
        byte[] bytes2 = new byte[Unicode.countNbBytesPerChar(car)];
        if (car <= '\u007f') {
            bytes2[0] = (byte)car;
            return bytes2;
        }
        if (car <= '\u07ff') {
            bytes2[0] = (byte)(192 + ((car & 0x7C0) >> 6));
            bytes2[1] = (byte)(128 + (car & 0x3F));
        } else {
            bytes2[0] = (byte)(224 + ((car & 0xF000) >> 12));
            bytes2[1] = (byte)(128 + ((car & 0xFC0) >> 6));
            bytes2[2] = (byte)(128 + (car & 0x3F));
        }
        return bytes2;
    }

    public static boolean isUnicodeSubset(String str, int pos2) {
        if (str == null || str.length() <= pos2 || pos2 < 0) {
            return false;
        }
        char c = str.charAt(pos2);
        return c > '\u007f' || UnicodeConstants.UNICODE_SUBSET[c];
    }

    public static boolean isUnicodeSubset(char c) {
        return c > '\u007f' || UnicodeConstants.UNICODE_SUBSET[c];
    }

    public static boolean isUnicodeSubset(byte b) {
        return b < 0 || b > 127 || UnicodeConstants.UNICODE_SUBSET[b];
    }

    public static void writeUTF(ObjectOutput objectOutput, String str) throws IOException {
        if (str == null) {
            objectOutput.writeInt(0);
            objectOutput.writeUTF("null");
        } else {
            objectOutput.writeInt(str.length());
            StringBuffer strBuf = new StringBuffer(str);
            while (strBuf != null) {
                if (strBuf.length() < 21845) {
                    objectOutput.writeUTF(strBuf.substring(0, strBuf.length()));
                    strBuf = null;
                    continue;
                }
                objectOutput.writeUTF(strBuf.substring(0, 21845));
                strBuf.delete(0, 21845);
            }
        }
    }

    public static String readUTF(ObjectInput objectInput) throws IOException {
        StringBuffer strBuf = null;
        int strLength = objectInput.readInt();
        strBuf = new StringBuffer(objectInput.readUTF());
        if (strLength == 0 && strBuf.toString().equals("null")) {
            return null;
        }
        while (strLength > strBuf.length()) {
            strBuf.append(objectInput.readUTF());
        }
        return strBuf.toString();
    }
}

