/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ByteBufferKeyOnlyKeyValue
extends ByteBufferExtendedCell {
    public static final int FIXED_OVERHEAD = ClassSize.OBJECT + ClassSize.REFERENCE + 8 + 2;
    private ByteBuffer buf;
    private int offset = 0;
    private int length = 0;
    private short rowLen;

    public ByteBufferKeyOnlyKeyValue() {
    }

    public ByteBufferKeyOnlyKeyValue(ByteBuffer buf, int offset2, int length2) {
        this.setKey(buf, offset2, length2);
    }

    public void setKey(ByteBuffer key2, int offset2, int length2) {
        this.setKey(key2, offset2, length2, ByteBufferUtils.toShort(key2, offset2));
    }

    public void setKey(ByteBuffer key2, int offset2, int length2, short rowLen) {
        this.buf = key2;
        this.offset = offset2;
        this.length = length2;
        this.rowLen = rowLen;
    }

    @Override
    public byte[] getRowArray() {
        if (this.buf.hasArray()) {
            return this.buf.array();
        }
        return CellUtil.cloneRow(this);
    }

    @Override
    public int getRowOffset() {
        if (this.buf.hasArray()) {
            return this.getRowPosition() + this.buf.arrayOffset();
        }
        return 0;
    }

    @Override
    public short getRowLength() {
        return this.rowLen;
    }

    @Override
    public byte[] getFamilyArray() {
        if (this.buf.hasArray()) {
            return this.buf.array();
        }
        return CellUtil.cloneFamily(this);
    }

    @Override
    public int getFamilyOffset() {
        if (this.buf.hasArray()) {
            return this.getFamilyPosition() + this.buf.arrayOffset();
        }
        return 0;
    }

    @Override
    public byte getFamilyLength() {
        return this.getFamilyLength(this.getFamilyLengthPosition());
    }

    private byte getFamilyLength(int famLenPos) {
        return ByteBufferUtils.toByte(this.buf, famLenPos);
    }

    @Override
    public byte[] getQualifierArray() {
        if (this.buf.hasArray()) {
            return this.buf.array();
        }
        return CellUtil.cloneQualifier(this);
    }

    @Override
    public int getQualifierOffset() {
        if (this.buf.hasArray()) {
            return this.getQualifierPosition() + this.buf.arrayOffset();
        }
        return 0;
    }

    @Override
    public int getQualifierLength() {
        return this.getQualifierLength(this.getRowLength(), this.getFamilyLength());
    }

    private int getQualifierLength(int rlength, int flength) {
        return this.length - (int)KeyValue.getKeyDataStructureSize(rlength, flength, 0);
    }

    @Override
    public long getTimestamp() {
        return ByteBufferUtils.toLong(this.buf, this.getTimestampOffset());
    }

    private int getTimestampOffset() {
        return this.offset + this.length - 9;
    }

    @Override
    public byte getTypeByte() {
        return this.getTypeByte(this.length);
    }

    byte getTypeByte(int keyLen) {
        return ByteBufferUtils.toByte(this.buf, this.offset + keyLen - 1);
    }

    @Override
    public void setSequenceId(long seqId) throws IOException {
        throw new IllegalArgumentException("This is a key only Cell");
    }

    @Override
    public void setTimestamp(long ts) throws IOException {
        throw new IllegalArgumentException("This is a key only Cell");
    }

    @Override
    public void setTimestamp(byte[] ts) throws IOException {
        throw new IllegalArgumentException("This is a key only Cell");
    }

    @Override
    public long getSequenceId() {
        return 0L;
    }

    @Override
    public byte[] getValueArray() {
        throw new IllegalArgumentException("This is a key only Cell");
    }

    @Override
    public int getValueOffset() {
        return 0;
    }

    @Override
    public int getValueLength() {
        return 0;
    }

    @Override
    public byte[] getTagsArray() {
        throw new IllegalArgumentException("This is a key only Cell");
    }

    @Override
    public int getTagsOffset() {
        return 0;
    }

    @Override
    public int getTagsLength() {
        return 0;
    }

    @Override
    public ByteBuffer getRowByteBuffer() {
        return this.buf;
    }

    @Override
    public int getRowPosition() {
        return this.offset + 2;
    }

    @Override
    public ByteBuffer getFamilyByteBuffer() {
        return this.buf;
    }

    @Override
    public int getFamilyPosition() {
        return this.getFamilyLengthPosition() + 1;
    }

    private int getFamilyLengthPosition() {
        return this.getFamilyLengthPosition(this.getRowLength());
    }

    int getFamilyLengthPosition(int rowLength) {
        return this.offset + 2 + rowLength;
    }

    @Override
    public ByteBuffer getQualifierByteBuffer() {
        return this.buf;
    }

    @Override
    public int getQualifierPosition() {
        int famLenPos = this.getFamilyLengthPosition();
        return famLenPos + 1 + this.getFamilyLength(famLenPos);
    }

    @Override
    public ByteBuffer getValueByteBuffer() {
        throw new IllegalArgumentException("This is a key only Cell");
    }

    @Override
    public int getValuePosition() {
        return 0;
    }

    @Override
    public ByteBuffer getTagsByteBuffer() {
        throw new IllegalArgumentException("This is a key only Cell");
    }

    @Override
    public int getTagsPosition() {
        return 0;
    }

    public String toString() {
        return CellUtil.toString(this, false);
    }

    @Override
    public Iterator<Tag> getTags() {
        return Collections.emptyIterator();
    }

    @Override
    public Optional<Tag> getTag(byte type2) {
        return Optional.empty();
    }

    @Override
    public long heapSize() {
        if (this.buf.hasArray()) {
            return ClassSize.align(FIXED_OVERHEAD + this.length);
        }
        return ClassSize.align(FIXED_OVERHEAD);
    }
}

