/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetaTableAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(MetaTableAccessor.class);
    private static final Logger METALOG = LoggerFactory.getLogger("org.apache.hadoop.hbase.META");
    public static final byte[] REPLICATION_PARENT_QUALIFIER = Bytes.toBytes("parent");
    private static final byte ESCAPE_BYTE = -1;
    private static final byte SEPARATED_BYTE = 0;
    static final char META_REPLICA_ID_DELIMITER = '_';
    private static final Pattern SERVER_COLUMN_PATTERN = Pattern.compile("^server(_[0-9a-fA-F]{4})?$");

    public static void fullScanRegions(Connection connection, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, null, null, QueryType.REGION, visitor);
    }

    public static List<Result> fullScanRegions(Connection connection) throws IOException {
        return MetaTableAccessor.fullScan(connection, QueryType.REGION);
    }

    public static void fullScanTables(Connection connection, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, null, null, QueryType.TABLE, visitor);
    }

    private static List<Result> fullScan(Connection connection, QueryType type2) throws IOException {
        CollectAllVisitor v = new CollectAllVisitor();
        MetaTableAccessor.scanMeta(connection, null, null, type2, (Visitor)v);
        return v.getResults();
    }

    public static Table getMetaHTable(Connection connection) throws IOException {
        if (connection == null) {
            throw new NullPointerException("No connection");
        }
        if (connection.isClosed()) {
            throw new IOException("connection is closed");
        }
        return connection.getTable(TableName.META_TABLE_NAME);
    }

    private static Result get(Table t, Get g) throws IOException {
        if (t == null) {
            return null;
        }
        try {
            Result result2 = t.get(g);
            return result2;
        }
        finally {
            t.close();
        }
    }

    @Deprecated
    public static Pair<RegionInfo, ServerName> getRegion(Connection connection, byte[] regionName) throws IOException {
        HRegionLocation location = MetaTableAccessor.getRegionLocation(connection, regionName);
        return location == null ? null : new Pair<HRegionInfo, ServerName>(location.getRegionInfo(), location.getServerName());
    }

    public static HRegionLocation getRegionLocation(Connection connection, byte[] regionName) throws IOException {
        byte[] row = regionName;
        RegionInfo parsedInfo = null;
        try {
            parsedInfo = MetaTableAccessor.parseRegionInfoFromRegionName(regionName);
            row = MetaTableAccessor.getMetaKeyForRegion(parsedInfo);
        }
        catch (Exception parseEx) {
            return null;
        }
        Get get2 = new Get(row);
        get2.addFamily(HConstants.CATALOG_FAMILY);
        Result r = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get2);
        RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
        return locations == null ? null : locations.getRegionLocation(parsedInfo == null ? 0 : parsedInfo.getReplicaId());
    }

    public static HRegionLocation getRegionLocation(Connection connection, RegionInfo regionInfo) throws IOException {
        return MetaTableAccessor.getRegionLocation(MetaTableAccessor.getCatalogFamilyRow(connection, regionInfo), regionInfo, regionInfo.getReplicaId());
    }

    public static Result getCatalogFamilyRow(Connection connection, RegionInfo ri) throws IOException {
        Get get2 = new Get(MetaTableAccessor.getMetaKeyForRegion(ri));
        get2.addFamily(HConstants.CATALOG_FAMILY);
        return MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get2);
    }

    public static byte[] getMetaKeyForRegion(RegionInfo regionInfo) {
        return RegionReplicaUtil.getRegionInfoForDefaultReplica(regionInfo).getRegionName();
    }

    public static RegionInfo parseRegionInfoFromRegionName(byte[] regionName) throws IOException {
        byte[][] fields2 = RegionInfo.parseRegionName(regionName);
        long regionId = Long.parseLong(Bytes.toString(fields2[2]));
        int replicaId = fields2.length > 3 ? Integer.parseInt(Bytes.toString(fields2[3]), 16) : 0;
        return RegionInfoBuilder.newBuilder(TableName.valueOf(fields2[0])).setStartKey(fields2[1]).setRegionId(regionId).setReplicaId(replicaId).build();
    }

    public static Result getRegionResult(Connection connection, byte[] regionName) throws IOException {
        Get get2 = new Get(regionName);
        get2.addFamily(HConstants.CATALOG_FAMILY);
        return MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get2);
    }

    /*
     * Exception decompiling
     */
    public static Result scanByRegionEncodedName(Connection connection, String regionEncodedName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static List<RegionInfo> getMergeRegions(Connection connection, byte[] regionName) throws IOException {
        return MetaTableAccessor.getMergeRegions(MetaTableAccessor.getRegionResult(connection, regionName).rawCells());
    }

    public static boolean hasMergeRegions(Connection conn, byte[] regionName) throws IOException {
        return MetaTableAccessor.hasMergeRegions(MetaTableAccessor.getRegionResult(conn, regionName).rawCells());
    }

    @Nullable
    public static Map<String, RegionInfo> getMergeRegionsWithName(Cell[] cells) {
        if (cells == null) {
            return null;
        }
        LinkedHashMap<String, RegionInfo> regionsToMerge = null;
        for (Cell cell : cells) {
            RegionInfo ri;
            if (!MetaTableAccessor.isMergeQualifierPrefix(cell) || (ri = RegionInfo.parseFromOrNull(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength())) == null) continue;
            if (regionsToMerge == null) {
                regionsToMerge = new LinkedHashMap<String, RegionInfo>();
            }
            regionsToMerge.put(Bytes.toString(CellUtil.cloneQualifier(cell)), ri);
        }
        return regionsToMerge;
    }

    @Nullable
    public static List<RegionInfo> getMergeRegions(Cell[] cells) {
        Map<String, RegionInfo> mergeRegionsWithName = MetaTableAccessor.getMergeRegionsWithName(cells);
        return mergeRegionsWithName == null ? null : new ArrayList<RegionInfo>(mergeRegionsWithName.values());
    }

    public static boolean hasMergeRegions(Cell[] cells) {
        for (Cell cell : cells) {
            if (!MetaTableAccessor.isMergeQualifierPrefix(cell)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMergeQualifierPrefix(Cell cell) {
        return CellUtil.matchingFamily(cell, HConstants.CATALOG_FAMILY) && PrivateCellUtil.qualifierStartsWith(cell, HConstants.MERGE_QUALIFIER_PREFIX);
    }

    public static List<RegionInfo> getAllRegions(Connection connection, boolean excludeOfflinedSplitParents) throws IOException {
        List<Pair<RegionInfo, ServerName>> result2 = MetaTableAccessor.getTableRegionsAndLocations(connection, null, excludeOfflinedSplitParents);
        return MetaTableAccessor.getListOfRegionInfos(result2);
    }

    public static List<RegionInfo> getTableRegions(Connection connection, TableName tableName) throws IOException {
        return MetaTableAccessor.getTableRegions(connection, tableName, false);
    }

    public static List<RegionInfo> getTableRegions(Connection connection, TableName tableName, boolean excludeOfflinedSplitParents) throws IOException {
        List<Pair<RegionInfo, ServerName>> result2 = MetaTableAccessor.getTableRegionsAndLocations(connection, tableName, excludeOfflinedSplitParents);
        return MetaTableAccessor.getListOfRegionInfos(result2);
    }

    private static List<RegionInfo> getListOfRegionInfos(List<Pair<RegionInfo, ServerName>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RegionInfo> result2 = new ArrayList<RegionInfo>(pairs.size());
        for (Pair<RegionInfo, ServerName> pair : pairs) {
            result2.add(pair.getFirst());
        }
        return result2;
    }

    public static byte[] getTableStartRowForMeta(TableName tableName, QueryType type2) {
        if (tableName == null) {
            return null;
        }
        switch (type2) {
            case REGION: {
                byte[] startRow = new byte[tableName.getName().length + 2];
                System.arraycopy(tableName.getName(), 0, startRow, 0, tableName.getName().length);
                startRow[startRow.length - 2] = 44;
                startRow[startRow.length - 1] = 44;
                return startRow;
            }
        }
        return tableName.getName();
    }

    public static byte[] getTableStopRowForMeta(TableName tableName, QueryType type2) {
        byte[] stopRow;
        if (tableName == null) {
            return null;
        }
        switch (type2) {
            case REGION: {
                stopRow = new byte[tableName.getName().length + 3];
                System.arraycopy(tableName.getName(), 0, stopRow, 0, tableName.getName().length);
                stopRow[stopRow.length - 3] = 32;
                stopRow[stopRow.length - 2] = 44;
                stopRow[stopRow.length - 1] = 44;
                break;
            }
            default: {
                stopRow = new byte[tableName.getName().length + 1];
                System.arraycopy(tableName.getName(), 0, stopRow, 0, tableName.getName().length);
                stopRow[stopRow.length - 1] = 32;
            }
        }
        return stopRow;
    }

    public static Scan getScanForTableName(Configuration conf, TableName tableName) {
        byte[] startKey = MetaTableAccessor.getTableStartRowForMeta(tableName, QueryType.REGION);
        byte[] stopKey = MetaTableAccessor.getTableStopRowForMeta(tableName, QueryType.REGION);
        Scan scan2 = MetaTableAccessor.getMetaScan(conf, -1);
        scan2.setStartRow(startKey);
        scan2.setStopRow(stopKey);
        return scan2;
    }

    private static Scan getMetaScan(Configuration conf, int rowUpperLimit) {
        Scan scan2 = new Scan();
        int scannerCaching = conf.getInt("hbase.meta.scanner.caching", 100);
        if (conf.getBoolean("hbase.meta.replicas.use", false)) {
            scan2.setConsistency(Consistency.TIMELINE);
        }
        if (rowUpperLimit > 0) {
            scan2.setLimit(rowUpperLimit);
            scan2.setReadType(Scan.ReadType.PREAD);
        }
        scan2.setCaching(scannerCaching);
        return scan2;
    }

    public static List<Pair<RegionInfo, ServerName>> getTableRegionsAndLocations(Connection connection, TableName tableName) throws IOException {
        return MetaTableAccessor.getTableRegionsAndLocations(connection, tableName, true);
    }

    public static List<Pair<RegionInfo, ServerName>> getTableRegionsAndLocations(Connection connection, @Nullable TableName tableName, final boolean excludeOfflinedSplitParents) throws IOException {
        if (tableName != null && tableName.equals(TableName.META_TABLE_NAME)) {
            throw new IOException("This method can't be used to locate meta regions; use MetaTableLocator instead");
        }
        CollectingVisitor<Pair<RegionInfo, ServerName>> visitor = new CollectingVisitor<Pair<RegionInfo, ServerName>>(){
            private RegionLocations current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                this.current = MetaTableAccessor.getRegionLocations(r);
                if (this.current == null || this.current.getRegionLocation().getRegion() == null) {
                    LOG.warn("No serialized RegionInfo in " + r);
                    return true;
                }
                RegionInfo hri = this.current.getRegionLocation().getRegion();
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                return super.visit(r);
            }

            @Override
            void add(Result r) {
                if (this.current == null) {
                    return;
                }
                for (HRegionLocation loc : this.current.getRegionLocations()) {
                    if (loc == null) continue;
                    this.results.add(new Pair<RegionInfo, ServerName>(loc.getRegion(), loc.getServerName()));
                }
            }
        };
        MetaTableAccessor.scanMeta(connection, MetaTableAccessor.getTableStartRowForMeta(tableName, QueryType.REGION), MetaTableAccessor.getTableStopRowForMeta(tableName, QueryType.REGION), QueryType.REGION, (Visitor)visitor);
        return visitor.getResults();
    }

    public static NavigableMap<RegionInfo, Result> getServerUserRegions(Connection connection, final ServerName serverName) throws IOException {
        final TreeMap<RegionInfo, Result> hris = new TreeMap<RegionInfo, Result>();
        CollectingVisitor<Result> v = new CollectingVisitor<Result>(){

            @Override
            void add(Result r) {
                if (r == null || r.isEmpty()) {
                    return;
                }
                RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
                if (locations == null) {
                    return;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    if (loc == null || loc.getServerName() == null || !loc.getServerName().equals(serverName)) continue;
                    hris.put(loc.getRegion(), r);
                }
            }
        };
        MetaTableAccessor.scanMeta(connection, null, null, QueryType.REGION, (Visitor)v);
        return hris;
    }

    public static void fullScanMetaAndPrint(Connection connection) throws IOException {
        Visitor v = r -> {
            if (r == null || r.isEmpty()) {
                return true;
            }
            LOG.info("fullScanMetaAndPrint.Current Meta Row: " + r);
            TableState state = MetaTableAccessor.getTableState(r);
            if (state != null) {
                LOG.info("fullScanMetaAndPrint.Table State={}" + state);
            } else {
                RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
                if (locations == null) {
                    return true;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    if (loc == null) continue;
                    LOG.info("fullScanMetaAndPrint.HRI Print={}", (Object)loc.getRegion());
                }
            }
            return true;
        };
        MetaTableAccessor.scanMeta(connection, null, null, QueryType.ALL, v);
    }

    public static void scanMetaForTableRegions(Connection connection, Visitor visitor, TableName tableName) throws IOException {
        MetaTableAccessor.scanMeta(connection, tableName, QueryType.REGION, Integer.MAX_VALUE, visitor);
    }

    private static void scanMeta(Connection connection, TableName table, QueryType type2, int maxRows, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, MetaTableAccessor.getTableStartRowForMeta(table, type2), MetaTableAccessor.getTableStopRowForMeta(table, type2), type2, maxRows, visitor);
    }

    private static void scanMeta(Connection connection, @Nullable byte[] startRow, @Nullable byte[] stopRow, QueryType type2, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, startRow, stopRow, type2, Integer.MAX_VALUE, visitor);
    }

    public static void scanMeta(Connection connection, Visitor visitor, TableName tableName, byte[] row, int rowLimit) throws IOException {
        byte[] startRow = null;
        byte[] stopRow = null;
        if (tableName != null) {
            startRow = MetaTableAccessor.getTableStartRowForMeta(tableName, QueryType.REGION);
            if (row != null) {
                RegionInfo closestRi = MetaTableAccessor.getClosestRegionInfo(connection, tableName, row);
                startRow = RegionInfo.createRegionName(tableName, closestRi.getStartKey(), "00000000000000", false);
            }
            stopRow = MetaTableAccessor.getTableStopRowForMeta(tableName, QueryType.REGION);
        }
        MetaTableAccessor.scanMeta(connection, startRow, stopRow, QueryType.REGION, rowLimit, visitor);
    }

    static void scanMeta(Connection connection, @Nullable byte[] startRow, @Nullable byte[] stopRow, QueryType type2, int maxRows, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, startRow, stopRow, type2, null, maxRows, visitor);
    }

    private static void scanMeta(Connection connection, @Nullable byte[] startRow, @Nullable byte[] stopRow, QueryType type2, @Nullable Filter filter, int maxRows, Visitor visitor) throws IOException {
        int rowUpperLimit = maxRows > 0 ? maxRows : Integer.MAX_VALUE;
        Scan scan2 = MetaTableAccessor.getMetaScan(connection.getConfiguration(), rowUpperLimit);
        for (byte[] family : type2.getFamilies()) {
            scan2.addFamily(family);
        }
        if (startRow != null) {
            scan2.withStartRow(startRow);
        }
        if (stopRow != null) {
            scan2.withStopRow(stopRow);
        }
        if (filter != null) {
            scan2.setFilter(filter);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Scanning META starting at row=" + Bytes.toStringBinary(startRow) + " stopping at row=" + Bytes.toStringBinary(stopRow) + " for max=" + rowUpperLimit + " with caching=" + scan2.getCaching());
        }
        int currentRow = 0;
        try (Table metaTable = MetaTableAccessor.getMetaHTable(connection);
             ResultScanner scanner = metaTable.getScanner(scan2);){
            Result data;
            while ((data = scanner.next()) != null) {
                if (data.isEmpty()) continue;
                if (!visitor.visit(data)) {
                } else if (++currentRow < rowUpperLimit) continue;
                break;
            }
        }
        if (visitor instanceof Closeable) {
            try {
                ((Closeable)((Object)visitor)).close();
            }
            catch (Throwable t) {
                ExceptionUtil.rethrowIfInterrupt(t);
                LOG.debug("Got exception in closing the meta scanner visitor", t);
            }
        }
    }

    @NonNull
    private static RegionInfo getClosestRegionInfo(Connection connection, @NonNull TableName tableName, @NonNull byte[] row) throws IOException {
        byte[] searchRow = RegionInfo.createRegionName(tableName, row, "99999999999999", false);
        Scan scan2 = MetaTableAccessor.getMetaScan(connection.getConfiguration(), 1);
        scan2.setReversed(true);
        scan2.withStartRow(searchRow);
        try (ResultScanner resultScanner = MetaTableAccessor.getMetaHTable(connection).getScanner(scan2);){
            Result result2 = resultScanner.next();
            if (result2 == null) {
                throw new TableNotFoundException("Cannot find row in META  for table: " + tableName + ", row=" + Bytes.toStringBinary(row));
            }
            RegionInfo regionInfo = MetaTableAccessor.getRegionInfo(result2);
            if (regionInfo == null) {
                throw new IOException("RegionInfo was null or empty in Meta for " + tableName + ", row=" + Bytes.toStringBinary(row));
            }
            RegionInfo regionInfo2 = regionInfo;
            return regionInfo2;
        }
    }

    public static byte[] getCatalogFamily() {
        return HConstants.CATALOG_FAMILY;
    }

    private static byte[] getTableFamily() {
        return HConstants.TABLE_FAMILY;
    }

    public static byte[] getRegionInfoColumn() {
        return HConstants.REGIONINFO_QUALIFIER;
    }

    private static byte[] getTableStateColumn() {
        return HConstants.TABLE_STATE_QUALIFIER;
    }

    private static byte[] getRegionStateColumn() {
        return HConstants.STATE_QUALIFIER;
    }

    public static byte[] getRegionStateColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STATE_QUALIFIER : Bytes.toBytes("state_" + String.format("%04X", replicaId));
    }

    public static byte[] getServerNameColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVERNAME_QUALIFIER : Bytes.toBytes("sn_" + String.format("%04X", replicaId));
    }

    public static byte[] getServerColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVER_QUALIFIER : Bytes.toBytes("server_" + String.format("%04X", replicaId));
    }

    public static byte[] getStartCodeColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STARTCODE_QUALIFIER : Bytes.toBytes("serverstartcode_" + String.format("%04X", replicaId));
    }

    public static byte[] getSeqNumColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SEQNUM_QUALIFIER : Bytes.toBytes("seqnumDuringOpen_" + String.format("%04X", replicaId));
    }

    static int parseReplicaIdFromServerColumn(byte[] serverColumn) {
        String serverStr = Bytes.toString(serverColumn);
        Matcher matcher = SERVER_COLUMN_PATTERN.matcher(serverStr);
        if (matcher.matches() && matcher.groupCount() > 0) {
            String group2 = matcher.group(1);
            if (group2 != null && group2.length() > 0) {
                return Integer.parseInt(group2.substring(1), 16);
            }
            return 0;
        }
        return -1;
    }

    @InterfaceAudience.Private
    @Nullable
    public static ServerName getServerName(Result r, int replicaId) {
        byte[] serverColumn = MetaTableAccessor.getServerColumn(replicaId);
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getCatalogFamily(), serverColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        String hostAndPort = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        byte[] startcodeColumn = MetaTableAccessor.getStartCodeColumn(replicaId);
        cell = r.getColumnLatestCell(MetaTableAccessor.getCatalogFamily(), startcodeColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        try {
            return ServerName.valueOf(hostAndPort, Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Ignoring invalid region for server " + hostAndPort + "; cell=" + cell, e);
            return null;
        }
    }

    @Nullable
    public static ServerName getTargetServerName(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerNameColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            HRegionLocation location;
            RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
            if (locations != null && (location = locations.getRegionLocation(replicaId)) != null) {
                return location.getServerName();
            }
            return null;
        }
        return ServerName.parseServerName(Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
    }

    private static long getSeqNumDuringOpen(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getSeqNumColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            return -1L;
        }
        return Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static PairOfSameType<RegionInfo> getDaughterRegions(Result data) {
        RegionInfo splitA = MetaTableAccessor.getRegionInfo(data, HConstants.SPLITA_QUALIFIER);
        RegionInfo splitB = MetaTableAccessor.getRegionInfo(data, HConstants.SPLITB_QUALIFIER);
        return new PairOfSameType<RegionInfo>(splitA, splitB);
    }

    @Nullable
    public static RegionLocations getRegionLocations(Result r) {
        Map.Entry entry;
        if (r == null) {
            return null;
        }
        RegionInfo regionInfo = MetaTableAccessor.getRegionInfo(r, MetaTableAccessor.getRegionInfoColumn());
        if (regionInfo == null) {
            return null;
        }
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>(1);
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyMap = r.getNoVersionMap();
        locations.add(MetaTableAccessor.getRegionLocation(r, regionInfo, 0));
        NavigableMap infoMap = (NavigableMap)familyMap.get(MetaTableAccessor.getCatalogFamily());
        if (infoMap == null) {
            return new RegionLocations(locations);
        }
        int replicaId = 0;
        byte[] serverColumn = MetaTableAccessor.getServerColumn(replicaId);
        NavigableMap serverMap = infoMap.tailMap(serverColumn, false);
        if (serverMap.isEmpty()) {
            return new RegionLocations(locations);
        }
        Iterator iterator = serverMap.entrySet().iterator();
        while (iterator.hasNext() && (replicaId = MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])(entry = iterator.next()).getKey())) >= 0) {
            HRegionLocation location = MetaTableAccessor.getRegionLocation(r, regionInfo, replicaId);
            if (location.getServerName() == null) {
                locations.add(null);
                continue;
            }
            locations.add(location);
        }
        return new RegionLocations(locations);
    }

    private static HRegionLocation getRegionLocation(Result r, RegionInfo regionInfo, int replicaId) {
        ServerName serverName = MetaTableAccessor.getServerName(r, replicaId);
        long seqNum = MetaTableAccessor.getSeqNumDuringOpen(r, replicaId);
        RegionInfo replicaInfo = RegionReplicaUtil.getRegionInfoForReplica(regionInfo, replicaId);
        return new HRegionLocation(replicaInfo, serverName, seqNum);
    }

    public static RegionInfo getRegionInfo(Result data) {
        return MetaTableAccessor.getRegionInfo(data, HConstants.REGIONINFO_QUALIFIER);
    }

    @Nullable
    public static RegionInfo getRegionInfo(Result r, byte[] qualifier) {
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getCatalogFamily(), qualifier);
        if (cell == null) {
            return null;
        }
        return RegionInfo.parseFromOrNull(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    @Nullable
    public static TableState getTableState(Connection conn, TableName tableName) throws IOException {
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            return new TableState(tableName, TableState.State.ENABLED);
        }
        Table metaHTable = MetaTableAccessor.getMetaHTable(conn);
        Get get2 = new Get(tableName.getName()).addColumn(MetaTableAccessor.getTableFamily(), MetaTableAccessor.getTableStateColumn());
        Result result2 = metaHTable.get(get2);
        return MetaTableAccessor.getTableState(result2);
    }

    public static Map<TableName, TableState> getTableStates(Connection conn) throws IOException {
        LinkedHashMap<TableName, TableState> states = new LinkedHashMap<TableName, TableState>();
        Visitor collector = r -> {
            TableState state = MetaTableAccessor.getTableState(r);
            if (state != null) {
                states.put(state.getTableName(), state);
            }
            return true;
        };
        MetaTableAccessor.fullScanTables(conn, collector);
        return states;
    }

    public static void updateTableState(Connection conn, TableName tableName, TableState.State actual) throws IOException {
        MetaTableAccessor.updateTableState(conn, new TableState(tableName, actual));
    }

    @Nullable
    public static TableState getTableState(Result r) throws IOException {
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getTableFamily(), MetaTableAccessor.getTableStateColumn());
        if (cell == null) {
            return null;
        }
        try {
            return TableState.parseFrom(TableName.valueOf(r.getRow()), Arrays.copyOfRange(cell.getValueArray(), cell.getValueOffset(), cell.getValueOffset() + cell.getValueLength()));
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    public static Put makePutFromRegionInfo(RegionInfo regionInfo, long ts) throws IOException {
        return MetaTableAccessor.addRegionInfo(new Put(regionInfo.getRegionName(), ts), regionInfo);
    }

    public static Delete makeDeleteFromRegionInfo(RegionInfo regionInfo, long ts) {
        if (regionInfo == null) {
            throw new IllegalArgumentException("Can't make a delete for null region");
        }
        Delete delete2 = new Delete(regionInfo.getRegionName());
        delete2.addFamily(MetaTableAccessor.getCatalogFamily(), ts);
        return delete2;
    }

    private static Put addDaughtersToPut(Put put2, RegionInfo splitA, RegionInfo splitB) throws IOException {
        if (splitA != null) {
            put2.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put2.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HConstants.SPLITA_QUALIFIER).setTimestamp(put2.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray(splitA)).build());
        }
        if (splitB != null) {
            put2.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put2.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(HConstants.SPLITB_QUALIFIER).setTimestamp(put2.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray(splitB)).build());
        }
        return put2;
    }

    private static void putToMetaTable(Connection connection, Put p2) throws IOException {
        try (Table table = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.put(table, p2);
        }
    }

    private static void put(Table t, Put p2) throws IOException {
        MetaTableAccessor.debugLogMutation(p2);
        t.put(p2);
    }

    public static void putsToMetaTable(Connection connection, List<Put> ps) throws IOException {
        if (ps.isEmpty()) {
            return;
        }
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.debugLogMutations(ps);
            if (ps.size() == 1) {
                t.put(ps.get(0));
            } else {
                t.put(ps);
            }
        }
    }

    private static void deleteFromMetaTable(Connection connection, Delete d) throws IOException {
        ArrayList<Delete> dels = new ArrayList<Delete>(1);
        dels.add(d);
        MetaTableAccessor.deleteFromMetaTable(connection, dels);
    }

    private static void deleteFromMetaTable(Connection connection, List<Delete> deletes) throws IOException {
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.debugLogMutations(deletes);
            t.delete(deletes);
        }
    }

    private static Put addRegionStateToPut(Put put2, RegionState.State state) throws IOException {
        put2.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put2.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(MetaTableAccessor.getRegionStateColumn()).setTimestamp(put2.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(state.name())).build());
        return put2;
    }

    public static void updateRegionState(Connection connection, RegionInfo ri, RegionState.State state) throws IOException {
        Put put2 = new Put(RegionReplicaUtil.getRegionInfoForDefaultReplica(ri).getRegionName());
        MetaTableAccessor.putsToMetaTable(connection, Collections.singletonList(MetaTableAccessor.addRegionStateToPut(put2, state)));
    }

    public static void addSplitsToParent(Connection connection, RegionInfo regionInfo, RegionInfo splitA, RegionInfo splitB) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            Put put2 = MetaTableAccessor.makePutFromRegionInfo(regionInfo, EnvironmentEdgeManager.currentTime());
            MetaTableAccessor.addDaughtersToPut(put2, splitA, splitB);
            meta.put(put2);
            MetaTableAccessor.debugLogMutation(put2);
            LOG.debug("Added region {}", (Object)regionInfo.getRegionNameAsString());
        }
    }

    public static void addRegionToMeta(Connection connection, RegionInfo regionInfo) throws IOException {
        MetaTableAccessor.addRegionsToMeta(connection, Collections.singletonList(regionInfo), 1);
    }

    public static void addRegionsToMeta(Connection connection, List<RegionInfo> regionInfos, int regionReplication) throws IOException {
        MetaTableAccessor.addRegionsToMeta(connection, regionInfos, regionReplication, EnvironmentEdgeManager.currentTime());
    }

    private static void addRegionsToMeta(Connection connection, List<RegionInfo> regionInfos, int regionReplication, long ts) throws IOException {
        ArrayList<Put> puts2 = new ArrayList<Put>();
        for (RegionInfo regionInfo : regionInfos) {
            if (!RegionReplicaUtil.isDefaultReplica(regionInfo)) continue;
            Put put2 = MetaTableAccessor.makePutFromRegionInfo(regionInfo, ts);
            MetaTableAccessor.addRegionStateToPut(put2, RegionState.State.CLOSED);
            for (int i2 = 1; i2 < regionReplication; ++i2) {
                MetaTableAccessor.addEmptyLocation(put2, i2);
            }
            puts2.add(put2);
        }
        MetaTableAccessor.putsToMetaTable(connection, puts2);
        LOG.info("Added {} regions to meta.", (Object)puts2.size());
    }

    static Put addMergeRegions(Put put2, Collection<RegionInfo> mergeRegions) throws IOException {
        int limit2 = 10000;
        int max2 = mergeRegions.size();
        if (max2 > limit2) {
            throw new RuntimeException("Can't merge " + max2 + " regions in one go; " + limit2 + " is upper-limit.");
        }
        int counter = 0;
        for (RegionInfo ri : mergeRegions) {
            String qualifier = String.format("merge%04d", counter++);
            put2.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put2.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(Bytes.toBytes(qualifier)).setTimestamp(put2.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray(ri)).build());
        }
        return put2;
    }

    public static void mergeRegions(Connection connection, RegionInfo mergedRegion, Map<RegionInfo, Long> parentSeqNum, ServerName sn, int regionReplication) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            long time = Long.MAX_VALUE;
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            ArrayList<RegionInfo> replicationParents = new ArrayList<RegionInfo>();
            for (Map.Entry<RegionInfo, Long> e : parentSeqNum.entrySet()) {
                RegionInfo ri = e.getKey();
                long seqNum = e.getValue();
                mutations.add(MetaTableAccessor.makeDeleteFromRegionInfo(ri, time));
                if (seqNum <= 0L) continue;
                mutations.add(MetaTableAccessor.makePutForReplicationBarrier(ri, seqNum, time));
                replicationParents.add(ri);
            }
            Put putOfMerged = MetaTableAccessor.makePutFromRegionInfo(mergedRegion, time);
            putOfMerged = MetaTableAccessor.addMergeRegions(putOfMerged, parentSeqNum.keySet());
            MetaTableAccessor.addRegionStateToPut(putOfMerged, RegionState.State.CLOSED);
            mutations.add(putOfMerged);
            if (sn != null) {
                MetaTableAccessor.addLocation(putOfMerged, sn, 1L, mergedRegion.getReplicaId());
            }
            for (int i2 = 1; i2 < regionReplication; ++i2) {
                MetaTableAccessor.addEmptyLocation(putOfMerged, i2);
            }
            if (!replicationParents.isEmpty()) {
                MetaTableAccessor.addReplicationParent(putOfMerged, replicationParents);
            }
            byte[] tableRow = Bytes.toBytes(mergedRegion.getRegionNameAsString() + 44);
            MetaTableAccessor.multiMutate(meta, tableRow, mutations);
        }
    }

    public static void splitRegion(Connection connection, RegionInfo parent, long parentOpenSeqNum, RegionInfo splitA, RegionInfo splitB, ServerName sn, int regionReplication) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            long time = EnvironmentEdgeManager.currentTime();
            Put putParent = MetaTableAccessor.makePutFromRegionInfo(RegionInfoBuilder.newBuilder(parent).setOffline(true).setSplit(true).build(), time);
            MetaTableAccessor.addDaughtersToPut(putParent, splitA, splitB);
            Put putA = MetaTableAccessor.makePutFromRegionInfo(splitA, time);
            Put putB = MetaTableAccessor.makePutFromRegionInfo(splitB, time);
            if (parentOpenSeqNum > 0L) {
                MetaTableAccessor.addReplicationBarrier(putParent, parentOpenSeqNum);
                MetaTableAccessor.addReplicationParent(putA, Collections.singletonList(parent));
                MetaTableAccessor.addReplicationParent(putB, Collections.singletonList(parent));
            }
            MetaTableAccessor.addRegionStateToPut(putA, RegionState.State.CLOSED);
            MetaTableAccessor.addRegionStateToPut(putB, RegionState.State.CLOSED);
            MetaTableAccessor.addSequenceNum(putA, 1L, splitA.getReplicaId());
            MetaTableAccessor.addSequenceNum(putB, 1L, splitB.getReplicaId());
            for (int i2 = 1; i2 < regionReplication; ++i2) {
                MetaTableAccessor.addEmptyLocation(putA, i2);
                MetaTableAccessor.addEmptyLocation(putB, i2);
            }
            byte[] tableRow = Bytes.toBytes(parent.getRegionNameAsString() + 44);
            MetaTableAccessor.multiMutate(meta, tableRow, putParent, putA, putB);
        }
    }

    private static void updateTableState(Connection connection, TableState state) throws IOException {
        Put put2 = MetaTableAccessor.makePutFromTableState(state, EnvironmentEdgeManager.currentTime());
        MetaTableAccessor.putToMetaTable(connection, put2);
        LOG.info("Updated {} in hbase:meta", (Object)state);
    }

    public static Put makePutFromTableState(TableState state, long ts) {
        Put put2 = new Put(state.getTableName().getName(), ts);
        put2.addColumn(MetaTableAccessor.getTableFamily(), MetaTableAccessor.getTableStateColumn(), state.convert().toByteArray());
        return put2;
    }

    public static void deleteTableState(Connection connection, TableName table) throws IOException {
        long time = EnvironmentEdgeManager.currentTime();
        Delete delete2 = new Delete(table.getName());
        delete2.addColumns(MetaTableAccessor.getTableFamily(), MetaTableAccessor.getTableStateColumn(), time);
        MetaTableAccessor.deleteFromMetaTable(connection, delete2);
        LOG.info("Deleted table " + table + " state from META");
    }

    private static void multiMutate(Table table, byte[] row, Mutation ... mutations) throws IOException {
        MetaTableAccessor.multiMutate(table, row, Arrays.asList(mutations));
    }

    static void multiMutate(Table table, byte[] row, List<Mutation> mutations) throws IOException {
        MetaTableAccessor.debugLogMutations(mutations);
        Batch.Call<MultiRowMutationProtos.MultiRowMutationService, MultiRowMutationProtos.MutateRowsResponse> callable = instance -> {
            MultiRowMutationProtos.MutateRowsRequest.Builder builder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
            for (Mutation mutation : mutations) {
                if (mutation instanceof Put) {
                    builder.addMutationRequest(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, mutation));
                    continue;
                }
                if (mutation instanceof Delete) {
                    builder.addMutationRequest(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, mutation));
                    continue;
                }
                throw new DoNotRetryIOException("multi in MetaEditor doesn't support " + mutation.getClass().getName());
            }
            ServerRpcController controller = new ServerRpcController();
            CoprocessorRpcUtils.BlockingRpcCallback<MultiRowMutationProtos.MutateRowsResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback<MultiRowMutationProtos.MutateRowsResponse>();
            instance.mutateRows(controller, builder.build(), rpcCallback);
            MultiRowMutationProtos.MutateRowsResponse resp = rpcCallback.get();
            if (controller.failedOnException()) {
                throw controller.getFailedOn();
            }
            return resp;
        };
        try {
            table.coprocessorService(MultiRowMutationProtos.MultiRowMutationService.class, row, row, callable);
        }
        catch (Throwable e) {
            Throwables.throwIfInstanceOf(e, IOException.class);
            throw new IOException(e);
        }
    }

    public static void updateRegionLocation(Connection connection, RegionInfo regionInfo, ServerName sn, long openSeqNum, long masterSystemTime) throws IOException {
        MetaTableAccessor.updateLocation(connection, regionInfo, sn, openSeqNum, masterSystemTime);
    }

    private static void updateLocation(Connection connection, RegionInfo regionInfo, ServerName sn, long openSeqNum, long masterSystemTime) throws IOException {
        Put put2 = new Put(MetaTableAccessor.getMetaKeyForRegion(regionInfo), masterSystemTime);
        MetaTableAccessor.addRegionInfo(put2, regionInfo);
        MetaTableAccessor.addLocation(put2, sn, openSeqNum, regionInfo.getReplicaId());
        MetaTableAccessor.putToMetaTable(connection, put2);
        LOG.info("Updated row {} with server=", (Object)regionInfo.getRegionNameAsString(), (Object)sn);
    }

    public static void deleteRegionInfo(Connection connection, RegionInfo regionInfo) throws IOException {
        Delete delete2 = new Delete(regionInfo.getRegionName());
        delete2.addFamily(MetaTableAccessor.getCatalogFamily(), Long.MAX_VALUE);
        MetaTableAccessor.deleteFromMetaTable(connection, delete2);
        LOG.info("Deleted " + regionInfo.getRegionNameAsString());
    }

    public static void deleteRegionInfos(Connection connection, List<RegionInfo> regionsInfo) throws IOException {
        MetaTableAccessor.deleteRegionInfos(connection, regionsInfo, EnvironmentEdgeManager.currentTime());
    }

    private static void deleteRegionInfos(Connection connection, List<RegionInfo> regionsInfo, long ts) throws IOException {
        ArrayList<Delete> deletes = new ArrayList<Delete>(regionsInfo.size());
        for (RegionInfo hri : regionsInfo) {
            Delete e = new Delete(hri.getRegionName());
            e.addFamily(MetaTableAccessor.getCatalogFamily(), ts);
            deletes.add(e);
        }
        MetaTableAccessor.deleteFromMetaTable(connection, deletes);
        LOG.info("Deleted {} regions from META", (Object)regionsInfo.size());
        LOG.debug("Deleted regions: {}", (Object)regionsInfo);
    }

    public static void overwriteRegions(Connection connection, List<RegionInfo> regionInfos, int regionReplication) throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        MetaTableAccessor.deleteRegionInfos(connection, regionInfos, now);
        MetaTableAccessor.addRegionsToMeta(connection, regionInfos, regionReplication, now + 1L);
        LOG.info("Overwritten " + regionInfos.size() + " regions to Meta");
        LOG.debug("Overwritten regions: {} ", (Object)regionInfos);
    }

    public static void deleteMergeQualifiers(Connection connection, RegionInfo mergeRegion) throws IOException {
        Delete delete2 = new Delete(mergeRegion.getRegionName());
        Cell[] cells = MetaTableAccessor.getRegionResult(connection, mergeRegion.getRegionName()).rawCells();
        if (cells == null || cells.length == 0) {
            return;
        }
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
        for (Cell cell : cells) {
            if (!MetaTableAccessor.isMergeQualifierPrefix(cell)) continue;
            byte[] qualifier = CellUtil.cloneQualifier(cell);
            qualifiers.add(qualifier);
            delete2.addColumns(MetaTableAccessor.getCatalogFamily(), qualifier, Long.MAX_VALUE);
        }
        if (qualifiers.isEmpty()) {
            LOG.info("No merged qualifiers for region " + mergeRegion.getRegionNameAsString() + " in meta table, they are cleaned up already, Skip.");
            return;
        }
        MetaTableAccessor.deleteFromMetaTable(connection, delete2);
        LOG.info("Deleted merge references in " + mergeRegion.getRegionNameAsString() + ", deleted qualifiers " + qualifiers.stream().map(Bytes::toStringBinary).collect(Collectors.joining(", ")));
    }

    public static Put addRegionInfo(Put p2, RegionInfo hri) throws IOException {
        p2.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(p2.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(HConstants.REGIONINFO_QUALIFIER).setTimestamp(p2.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray(RegionReplicaUtil.getRegionInfoForDefaultReplica(hri))).build());
        return p2;
    }

    public static Put addLocation(Put p2, ServerName sn, long openSeqNum, int replicaId) throws IOException {
        CellBuilder builder = CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);
        return p2.add(builder.clear().setRow(p2.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(MetaTableAccessor.getServerColumn(replicaId)).setTimestamp(p2.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(sn.getAddress().toString())).build()).add(builder.clear().setRow(p2.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(MetaTableAccessor.getStartCodeColumn(replicaId)).setTimestamp(p2.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(sn.getStartcode())).build()).add(builder.clear().setRow(p2.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(MetaTableAccessor.getSeqNumColumn(replicaId)).setTimestamp(p2.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(openSeqNum)).build());
    }

    private static void writeRegionName(ByteArrayOutputStream out, byte[] regionName) {
        for (byte b : regionName) {
            if (b == -1) {
                out.write(-1);
            }
            out.write(b);
        }
    }

    public static byte[] getParentsBytes(List<RegionInfo> parents) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Iterator<RegionInfo> iter = parents.iterator();
        MetaTableAccessor.writeRegionName(bos, iter.next().getRegionName());
        while (iter.hasNext()) {
            bos.write(-1);
            bos.write(0);
            MetaTableAccessor.writeRegionName(bos, iter.next().getRegionName());
        }
        return bos.toByteArray();
    }

    private static List<byte[]> parseParentsBytes(byte[] bytes2) {
        ArrayList<byte[]> parents = new ArrayList<byte[]>();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < bytes2.length; ++i2) {
            if (bytes2[i2] == -1 && bytes2[++i2] == 0) {
                parents.add(bos.toByteArray());
                bos.reset();
                continue;
            }
            bos.write(bytes2[i2]);
        }
        if (bos.size() > 0) {
            parents.add(bos.toByteArray());
        }
        return parents;
    }

    private static void addReplicationParent(Put put2, List<RegionInfo> parents) throws IOException {
        byte[] value2 = MetaTableAccessor.getParentsBytes(parents);
        put2.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put2.getRow()).setFamily(HConstants.REPLICATION_BARRIER_FAMILY).setQualifier(REPLICATION_PARENT_QUALIFIER).setTimestamp(put2.getTimestamp()).setType(Cell.Type.Put).setValue(value2).build());
    }

    public static Put makePutForReplicationBarrier(RegionInfo regionInfo, long openSeqNum, long ts) throws IOException {
        Put put2 = new Put(regionInfo.getRegionName(), ts);
        MetaTableAccessor.addReplicationBarrier(put2, openSeqNum);
        return put2;
    }

    public static void addReplicationBarrier(Put put2, long openSeqNum) throws IOException {
        put2.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put2.getRow()).setFamily(HConstants.REPLICATION_BARRIER_FAMILY).setQualifier(HConstants.SEQNUM_QUALIFIER).setTimestamp(put2.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(openSeqNum)).build());
    }

    public static Put addEmptyLocation(Put p2, int replicaId) throws IOException {
        CellBuilder builder = CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);
        return p2.add(builder.clear().setRow(p2.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(MetaTableAccessor.getServerColumn(replicaId)).setTimestamp(p2.getTimestamp()).setType(Cell.Type.Put).build()).add(builder.clear().setRow(p2.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(MetaTableAccessor.getStartCodeColumn(replicaId)).setTimestamp(p2.getTimestamp()).setType(Cell.Type.Put).build()).add(builder.clear().setRow(p2.getRow()).setFamily(MetaTableAccessor.getCatalogFamily()).setQualifier(MetaTableAccessor.getSeqNumColumn(replicaId)).setTimestamp(p2.getTimestamp()).setType(Cell.Type.Put).build());
    }

    private static long getReplicationBarrier(Cell c) {
        return Bytes.toLong(c.getValueArray(), c.getValueOffset(), c.getValueLength());
    }

    public static long[] getReplicationBarriers(Result result2) {
        return result2.getColumnCells(HConstants.REPLICATION_BARRIER_FAMILY, HConstants.SEQNUM_QUALIFIER).stream().mapToLong(MetaTableAccessor::getReplicationBarrier).sorted().distinct().toArray();
    }

    private static ReplicationBarrierResult getReplicationBarrierResult(Result result2) {
        long[] barriers = MetaTableAccessor.getReplicationBarriers(result2);
        byte[] stateBytes = result2.getValue(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getRegionStateColumn());
        RegionState.State state = stateBytes != null ? RegionState.State.valueOf(Bytes.toString(stateBytes)) : null;
        byte[] parentRegionsBytes = result2.getValue(HConstants.REPLICATION_BARRIER_FAMILY, REPLICATION_PARENT_QUALIFIER);
        List<byte[]> parentRegionNames = parentRegionsBytes != null ? MetaTableAccessor.parseParentsBytes(parentRegionsBytes) : Collections.emptyList();
        return new ReplicationBarrierResult(barriers, state, parentRegionNames);
    }

    /*
     * Exception decompiling
     */
    public static ReplicationBarrierResult getReplicationBarrierResult(Connection conn, TableName tableName, byte[] row, byte[] encodedRegionName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long[] getReplicationBarrier(Connection conn, byte[] regionName) throws IOException {
        try (Table table = MetaTableAccessor.getMetaHTable(conn);){
            Result result2 = table.get(new Get(regionName).addColumn(HConstants.REPLICATION_BARRIER_FAMILY, HConstants.SEQNUM_QUALIFIER).readAllVersions());
            long[] lArray = MetaTableAccessor.getReplicationBarriers(result2);
            return lArray;
        }
    }

    public static List<Pair<String, Long>> getTableEncodedRegionNameAndLastBarrier(Connection conn, TableName tableName) throws IOException {
        ArrayList<Pair<String, Long>> list2 = new ArrayList<Pair<String, Long>>();
        MetaTableAccessor.scanMeta(conn, MetaTableAccessor.getTableStartRowForMeta(tableName, QueryType.REPLICATION), MetaTableAccessor.getTableStopRowForMeta(tableName, QueryType.REPLICATION), QueryType.REPLICATION, (Result r) -> {
            byte[] value2 = r.getValue(HConstants.REPLICATION_BARRIER_FAMILY, HConstants.SEQNUM_QUALIFIER);
            if (value2 == null) {
                return true;
            }
            long lastBarrier = Bytes.toLong(value2);
            String encodedRegionName = RegionInfo.encodeRegionName(r.getRow());
            list2.add(Pair.newPair(encodedRegionName, lastBarrier));
            return true;
        });
        return list2;
    }

    public static List<String> getTableEncodedRegionNamesForSerialReplication(Connection conn, TableName tableName) throws IOException {
        ArrayList<String> list2 = new ArrayList<String>();
        MetaTableAccessor.scanMeta(conn, MetaTableAccessor.getTableStartRowForMeta(tableName, QueryType.REPLICATION), MetaTableAccessor.getTableStopRowForMeta(tableName, QueryType.REPLICATION), QueryType.REPLICATION, new FirstKeyOnlyFilter(), Integer.MAX_VALUE, r -> {
            list2.add(RegionInfo.encodeRegionName(r.getRow()));
            return true;
        });
        return list2;
    }

    private static void debugLogMutations(List<? extends Mutation> mutations) throws IOException {
        if (!METALOG.isDebugEnabled()) {
            return;
        }
        for (Mutation mutation : mutations) {
            MetaTableAccessor.debugLogMutation(mutation);
        }
    }

    private static void debugLogMutation(Mutation p2) throws IOException {
        METALOG.debug("{} {}", (Object)p2.getClass().getSimpleName(), (Object)p2.toJSON());
    }

    private static Put addSequenceNum(Put p2, long openSeqNum, int replicaId) throws IOException {
        return p2.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(p2.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(MetaTableAccessor.getSeqNumColumn(replicaId)).setTimestamp(p2.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(openSeqNum)).build());
    }

    public static final class ReplicationBarrierResult {
        private final long[] barriers;
        private final RegionState.State state;
        private final List<byte[]> parentRegionNames;

        ReplicationBarrierResult(long[] barriers, RegionState.State state, List<byte[]> parentRegionNames) {
            this.barriers = barriers;
            this.state = state;
            this.parentRegionNames = parentRegionNames;
        }

        public long[] getBarriers() {
            return this.barriers;
        }

        public RegionState.State getState() {
            return this.state;
        }

        public List<byte[]> getParentRegionNames() {
            return this.parentRegionNames;
        }

        public String toString() {
            return "ReplicationBarrierResult [barriers=" + Arrays.toString(this.barriers) + ", state=" + (Object)((Object)this.state) + ", parentRegionNames=" + this.parentRegionNames.stream().map(Bytes::toStringBinary).collect(Collectors.joining(", ")) + "]";
        }
    }

    public static abstract class TableVisitorBase
    extends DefaultVisitorBase {
        private TableName tableName;

        public TableVisitorBase(TableName tableName) {
            this.tableName = tableName;
        }

        @Override
        public final boolean visit(Result rowResult) throws IOException {
            RegionInfo info = MetaTableAccessor.getRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!info.getTable().equals(this.tableName)) {
                return false;
            }
            return super.visit(rowResult);
        }
    }

    public static abstract class DefaultVisitorBase
    implements Visitor {
        DefaultVisitorBase() {
        }

        public abstract boolean visitInternal(Result var1) throws IOException;

        @Override
        public boolean visit(Result rowResult) throws IOException {
            RegionInfo info = MetaTableAccessor.getRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!info.isOffline() && !info.isSplit()) {
                return this.visitInternal(rowResult);
            }
            return true;
        }
    }

    static class CollectAllVisitor
    extends CollectingVisitor<Result> {
        CollectAllVisitor() {
        }

        @Override
        void add(Result r) {
            this.results.add(r);
        }
    }

    static abstract class CollectingVisitor<T>
    implements Visitor {
        final List<T> results = new ArrayList<T>();

        CollectingVisitor() {
        }

        @Override
        public boolean visit(Result r) throws IOException {
            if (r != null && !r.isEmpty()) {
                this.add(r);
            }
            return true;
        }

        abstract void add(Result var1);

        List<T> getResults() {
            return this.results;
        }
    }

    public static interface CloseableVisitor
    extends Visitor,
    Closeable {
    }

    public static interface Visitor {
        public boolean visit(Result var1) throws IOException;
    }

    @InterfaceAudience.Private
    public static enum QueryType {
        ALL(HConstants.TABLE_FAMILY, HConstants.CATALOG_FAMILY),
        REGION(new byte[][]{HConstants.CATALOG_FAMILY}),
        TABLE(new byte[][]{HConstants.TABLE_FAMILY}),
        REPLICATION(new byte[][]{HConstants.REPLICATION_BARRIER_FAMILY});

        private final byte[][] families;

        private QueryType(byte[] ... families) {
            this.families = families;
        }

        byte[][] getFamilies() {
            return this.families;
        }
    }
}

