/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class ClientIdGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ClientIdGenerator.class);

    private ClientIdGenerator() {
    }

    public static byte[] generateClientId() {
        byte[] selfBytes = ClientIdGenerator.getIpAddressBytes();
        Long pid2 = ClientIdGenerator.getPid();
        long tid = Thread.currentThread().getId();
        long ts = System.currentTimeMillis();
        byte[] id2 = new byte[selfBytes.length + ((pid2 != null ? 1 : 0) + 2) * 8];
        int offset2 = Bytes.putBytes(id2, 0, selfBytes, 0, selfBytes.length);
        if (pid2 != null) {
            offset2 = Bytes.putLong(id2, offset2, pid2);
        }
        offset2 = Bytes.putLong(id2, offset2, tid);
        offset2 = Bytes.putLong(id2, offset2, ts);
        assert (offset2 == id2.length);
        return id2;
    }

    public static Long getPid() {
        String name2 = ManagementFactory.getRuntimeMXBean().getName();
        String[] nameParts = name2.split("@");
        if (nameParts.length == 2) {
            try {
                return Long.parseLong(nameParts[0]);
            }
            catch (NumberFormatException ex) {
                LOG.warn("Failed to get PID from [" + name2 + "]", ex);
            }
        } else {
            LOG.warn("Don't know how to get PID from [" + name2 + "]");
        }
        return null;
    }

    public static byte[] getIpAddressBytes() {
        try {
            return Addressing.getIpAddress().getAddress();
        }
        catch (IOException ex) {
            LOG.warn("Failed to get IP address bytes", ex);
            return new byte[0];
        }
    }
}

