/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class BinaryPrefixComparator
extends ByteArrayComparable {
    public BinaryPrefixComparator(byte[] value2) {
        super(value2);
    }

    @Override
    public int compareTo(byte[] value2, int offset2, int length2) {
        return Bytes.compareTo(this.value, 0, this.value.length, value2, offset2, this.value.length <= length2 ? this.value.length : length2);
    }

    @Override
    public int compareTo(ByteBuffer value2, int offset2, int length2) {
        if (this.value.length <= length2) {
            length2 = this.value.length;
        }
        return ByteBufferUtils.compareTo(this.value, 0, this.value.length, value2, offset2, length2);
    }

    @Override
    public byte[] toByteArray() {
        ComparatorProtos.BinaryPrefixComparator.Builder builder = ComparatorProtos.BinaryPrefixComparator.newBuilder();
        builder.setComparable(ProtobufUtil.toByteArrayComparable(this.value));
        return builder.build().toByteArray();
    }

    public static BinaryPrefixComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.BinaryPrefixComparator proto;
        try {
            proto = ComparatorProtos.BinaryPrefixComparator.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new BinaryPrefixComparator(proto.getComparable().getValue().toByteArray());
    }

    @Override
    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BinaryPrefixComparator)) {
            return false;
        }
        return super.areSerializedFieldsEqual(other);
    }
}

