/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class LongComparator
extends ByteArrayComparable {
    private long longValue;

    public LongComparator(long value2) {
        super(Bytes.toBytes(value2));
        this.longValue = value2;
    }

    @Override
    public int compareTo(byte[] value2, int offset2, int length2) {
        long that = Bytes.toLong(value2, offset2, length2);
        return Long.compare(this.longValue, that);
    }

    @Override
    public int compareTo(ByteBuffer value2, int offset2, int length2) {
        long that = ByteBufferUtils.toLong(value2, offset2);
        return Long.compare(this.longValue, that);
    }

    @Override
    public byte[] toByteArray() {
        ComparatorProtos.LongComparator.Builder builder = ComparatorProtos.LongComparator.newBuilder();
        builder.setComparable(ProtobufUtil.toByteArrayComparable(this.value));
        return builder.build().toByteArray();
    }

    public static LongComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.LongComparator proto;
        try {
            proto = ComparatorProtos.LongComparator.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new LongComparator(Bytes.toLong(proto.getComparable().getValue().toByteArray()));
    }

    boolean areSerializedFieldsEqual(LongComparator other) {
        if (other == this) {
            return true;
        }
        return super.areSerializedFieldsEqual(other);
    }
}

