/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class SingleColumnValueExcludeFilter
extends SingleColumnValueFilter {
    @Deprecated
    public SingleColumnValueExcludeFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value2) {
        super(family, qualifier, compareOp, value2);
    }

    public SingleColumnValueExcludeFilter(byte[] family, byte[] qualifier, CompareOperator op, byte[] value2) {
        super(family, qualifier, op, value2);
    }

    @Deprecated
    public SingleColumnValueExcludeFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator) {
        super(family, qualifier, compareOp, comparator);
    }

    public SingleColumnValueExcludeFilter(byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator) {
        super(family, qualifier, op, comparator);
    }

    @Deprecated
    protected SingleColumnValueExcludeFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, boolean filterIfMissing, boolean latestVersionOnly) {
        this(family, qualifier, CompareOperator.valueOf(compareOp.name()), comparator, filterIfMissing, latestVersionOnly);
    }

    protected SingleColumnValueExcludeFilter(byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator, boolean filterIfMissing, boolean latestVersionOnly) {
        super(family, qualifier, op, comparator, filterIfMissing, latestVersionOnly);
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    @Override
    public void filterRowCells(List<Cell> kvs) {
        Iterator<Cell> it = kvs.iterator();
        while (it.hasNext()) {
            if (!CellUtil.matchingColumn(it.next(), this.columnFamily, this.columnQualifier)) continue;
            it.remove();
        }
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        SingleColumnValueFilter tempFilter = (SingleColumnValueFilter)SingleColumnValueFilter.createFilterFromArguments(filterArguments);
        SingleColumnValueExcludeFilter filter = new SingleColumnValueExcludeFilter(tempFilter.getFamily(), tempFilter.getQualifier(), tempFilter.getOperator(), tempFilter.getComparator());
        if (filterArguments.size() == 6) {
            filter.setFilterIfMissing(tempFilter.getFilterIfMissing());
            filter.setLatestVersionOnly(tempFilter.getLatestVersionOnly());
        }
        return filter;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.SingleColumnValueExcludeFilter.Builder builder = FilterProtos.SingleColumnValueExcludeFilter.newBuilder();
        builder.setSingleColumnValueFilter(super.convert());
        return builder.build().toByteArray();
    }

    public static SingleColumnValueExcludeFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        ByteArrayComparable comparator;
        FilterProtos.SingleColumnValueExcludeFilter proto;
        try {
            proto = FilterProtos.SingleColumnValueExcludeFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        FilterProtos.SingleColumnValueFilter parentProto = proto.getSingleColumnValueFilter();
        CompareOperator compareOp = CompareOperator.valueOf(parentProto.getCompareOp().name());
        try {
            comparator = ProtobufUtil.toComparator(parentProto.getComparator());
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
        return new SingleColumnValueExcludeFilter(parentProto.hasColumnFamily() ? parentProto.getColumnFamily().toByteArray() : null, parentProto.hasColumnQualifier() ? parentProto.getColumnQualifier().toByteArray() : null, compareOp, comparator, parentProto.getFilterIfMissing(), parentProto.getLatestVersionOnly());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleColumnValueExcludeFilter)) {
            return false;
        }
        return super.areSerializedFieldsEqual(o);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

