/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.util.Dictionary;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IOUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TagCompressionContext {
    private final Dictionary tagDict;

    public TagCompressionContext(Class<? extends Dictionary> dictType, int dictCapacity) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<? extends Dictionary> dictConstructor = dictType.getConstructor(new Class[0]);
        this.tagDict = dictConstructor.newInstance(new Object[0]);
        this.tagDict.init(dictCapacity);
    }

    public void clear() {
        this.tagDict.clear();
    }

    public void compressTags(OutputStream out, byte[] in, int offset2, int length2) throws IOException {
        int tagLen;
        int pos2;
        int endOffset = pos2 + length2;
        assert (pos2 < endOffset);
        for (pos2 = offset2; pos2 < endOffset; pos2 += tagLen) {
            tagLen = Bytes.readAsInt(in, pos2, 2);
            Dictionary.write(out, in, pos2 += 2, tagLen, this.tagDict);
        }
    }

    public void compressTags(OutputStream out, ByteBuffer in, int offset2, int length2) throws IOException {
        if (in.hasArray()) {
            this.compressTags(out, in.array(), offset2, length2);
        } else {
            int tagLen;
            int pos2;
            int endOffset = pos2 + length2;
            assert (pos2 < endOffset);
            for (pos2 = offset2; pos2 < endOffset; pos2 += tagLen) {
                tagLen = ByteBufferUtils.readAsInt(in, pos2, 2);
                Dictionary.write(out, in, pos2 += 2, tagLen, this.tagDict);
            }
        }
    }

    public void uncompressTags(InputStream src, byte[] dest, int offset2, int length2) throws IOException {
        int endOffset = offset2 + length2;
        while (offset2 < endOffset) {
            byte status2 = (byte)src.read();
            if (status2 == -1) {
                int tagLen = StreamUtils.readRawVarint32(src);
                offset2 = Bytes.putAsShort(dest, offset2, tagLen);
                IOUtils.readFully((InputStream)src, (byte[])dest, (int)offset2, (int)tagLen);
                this.tagDict.addEntry(dest, offset2, tagLen);
                offset2 += tagLen;
                continue;
            }
            short dictIdx = StreamUtils.toShort(status2, (byte)src.read());
            byte[] entry = this.tagDict.getEntry(dictIdx);
            if (entry == null) {
                throw new IOException("Missing dictionary entry for index " + dictIdx);
            }
            offset2 = Bytes.putAsShort(dest, offset2, entry.length);
            System.arraycopy(entry, 0, dest, offset2, entry.length);
            offset2 += entry.length;
        }
    }

    public int uncompressTags(ByteBuff src, byte[] dest, int offset2, int length2) throws IOException {
        int srcBeginPos = src.position();
        int endOffset = offset2 + length2;
        while (offset2 < endOffset) {
            int tagLen;
            byte status2 = src.get();
            if (status2 == -1) {
                tagLen = StreamUtils.readRawVarint32(src);
                offset2 = Bytes.putAsShort(dest, offset2, tagLen);
                src.get(dest, offset2, tagLen);
                this.tagDict.addEntry(dest, offset2, tagLen);
                offset2 += tagLen;
                continue;
            }
            short dictIdx = StreamUtils.toShort(status2, src.get());
            byte[] entry = this.tagDict.getEntry(dictIdx);
            if (entry == null) {
                throw new IOException("Missing dictionary entry for index " + dictIdx);
            }
            tagLen = entry.length;
            offset2 = Bytes.putAsShort(dest, offset2, tagLen);
            System.arraycopy(entry, 0, dest, offset2, tagLen);
            offset2 += tagLen;
        }
        return src.position() - srcBeginPos;
    }

    public void uncompressTags(InputStream src, ByteBuffer dest, int length2) throws IOException {
        if (dest.hasArray()) {
            this.uncompressTags(src, dest.array(), dest.arrayOffset() + dest.position(), length2);
        } else {
            byte[] tagBuf = new byte[length2];
            this.uncompressTags(src, tagBuf, 0, length2);
            dest.put(tagBuf);
        }
    }
}

