/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class QuotaRetriever
implements Closeable,
Iterable<QuotaSettings> {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaRetriever.class);
    private final Queue<QuotaSettings> cache = new LinkedList<QuotaSettings>();
    private ResultScanner scanner;
    private Connection connection;
    private Table table;
    private boolean isManagedConnection = false;

    QuotaRetriever() {
    }

    void init(Configuration conf, Scan scan2) throws IOException {
        this.isManagedConnection = true;
        this.init(ConnectionFactory.createConnection(conf), scan2);
    }

    void init(Connection conn, Scan scan2) throws IOException {
        this.connection = Objects.requireNonNull(conn);
        this.table = this.connection.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
        try {
            this.scanner = this.table.getScanner(scan2);
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException ioe) {
                LOG.warn("Failed getting scanner and then failed close on cleanup", e);
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.table != null) {
            this.table.close();
            this.table = null;
        }
        if (this.isManagedConnection && this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    public QuotaSettings next() throws IOException {
        if (this.cache.isEmpty()) {
            Result result2 = this.scanner.next();
            if (result2 != null && Bytes.equals(result2.getRow(), QuotaTableUtil.getExceedThrottleQuotaRowKey())) {
                result2 = this.scanner.next();
            }
            if (result2 == null) {
                return null;
            }
            QuotaTableUtil.parseResultToCollection(result2, this.cache);
        }
        return this.cache.poll();
    }

    @Override
    public Iterator<QuotaSettings> iterator() {
        return new Iter();
    }

    public static QuotaRetriever open(Configuration conf) throws IOException {
        return QuotaRetriever.open(conf, null);
    }

    public static QuotaRetriever open(Configuration conf, QuotaFilter filter) throws IOException {
        Scan scan2 = QuotaTableUtil.makeScan(filter);
        QuotaRetriever scanner = new QuotaRetriever();
        scanner.init(conf, scan2);
        return scanner;
    }

    private class Iter
    implements Iterator<QuotaSettings> {
        QuotaSettings cache;

        public Iter() {
            try {
                this.cache = QuotaRetriever.this.next();
            }
            catch (IOException e) {
                LOG.warn(StringUtils.stringifyException((Throwable)e));
            }
        }

        @Override
        public boolean hasNext() {
            return this.cache != null;
        }

        @Override
        public QuotaSettings next() {
            QuotaSettings result2 = this.cache;
            try {
                this.cache = QuotaRetriever.this.next();
            }
            catch (IOException e) {
                LOG.warn(StringUtils.stringifyException((Throwable)e));
            }
            return result2;
        }

        @Override
        public void remove() {
            throw new RuntimeException("remove() not supported");
        }
    }
}

