/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RawInteger
implements DataType<Integer> {
    @Override
    public boolean isOrderPreserving() {
        return false;
    }

    @Override
    public Order getOrder() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    @Override
    public int encodedLength(Integer val) {
        return 4;
    }

    @Override
    public Class<Integer> encodedClass() {
        return Integer.class;
    }

    @Override
    public int skip(PositionedByteRange src) {
        src.setPosition(src.getPosition() + 4);
        return 4;
    }

    @Override
    public Integer decode(PositionedByteRange src) {
        int val = Bytes.toInt(src.getBytes(), src.getOffset() + src.getPosition());
        this.skip(src);
        return val;
    }

    @Override
    public int encode(PositionedByteRange dst, Integer val) {
        Bytes.putInt(dst.getBytes(), dst.getOffset() + dst.getPosition(), val);
        return this.skip(dst);
    }

    public int decodeInt(byte[] buff, int offset2) {
        return Bytes.toInt(buff, offset2);
    }

    public int encodeInt(byte[] buff, int offset2, int val) {
        return Bytes.putInt(buff, offset2, val);
    }
}

