/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ConcatenatedLists<T>
extends AbstractCollection<T> {
    protected final ArrayList<List<T>> components = new ArrayList();
    protected int size = 0;

    public void addAllSublists(List<? extends List<T>> items) {
        for (List<T> list2 : items) {
            this.addSublist(list2);
        }
    }

    public void addSublist(List<T> items) {
        if (!items.isEmpty()) {
            this.components.add(items);
            this.size += items.size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public java.util.Iterator<T> iterator() {
        return new Iterator();
    }

    @SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="nextWasCalled is using by StripeStoreFileManager")
    public class Iterator
    implements java.util.Iterator<T> {
        protected int currentComponent = 0;
        protected int indexWithinComponent = -1;
        protected boolean nextWasCalled = false;

        @Override
        public boolean hasNext() {
            return this.currentComponent + 1 < ConcatenatedLists.this.components.size() || this.currentComponent + 1 == ConcatenatedLists.this.components.size() && this.indexWithinComponent + 1 < ConcatenatedLists.this.components.get(this.currentComponent).size();
        }

        @Override
        public T next() {
            if (!ConcatenatedLists.this.components.isEmpty()) {
                this.nextWasCalled = true;
                List src = ConcatenatedLists.this.components.get(this.currentComponent);
                if (++this.indexWithinComponent < src.size()) {
                    return src.get(this.indexWithinComponent);
                }
                if (++this.currentComponent < ConcatenatedLists.this.components.size()) {
                    this.indexWithinComponent = 0;
                    src = ConcatenatedLists.this.components.get(this.currentComponent);
                    assert (src.size() > 0);
                    return src.get(this.indexWithinComponent);
                }
            }
            this.nextWasCalled = false;
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

