/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.util.AbstractByteRange;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class SimpleMutableByteRange
extends AbstractByteRange {
    public SimpleMutableByteRange() {
        this.unset();
    }

    public SimpleMutableByteRange(int capacity) {
        this(new byte[capacity]);
    }

    public SimpleMutableByteRange(byte[] bytes2) {
        this.set(bytes2);
    }

    public SimpleMutableByteRange(byte[] bytes2, int offset2, int length2) {
        this.set(bytes2, offset2, length2);
    }

    @Override
    public ByteRange unset() {
        this.clearHashCache();
        this.bytes = null;
        this.offset = 0;
        this.length = 0;
        return this;
    }

    @Override
    public ByteRange put(int index2, byte val) {
        this.bytes[this.offset + index2] = val;
        this.clearHashCache();
        return this;
    }

    @Override
    public ByteRange put(int index2, byte[] val) {
        if (0 == val.length) {
            return this;
        }
        return this.put(index2, val, 0, val.length);
    }

    @Override
    public ByteRange put(int index2, byte[] val, int offset2, int length2) {
        if (0 == length2) {
            return this;
        }
        System.arraycopy(val, offset2, this.bytes, this.offset + index2, length2);
        this.clearHashCache();
        return this;
    }

    @Override
    public ByteRange putShort(int index2, short val) {
        this.bytes[this.offset + index2 + 1] = (byte)val;
        val = (short)(val >> 8);
        this.bytes[this.offset + index2] = (byte)val;
        this.clearHashCache();
        return this;
    }

    @Override
    public ByteRange putInt(int index2, int val) {
        for (int i2 = 3; i2 > 0; --i2) {
            this.bytes[this.offset + index2 + i2] = (byte)val;
            val >>>= 8;
        }
        this.bytes[this.offset + index2] = (byte)val;
        this.clearHashCache();
        return this;
    }

    @Override
    public ByteRange putLong(int index2, long val) {
        for (int i2 = 7; i2 > 0; --i2) {
            this.bytes[this.offset + index2 + i2] = (byte)val;
            val >>>= 8;
        }
        this.bytes[this.offset + index2] = (byte)val;
        this.clearHashCache();
        return this;
    }

    @Override
    public int putVLong(int index2, long val) {
        int rPos = 0;
        while (true) {
            if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.bytes[this.offset + index2 + rPos] = (byte)(val & 0x7FL | 0x80L);
            val >>>= 7;
            ++rPos;
        }
        this.bytes[this.offset + index2 + rPos] = (byte)val;
        this.clearHashCache();
        return rPos + 1;
    }

    @Override
    public ByteRange deepCopy() {
        SimpleMutableByteRange clone = new SimpleMutableByteRange(this.deepCopyToNewArray());
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    @Override
    public ByteRange shallowCopy() {
        SimpleMutableByteRange clone = new SimpleMutableByteRange(this.bytes, this.offset, this.length);
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    @Override
    public ByteRange shallowCopySubRange(int innerOffset, int copyLength) {
        SimpleMutableByteRange clone = new SimpleMutableByteRange(this.bytes, this.offset + innerOffset, copyLength);
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    @Override
    public boolean equals(Object thatObject) {
        if (thatObject == null) {
            return false;
        }
        if (this == thatObject) {
            return true;
        }
        if (this.hashCode() != thatObject.hashCode()) {
            return false;
        }
        if (!(thatObject instanceof SimpleMutableByteRange)) {
            return false;
        }
        SimpleMutableByteRange that = (SimpleMutableByteRange)thatObject;
        return Bytes.equals(this.bytes, this.offset, this.length, that.bytes, that.offset, that.length);
    }
}

