/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.util.AuthToken;

public class AuthenticationToken
extends AuthToken {
    public static final AuthenticationToken ANONYMOUS = new AuthenticationToken();

    private AuthenticationToken() {
    }

    private AuthenticationToken(AuthToken token) {
        super(token.getUserName(), token.getName(), token.getType());
        this.setMaxInactives(token.getMaxInactives());
        this.setExpires(token.getExpires());
    }

    public AuthenticationToken(String userName, String principal, String type2) {
        super(userName, principal, type2);
    }

    @Override
    public void setMaxInactives(long maxInactives) {
        if (this != ANONYMOUS) {
            super.setMaxInactives(maxInactives);
        }
    }

    @Override
    public void setExpires(long expires) {
        if (this != ANONYMOUS) {
            super.setExpires(expires);
        }
    }

    @Override
    public boolean isExpired() {
        return super.isExpired();
    }

    public static AuthenticationToken parse(String tokenStr) throws AuthenticationException {
        return new AuthenticationToken(AuthToken.parse(tokenStr));
    }
}

