/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.hadoop.security.authentication.util.SignerException;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;

public class Signer {
    private static final String SIGNATURE = "&s=";
    private static final String SIGNING_ALGORITHM = "HmacSHA256";
    private SignerSecretProvider secretProvider;

    public Signer(SignerSecretProvider secretProvider) {
        if (secretProvider == null) {
            throw new IllegalArgumentException("secretProvider cannot be NULL");
        }
        this.secretProvider = secretProvider;
    }

    public synchronized String sign(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("NULL or empty string to sign");
        }
        byte[] secret = this.secretProvider.getCurrentSecret();
        String signature = this.computeSignature(secret, str);
        return str + SIGNATURE + signature;
    }

    public String verifyAndExtract(String signedStr) throws SignerException {
        int index2 = signedStr.lastIndexOf(SIGNATURE);
        if (index2 == -1) {
            throw new SignerException("Invalid signed text: " + signedStr);
        }
        String originalSignature = signedStr.substring(index2 + SIGNATURE.length());
        String rawValue = signedStr.substring(0, index2);
        this.checkSignatures(rawValue, originalSignature);
        return rawValue;
    }

    protected String computeSignature(byte[] secret, String str) {
        try {
            SecretKeySpec key2 = new SecretKeySpec(secret, SIGNING_ALGORITHM);
            Mac mac = Mac.getInstance(SIGNING_ALGORITHM);
            mac.init(key2);
            byte[] sig = mac.doFinal(StringUtils.getBytesUtf8(str));
            return new Base64(0).encodeToString(sig);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new RuntimeException("It should not happen, " + ex.getMessage(), ex);
        }
    }

    protected void checkSignatures(String rawValue, String originalSignature) throws SignerException {
        byte[] orginalSignatureBytes = StringUtils.getBytesUtf8(originalSignature);
        boolean isValid = false;
        byte[][] secrets = this.secretProvider.getAllSecrets();
        for (int i2 = 0; i2 < secrets.length; ++i2) {
            String currentSignature;
            byte[] secret = secrets[i2];
            if (secret == null || !MessageDigest.isEqual(orginalSignatureBytes, StringUtils.getBytesUtf8(currentSignature = this.computeSignature(secret, rawValue)))) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            throw new SignerException("Invalid signature");
        }
    }
}

