/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hbase.thirdparty.com.google.common.math.IntMath;
import org.apache.hbase.thirdparty.com.google.common.math.LongMath;
import org.apache.hbase.thirdparty.com.google.protobuf.Duration;
import org.apache.hbase.thirdparty.com.google.protobuf.Timestamp;
import org.apache.hbase.thirdparty.com.google.protobuf.util.Durations;

public final class Timestamps {
    static final long TIMESTAMP_SECONDS_MIN = -62135596800L;
    static final long TIMESTAMP_SECONDS_MAX = 253402300799L;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MILLISECOND = 1000000L;
    static final long NANOS_PER_MICROSECOND = 1000L;
    static final long MILLIS_PER_SECOND = 1000L;
    static final long MICROS_PER_SECOND = 1000000L;
    public static final Timestamp MIN_VALUE = Timestamp.newBuilder().setSeconds(-62135596800L).setNanos(0).build();
    public static final Timestamp MAX_VALUE = Timestamp.newBuilder().setSeconds(253402300799L).setNanos(999999999).build();
    public static final Timestamp EPOCH = Timestamp.newBuilder().setSeconds(0L).setNanos(0).build();
    private static final ThreadLocal<SimpleDateFormat> timestampFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return Timestamps.createTimestampFormat();
        }
    };

    private static SimpleDateFormat createTimestampFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        sdf.setCalendar(calendar);
        return sdf;
    }

    private Timestamps() {
    }

    public static Comparator<Timestamp> comparator() {
        return TimestampComparator.INSTANCE;
    }

    public static int compare(Timestamp x, Timestamp y) {
        return TimestampComparator.INSTANCE.compare(x, y);
    }

    public static boolean isValid(Timestamp timestamp) {
        return Timestamps.isValid(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static boolean isValid(long seconds, int nanos) {
        if (seconds < -62135596800L || seconds > 253402300799L) {
            return false;
        }
        return nanos >= 0 && (long)nanos < 1000000000L;
    }

    @CanIgnoreReturnValue
    public static Timestamp checkValid(Timestamp timestamp) {
        int nanos;
        long seconds = timestamp.getSeconds();
        if (!Timestamps.isValid(seconds, nanos = timestamp.getNanos())) {
            throw new IllegalArgumentException(String.format("Timestamp is not valid. See proto definition for valid values. Seconds (%s) must be in range [-62,135,596,800, +253,402,300,799]. Nanos (%s) must be in range [0, +999,999,999].", seconds, nanos));
        }
        return timestamp;
    }

    public static Timestamp checkValid(Timestamp.Builder timestampBuilder) {
        return Timestamps.checkValid(timestampBuilder.build());
    }

    public static String toString(Timestamp timestamp) {
        Timestamps.checkValid(timestamp);
        long seconds = timestamp.getSeconds();
        int nanos = timestamp.getNanos();
        StringBuilder result2 = new StringBuilder();
        Date date = new Date(seconds * 1000L);
        result2.append(timestampFormat.get().format(date));
        if (nanos != 0) {
            result2.append(".");
            result2.append(Timestamps.formatNanos(nanos));
        }
        result2.append("Z");
        return result2.toString();
    }

    public static Timestamp parse(String value2) throws ParseException {
        int nanos;
        String timeValue;
        int dayOffset = value2.indexOf(84);
        if (dayOffset == -1) {
            throw new ParseException("Failed to parse timestamp: invalid timestamp \"" + value2 + "\"", 0);
        }
        int timezoneOffsetPosition = value2.indexOf(90, dayOffset);
        if (timezoneOffsetPosition == -1) {
            timezoneOffsetPosition = value2.indexOf(43, dayOffset);
        }
        if (timezoneOffsetPosition == -1) {
            timezoneOffsetPosition = value2.indexOf(45, dayOffset);
        }
        if (timezoneOffsetPosition == -1) {
            throw new ParseException("Failed to parse timestamp: missing valid timezone offset.", 0);
        }
        String secondValue = timeValue = value2.substring(0, timezoneOffsetPosition);
        String nanoValue = "";
        int pointPosition = timeValue.indexOf(46);
        if (pointPosition != -1) {
            secondValue = timeValue.substring(0, pointPosition);
            nanoValue = timeValue.substring(pointPosition + 1);
        }
        Date date = timestampFormat.get().parse(secondValue);
        long seconds = date.getTime() / 1000L;
        int n = nanos = nanoValue.isEmpty() ? 0 : Timestamps.parseNanos(nanoValue);
        if (value2.charAt(timezoneOffsetPosition) == 'Z') {
            if (value2.length() != timezoneOffsetPosition + 1) {
                throw new ParseException("Failed to parse timestamp: invalid trailing data \"" + value2.substring(timezoneOffsetPosition) + "\"", 0);
            }
        } else {
            String offsetValue = value2.substring(timezoneOffsetPosition + 1);
            long offset2 = Timestamps.parseTimezoneOffset(offsetValue);
            seconds = value2.charAt(timezoneOffsetPosition) == '+' ? (seconds -= offset2) : (seconds += offset2);
        }
        try {
            return Timestamps.normalizedTimestamp(seconds, nanos);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Failed to parse timestamp: timestamp is out of range.", 0);
        }
    }

    public static Timestamp fromSeconds(long seconds) {
        return Timestamps.normalizedTimestamp(seconds, 0);
    }

    public static long toSeconds(Timestamp timestamp) {
        return Timestamps.checkValid(timestamp).getSeconds();
    }

    public static Timestamp fromMillis(long milliseconds) {
        return Timestamps.normalizedTimestamp(milliseconds / 1000L, (int)(milliseconds % 1000L * 1000000L));
    }

    public static long toMillis(Timestamp timestamp) {
        Timestamps.checkValid(timestamp);
        return LongMath.checkedAdd(LongMath.checkedMultiply(timestamp.getSeconds(), 1000L), (long)timestamp.getNanos() / 1000000L);
    }

    public static Timestamp fromMicros(long microseconds) {
        return Timestamps.normalizedTimestamp(microseconds / 1000000L, (int)(microseconds % 1000000L * 1000L));
    }

    public static long toMicros(Timestamp timestamp) {
        Timestamps.checkValid(timestamp);
        return LongMath.checkedAdd(LongMath.checkedMultiply(timestamp.getSeconds(), 1000000L), (long)timestamp.getNanos() / 1000L);
    }

    public static Timestamp fromNanos(long nanoseconds) {
        return Timestamps.normalizedTimestamp(nanoseconds / 1000000000L, (int)(nanoseconds % 1000000000L));
    }

    public static long toNanos(Timestamp timestamp) {
        Timestamps.checkValid(timestamp);
        return LongMath.checkedAdd(LongMath.checkedMultiply(timestamp.getSeconds(), 1000000000L), timestamp.getNanos());
    }

    public static Duration between(Timestamp from, Timestamp to) {
        Timestamps.checkValid(from);
        Timestamps.checkValid(to);
        return Durations.normalizedDuration(LongMath.checkedSubtract(to.getSeconds(), from.getSeconds()), IntMath.checkedSubtract(to.getNanos(), from.getNanos()));
    }

    public static Timestamp add(Timestamp start2, Duration length2) {
        Timestamps.checkValid(start2);
        Durations.checkValid(length2);
        return Timestamps.normalizedTimestamp(LongMath.checkedAdd(start2.getSeconds(), length2.getSeconds()), IntMath.checkedAdd(start2.getNanos(), length2.getNanos()));
    }

    public static Timestamp subtract(Timestamp start2, Duration length2) {
        Timestamps.checkValid(start2);
        Durations.checkValid(length2);
        return Timestamps.normalizedTimestamp(LongMath.checkedSubtract(start2.getSeconds(), length2.getSeconds()), IntMath.checkedSubtract(start2.getNanos(), length2.getNanos()));
    }

    static Timestamp normalizedTimestamp(long seconds, int nanos) {
        if ((long)nanos <= -1000000000L || (long)nanos >= 1000000000L) {
            seconds = LongMath.checkedAdd(seconds, (long)nanos / 1000000000L);
            nanos = (int)((long)nanos % 1000000000L);
        }
        if (nanos < 0) {
            nanos = (int)((long)nanos + 1000000000L);
            seconds = LongMath.checkedSubtract(seconds, 1L);
        }
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
        return Timestamps.checkValid(timestamp);
    }

    private static long parseTimezoneOffset(String value2) throws ParseException {
        int pos2 = value2.indexOf(58);
        if (pos2 == -1) {
            throw new ParseException("Invalid offset value: " + value2, 0);
        }
        String hours = value2.substring(0, pos2);
        String minutes = value2.substring(pos2 + 1);
        return (Long.parseLong(hours) * 60L + Long.parseLong(minutes)) * 60L;
    }

    static int parseNanos(String value2) throws ParseException {
        int result2 = 0;
        for (int i2 = 0; i2 < 9; ++i2) {
            result2 *= 10;
            if (i2 >= value2.length()) continue;
            if (value2.charAt(i2) < '0' || value2.charAt(i2) > '9') {
                throw new ParseException("Invalid nanoseconds.", 0);
            }
            result2 += value2.charAt(i2) - 48;
        }
        return result2;
    }

    static String formatNanos(int nanos) {
        if ((long)nanos % 1000000L == 0L) {
            return String.format(Locale.ENGLISH, "%1$03d", (long)nanos / 1000000L);
        }
        if ((long)nanos % 1000L == 0L) {
            return String.format(Locale.ENGLISH, "%1$06d", (long)nanos / 1000L);
        }
        return String.format(Locale.ENGLISH, "%1$09d", nanos);
    }

    private static enum TimestampComparator implements Comparator<Timestamp>,
    Serializable
    {
        INSTANCE;


        @Override
        public int compare(Timestamp t1, Timestamp t2) {
            Timestamps.checkValid(t1);
            Timestamps.checkValid(t2);
            int secDiff = Long.compare(t1.getSeconds(), t2.getSeconds());
            return secDiff != 0 ? secDiff : Integer.compare(t1.getNanos(), t2.getNanos());
        }
    }
}

