/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.dns;

import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.AbstractDnsRecord;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsMessageUtil;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsPtrRecord;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsRecordType;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;

public class DefaultDnsPtrRecord
extends AbstractDnsRecord
implements DnsPtrRecord {
    private final String hostname;

    public DefaultDnsPtrRecord(String name2, int dnsClass, long timeToLive, String hostname) {
        super(name2, DnsRecordType.PTR, dnsClass, timeToLive);
        this.hostname = ObjectUtil.checkNotNull(hostname, "hostname");
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64).append(StringUtil.simpleClassName(this)).append('(');
        DnsRecordType type2 = this.type();
        buf.append(this.name().isEmpty() ? "<root>" : this.name()).append(' ').append(this.timeToLive()).append(' ');
        DnsMessageUtil.appendRecordClass(buf, this.dnsClass()).append(' ').append(type2.name());
        buf.append(' ').append(this.hostname);
        return buf.toString();
    }
}

