/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.http.cookie;

import org.apache.hbase.thirdparty.io.netty.handler.codec.http.cookie.CookieUtil;

public abstract class CookieEncoder {
    protected final boolean strict;

    protected CookieEncoder(boolean strict) {
        this.strict = strict;
    }

    protected void validateCookie(String name2, String value2) {
        if (this.strict) {
            int pos2 = CookieUtil.firstInvalidCookieNameOctet(name2);
            if (pos2 >= 0) {
                throw new IllegalArgumentException("Cookie name contains an invalid char: " + name2.charAt(pos2));
            }
            CharSequence unwrappedValue = CookieUtil.unwrapValue(value2);
            if (unwrappedValue == null) {
                throw new IllegalArgumentException("Cookie value wrapping quotes are not balanced: " + value2);
            }
            pos2 = CookieUtil.firstInvalidCookieValueOctet(unwrappedValue);
            if (pos2 >= 0) {
                throw new IllegalArgumentException("Cookie value contains an invalid char: " + unwrappedValue.charAt(pos2));
            }
        }
    }
}

