/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.CompositeByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.HttpConstants;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.multipart.AbstractHttpData;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.multipart.HttpData;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;

public abstract class AbstractMemoryHttpData
extends AbstractHttpData {
    private ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
    private int chunkPosition;

    protected AbstractMemoryHttpData(String name2, Charset charset, long size2) {
        super(name2, charset, size2);
    }

    @Override
    public void setContent(ByteBuf buffer) throws IOException {
        ObjectUtil.checkNotNull(buffer, "buffer");
        long localsize = buffer.readableBytes();
        this.checkSize(localsize);
        if (this.definedSize > 0L && this.definedSize < localsize) {
            throw new IOException("Out of size: " + localsize + " > " + this.definedSize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = buffer;
        this.size = localsize;
        this.setCompleted();
    }

    @Override
    public void setContent(InputStream inputStream) throws IOException {
        ObjectUtil.checkNotNull(inputStream, "inputStream");
        byte[] bytes2 = new byte[16384];
        ByteBuf buffer = Unpooled.buffer();
        int written = 0;
        try {
            int read2 = inputStream.read(bytes2);
            while (read2 > 0) {
                buffer.writeBytes(bytes2, 0, read2);
                this.checkSize(written += read2);
                read2 = inputStream.read(bytes2);
            }
        }
        catch (IOException e) {
            buffer.release();
            throw e;
        }
        this.size = written;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            buffer.release();
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = buffer;
        this.setCompleted();
    }

    @Override
    public void addContent(ByteBuf buffer, boolean last2) throws IOException {
        if (buffer != null) {
            long localsize = buffer.readableBytes();
            this.checkSize(this.size + localsize);
            if (this.definedSize > 0L && this.definedSize < this.size + localsize) {
                throw new IOException("Out of size: " + (this.size + localsize) + " > " + this.definedSize);
            }
            this.size += localsize;
            if (this.byteBuf == null) {
                this.byteBuf = buffer;
            } else if (localsize == 0L) {
                buffer.release();
            } else if (this.byteBuf.readableBytes() == 0) {
                this.byteBuf.release();
                this.byteBuf = buffer;
            } else if (this.byteBuf instanceof CompositeByteBuf) {
                CompositeByteBuf cbb = (CompositeByteBuf)this.byteBuf;
                cbb.addComponent(true, buffer);
            } else {
                CompositeByteBuf cbb = Unpooled.compositeBuffer(Integer.MAX_VALUE);
                cbb.addComponents(true, this.byteBuf, buffer);
                this.byteBuf = cbb;
            }
        }
        if (last2) {
            this.setCompleted();
        } else {
            ObjectUtil.checkNotNull(buffer, "buffer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(File file2) throws IOException {
        ByteBuffer byteBuffer;
        ObjectUtil.checkNotNull(file2, "file");
        long newsize = file2.length();
        if (newsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        this.checkSize(newsize);
        RandomAccessFile accessFile = new RandomAccessFile(file2, "r");
        try {
            FileChannel fileChannel = accessFile.getChannel();
            try {
                byte[] array = new byte[(int)newsize];
                byteBuffer = ByteBuffer.wrap(array);
                int read2 = 0;
                while ((long)read2 < newsize) {
                    read2 += fileChannel.read(byteBuffer);
                }
            }
            finally {
                fileChannel.close();
            }
        }
        finally {
            accessFile.close();
        }
        byteBuffer.flip();
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = Unpooled.wrappedBuffer(Integer.MAX_VALUE, byteBuffer);
        this.size = newsize;
        this.setCompleted();
    }

    @Override
    public void delete() {
        if (this.byteBuf != null) {
            this.byteBuf.release();
            this.byteBuf = null;
        }
    }

    @Override
    public byte[] get() {
        if (this.byteBuf == null) {
            return Unpooled.EMPTY_BUFFER.array();
        }
        byte[] array = new byte[this.byteBuf.readableBytes()];
        this.byteBuf.getBytes(this.byteBuf.readerIndex(), array);
        return array;
    }

    @Override
    public String getString() {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    @Override
    public String getString(Charset encoding2) {
        if (this.byteBuf == null) {
            return "";
        }
        if (encoding2 == null) {
            encoding2 = HttpConstants.DEFAULT_CHARSET;
        }
        return this.byteBuf.toString(encoding2);
    }

    @Override
    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    @Override
    public ByteBuf getChunk(int length2) throws IOException {
        if (this.byteBuf == null || length2 == 0 || this.byteBuf.readableBytes() == 0) {
            this.chunkPosition = 0;
            return Unpooled.EMPTY_BUFFER;
        }
        int sizeLeft = this.byteBuf.readableBytes() - this.chunkPosition;
        if (sizeLeft == 0) {
            this.chunkPosition = 0;
            return Unpooled.EMPTY_BUFFER;
        }
        int sliceLength = length2;
        if (sizeLeft < length2) {
            sliceLength = sizeLeft;
        }
        ByteBuf chunk2 = this.byteBuf.retainedSlice(this.chunkPosition, sliceLength);
        this.chunkPosition += sliceLength;
        return chunk2;
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameTo(File dest) throws IOException {
        long written;
        ObjectUtil.checkNotNull(dest, "dest");
        if (this.byteBuf == null) {
            if (!dest.createNewFile()) {
                throw new IOException("file exists already: " + dest);
            }
            return true;
        }
        int length2 = this.byteBuf.readableBytes();
        RandomAccessFile accessFile = new RandomAccessFile(dest, "rw");
        try {
            FileChannel fileChannel = accessFile.getChannel();
            try {
                if (this.byteBuf.nioBufferCount() == 1) {
                    ByteBuffer byteBuffer = this.byteBuf.nioBuffer();
                    for (written = 0L; written < (long)length2; written += (long)fileChannel.write(byteBuffer)) {
                    }
                } else {
                    ByteBuffer[] byteBuffers = this.byteBuf.nioBuffers();
                    while (written < (long)length2) {
                        written += fileChannel.write(byteBuffers);
                    }
                }
                fileChannel.force(false);
            }
            finally {
                fileChannel.close();
            }
        }
        finally {
            accessFile.close();
        }
        return written == (long)length2;
    }

    @Override
    public File getFile() throws IOException {
        throw new IOException("Not represented by a file");
    }

    @Override
    public HttpData touch() {
        return this.touch(null);
    }

    @Override
    public HttpData touch(Object hint) {
        if (this.byteBuf != null) {
            this.byteBuf.touch(hint);
        }
        return this;
    }
}

