/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.ssl;

import javax.net.ssl.SSLException;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.handler.codec.DecoderException;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslHandler;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLogger;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class ApplicationProtocolNegotiationHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ApplicationProtocolNegotiationHandler.class);
    private final String fallbackProtocol;

    protected ApplicationProtocolNegotiationHandler(String fallbackProtocol) {
        this.fallbackProtocol = ObjectUtil.checkNotNull(fallbackProtocol, "fallbackProtocol");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
            try {
                if (handshakeEvent.isSuccess()) {
                    SslHandler sslHandler = ctx.pipeline().get(SslHandler.class);
                    if (sslHandler == null) {
                        throw new IllegalStateException("cannot find an SslHandler in the pipeline (required for application-level protocol negotiation)");
                    }
                    String protocol = sslHandler.applicationProtocol();
                    this.configurePipeline(ctx, protocol != null ? protocol : this.fallbackProtocol);
                }
            }
            catch (Throwable cause2) {
                this.exceptionCaught(ctx, cause2);
            }
            finally {
                if (handshakeEvent.isSuccess()) {
                    this.removeSelfIfPresent(ctx);
                }
            }
        }
        ctx.fireUserEventTriggered(evt);
    }

    private void removeSelfIfPresent(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        if (pipeline.context(this) != null) {
            pipeline.remove(this);
        }
    }

    protected abstract void configurePipeline(ChannelHandlerContext var1, String var2) throws Exception;

    protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause2) throws Exception {
        logger.warn("{} TLS handshake failed:", (Object)ctx.channel(), (Object)cause2);
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause2) throws Exception {
        Throwable wrapped;
        if (cause2 instanceof DecoderException && (wrapped = cause2.getCause()) instanceof SSLException) {
            try {
                this.handshakeFailure(ctx, wrapped);
                return;
            }
            finally {
                this.removeSelfIfPresent(ctx);
            }
        }
        logger.warn("{} Failed to select the application-level protocol:", (Object)ctx.channel(), (Object)cause2);
        ctx.fireExceptionCaught(cause2);
        ctx.close();
    }
}

