/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.util.internal;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hbase.thirdparty.io.netty.util.NetUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.EmptyArrays;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;
import org.apache.hbase.thirdparty.io.netty.util.internal.SocketUtils;
import org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLogger;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLoggerFactory;

public final class MacAddressUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MacAddressUtil.class);
    private static final int EUI64_MAC_ADDRESS_LENGTH = 8;
    private static final int EUI48_MAC_ADDRESS_LENGTH = 6;

    public static byte[] bestAvailableMac() {
        byte[] bestMacAddr = EmptyArrays.EMPTY_BYTES;
        InetAddress bestInetAddr = NetUtil.LOCALHOST4;
        LinkedHashMap<NetworkInterface, InetAddress> ifaces = new LinkedHashMap<NetworkInterface, InetAddress>();
        try {
            Enumeration<NetworkInterface> interfaces2 = NetworkInterface.getNetworkInterfaces();
            if (interfaces2 != null) {
                while (interfaces2.hasMoreElements()) {
                    InetAddress a;
                    NetworkInterface iface = interfaces2.nextElement();
                    Enumeration<InetAddress> addrs = SocketUtils.addressesFromNetworkInterface(iface);
                    if (!addrs.hasMoreElements() || (a = addrs.nextElement()).isLoopbackAddress()) continue;
                    ifaces.put(iface, a);
                }
            }
        }
        catch (SocketException e) {
            logger.warn("Failed to retrieve the list of available network interfaces", e);
        }
        for (Map.Entry entry : ifaces.entrySet()) {
            byte[] macAddr;
            NetworkInterface iface = (NetworkInterface)entry.getKey();
            InetAddress inetAddr = (InetAddress)entry.getValue();
            if (iface.isVirtual()) continue;
            try {
                macAddr = SocketUtils.hardwareAddressFromNetworkInterface(iface);
            }
            catch (SocketException e) {
                logger.debug("Failed to get the hardware address of a network interface: {}", (Object)iface, (Object)e);
                continue;
            }
            boolean replace2 = false;
            int res = MacAddressUtil.compareAddresses(bestMacAddr, macAddr);
            if (res < 0) {
                replace2 = true;
            } else if (res == 0) {
                res = MacAddressUtil.compareAddresses(bestInetAddr, inetAddr);
                if (res < 0) {
                    replace2 = true;
                } else if (res == 0 && bestMacAddr.length < macAddr.length) {
                    replace2 = true;
                }
            }
            if (!replace2) continue;
            bestMacAddr = macAddr;
            bestInetAddr = inetAddr;
        }
        if (bestMacAddr == EmptyArrays.EMPTY_BYTES) {
            return null;
        }
        switch (bestMacAddr.length) {
            case 6: {
                byte[] newAddr = new byte[8];
                System.arraycopy(bestMacAddr, 0, newAddr, 0, 3);
                newAddr[3] = -1;
                newAddr[4] = -2;
                System.arraycopy(bestMacAddr, 3, newAddr, 5, 3);
                bestMacAddr = newAddr;
                break;
            }
            default: {
                bestMacAddr = Arrays.copyOf(bestMacAddr, 8);
            }
        }
        return bestMacAddr;
    }

    public static byte[] defaultMachineId() {
        byte[] bestMacAddr = MacAddressUtil.bestAvailableMac();
        if (bestMacAddr == null) {
            bestMacAddr = new byte[8];
            PlatformDependent.threadLocalRandom().nextBytes(bestMacAddr);
            logger.warn("Failed to find a usable hardware address from the network interfaces; using random bytes: {}", (Object)MacAddressUtil.formatAddress(bestMacAddr));
        }
        return bestMacAddr;
    }

    public static byte[] parseMAC(String value2) {
        byte[] machineId;
        char separator;
        switch (value2.length()) {
            case 17: {
                separator = value2.charAt(2);
                MacAddressUtil.validateMacSeparator(separator);
                machineId = new byte[6];
                break;
            }
            case 23: {
                separator = value2.charAt(2);
                MacAddressUtil.validateMacSeparator(separator);
                machineId = new byte[8];
                break;
            }
            default: {
                throw new IllegalArgumentException("value is not supported [MAC-48, EUI-48, EUI-64]");
            }
        }
        int end2 = machineId.length - 1;
        int j = 0;
        int i2 = 0;
        while (i2 < end2) {
            int sIndex = j + 2;
            machineId[i2] = StringUtil.decodeHexByte(value2, j);
            if (value2.charAt(sIndex) != separator) {
                throw new IllegalArgumentException("expected separator '" + separator + " but got '" + value2.charAt(sIndex) + "' at index: " + sIndex);
            }
            ++i2;
            j += 3;
        }
        machineId[end2] = StringUtil.decodeHexByte(value2, j);
        return machineId;
    }

    private static void validateMacSeparator(char separator) {
        if (separator != ':' && separator != '-') {
            throw new IllegalArgumentException("unsupported separator: " + separator + " (expected: [:-])");
        }
    }

    public static String formatAddress(byte[] addr2) {
        StringBuilder buf = new StringBuilder(24);
        for (byte b : addr2) {
            buf.append(String.format("%02x:", b & 0xFF));
        }
        return buf.substring(0, buf.length() - 1);
    }

    static int compareAddresses(byte[] current2, byte[] candidate) {
        if (candidate == null || candidate.length < 6) {
            return 1;
        }
        boolean onlyZeroAndOne = true;
        for (byte b : candidate) {
            if (b == 0 || b == 1) continue;
            onlyZeroAndOne = false;
            break;
        }
        if (onlyZeroAndOne) {
            return 1;
        }
        if ((candidate[0] & 1) != 0) {
            return 1;
        }
        if ((candidate[0] & 2) == 0) {
            if (current2.length != 0 && (current2[0] & 2) == 0) {
                return 0;
            }
            return -1;
        }
        if (current2.length != 0 && (current2[0] & 2) == 0) {
            return 1;
        }
        return 0;
    }

    private static int compareAddresses(InetAddress current2, InetAddress candidate) {
        return MacAddressUtil.scoreAddress(current2) - MacAddressUtil.scoreAddress(candidate);
    }

    private static int scoreAddress(InetAddress addr2) {
        if (addr2.isAnyLocalAddress() || addr2.isLoopbackAddress()) {
            return 0;
        }
        if (addr2.isMulticastAddress()) {
            return 1;
        }
        if (addr2.isLinkLocalAddress()) {
            return 2;
        }
        if (addr2.isSiteLocalAddress()) {
            return 3;
        }
        return 4;
    }

    private MacAddressUtil() {
    }
}

