/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.util.internal;

import java.util.Collection;
import java.util.Map;

public final class ObjectUtil {
    private static final float FLOAT_ZERO = 0.0f;
    private static final double DOUBLE_ZERO = 0.0;
    private static final long LONG_ZERO = 0L;
    private static final int INT_ZERO = 0;

    private ObjectUtil() {
    }

    public static <T> T checkNotNull(T arg2, String text) {
        if (arg2 == null) {
            throw new NullPointerException(text);
        }
        return arg2;
    }

    public static <T> T checkNotNullWithIAE(T arg2, String paramName) throws IllegalArgumentException {
        if (arg2 == null) {
            throw new IllegalArgumentException("Param '" + paramName + "' must not be null");
        }
        return arg2;
    }

    public static <T> T checkNotNullArrayParam(T value2, int index2, String name2) throws IllegalArgumentException {
        if (value2 == null) {
            throw new IllegalArgumentException("Array index " + index2 + " of parameter '" + name2 + "' must not be null");
        }
        return value2;
    }

    public static int checkPositive(int i2, String name2) {
        if (i2 <= 0) {
            throw new IllegalArgumentException(name2 + " : " + i2 + " (expected: > 0)");
        }
        return i2;
    }

    public static long checkPositive(long l, String name2) {
        if (l <= 0L) {
            throw new IllegalArgumentException(name2 + " : " + l + " (expected: > 0)");
        }
        return l;
    }

    public static double checkPositive(double d, String name2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(name2 + " : " + d + " (expected: > 0)");
        }
        return d;
    }

    public static float checkPositive(float f, String name2) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException(name2 + " : " + f + " (expected: > 0)");
        }
        return f;
    }

    public static int checkPositiveOrZero(int i2, String name2) {
        if (i2 < 0) {
            throw new IllegalArgumentException(name2 + " : " + i2 + " (expected: >= 0)");
        }
        return i2;
    }

    public static long checkPositiveOrZero(long l, String name2) {
        if (l < 0L) {
            throw new IllegalArgumentException(name2 + " : " + l + " (expected: >= 0)");
        }
        return l;
    }

    public static double checkPositiveOrZero(double d, String name2) {
        if (d < 0.0) {
            throw new IllegalArgumentException(name2 + " : " + d + " (expected: >= 0)");
        }
        return d;
    }

    public static float checkPositiveOrZero(float f, String name2) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(name2 + " : " + f + " (expected: >= 0)");
        }
        return f;
    }

    public static int checkInRange(int i2, int start2, int end2, String name2) {
        if (i2 < start2 || i2 > end2) {
            throw new IllegalArgumentException(name2 + ": " + i2 + " (expected: " + start2 + "-" + end2 + ")");
        }
        return i2;
    }

    public static long checkInRange(long l, long start2, long end2, String name2) {
        if (l < start2 || l > end2) {
            throw new IllegalArgumentException(name2 + ": " + l + " (expected: " + start2 + "-" + end2 + ")");
        }
        return l;
    }

    public static <T> T[] checkNonEmpty(T[] array, String name2) {
        if (ObjectUtil.checkNotNull(array, name2).length == 0) {
            throw new IllegalArgumentException("Param '" + name2 + "' must not be empty");
        }
        return array;
    }

    public static byte[] checkNonEmpty(byte[] array, String name2) {
        if (ObjectUtil.checkNotNull(array, name2).length == 0) {
            throw new IllegalArgumentException("Param '" + name2 + "' must not be empty");
        }
        return array;
    }

    public static char[] checkNonEmpty(char[] array, String name2) {
        if (ObjectUtil.checkNotNull(array, name2).length == 0) {
            throw new IllegalArgumentException("Param '" + name2 + "' must not be empty");
        }
        return array;
    }

    public static <T extends Collection<?>> T checkNonEmpty(T collection, String name2) {
        if (ObjectUtil.checkNotNull(collection, name2).size() == 0) {
            throw new IllegalArgumentException("Param '" + name2 + "' must not be empty");
        }
        return collection;
    }

    public static String checkNonEmpty(String value2, String name2) {
        if (ObjectUtil.checkNotNull(value2, name2).isEmpty()) {
            throw new IllegalArgumentException("Param '" + name2 + "' must not be empty");
        }
        return value2;
    }

    public static <K, V, T extends Map<K, V>> T checkNonEmpty(T value2, String name2) {
        if (ObjectUtil.checkNotNull(value2, name2).isEmpty()) {
            throw new IllegalArgumentException("Param '" + name2 + "' must not be empty");
        }
        return value2;
    }

    public static CharSequence checkNonEmpty(CharSequence value2, String name2) {
        if (ObjectUtil.checkNotNull(value2, name2).length() == 0) {
            throw new IllegalArgumentException("Param '" + name2 + "' must not be empty");
        }
        return value2;
    }

    public static String checkNonEmptyAfterTrim(String value2, String name2) {
        String trimmed = ObjectUtil.checkNotNull(value2, name2).trim();
        return ObjectUtil.checkNonEmpty(trimmed, name2);
    }

    public static int intValue(Integer wrapper, int defaultValue) {
        return wrapper != null ? wrapper : defaultValue;
    }

    public static long longValue(Long wrapper, long defaultValue) {
        return wrapper != null ? wrapper : defaultValue;
    }
}

