/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.htrace.shaded.fasterxml.jackson.annotation.ObjectIdGenerator;
import org.apache.htrace.shaded.fasterxml.jackson.annotation.ObjectIdResolver;
import org.apache.htrace.shaded.fasterxml.jackson.core.Base64Variant;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonParser;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonProcessingException;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonToken;
import org.apache.htrace.shaded.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.htrace.shaded.fasterxml.jackson.databind.BeanProperty;
import org.apache.htrace.shaded.fasterxml.jackson.databind.DatabindContext;
import org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.htrace.shaded.fasterxml.jackson.databind.InjectableValues;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.apache.htrace.shaded.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.cfg.ContextAttributes;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.DeserializerCache;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.DeserializerFactory;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.impl.TypeWrappedDeserializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.exc.InvalidFormatException;
import org.apache.htrace.shaded.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.Annotated;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.htrace.shaded.fasterxml.jackson.databind.util.ArrayBuilders;
import org.apache.htrace.shaded.fasterxml.jackson.databind.util.ClassUtil;
import org.apache.htrace.shaded.fasterxml.jackson.databind.util.LinkedNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.util.ObjectBuffer;

public abstract class DeserializationContext
extends DatabindContext
implements Serializable {
    private static final long serialVersionUID = -4290063686213707727L;
    private static final int MAX_ERROR_STR_LEN = 500;
    protected final DeserializerCache _cache;
    protected final DeserializerFactory _factory;
    protected final DeserializationConfig _config;
    protected final int _featureFlags;
    protected final Class<?> _view;
    protected transient JsonParser _parser;
    protected final InjectableValues _injectableValues;
    protected transient ArrayBuilders _arrayBuilders;
    protected transient ObjectBuffer _objectBuffer;
    protected transient DateFormat _dateFormat;
    protected transient ContextAttributes _attributes;

    protected DeserializationContext(DeserializerFactory df) {
        this(df, null);
    }

    protected DeserializationContext(DeserializerFactory df, DeserializerCache cache) {
        if (df == null) {
            throw new IllegalArgumentException("Can not pass null DeserializerFactory");
        }
        this._factory = df;
        this._cache = cache == null ? new DeserializerCache() : cache;
        this._featureFlags = 0;
        this._config = null;
        this._injectableValues = null;
        this._view = null;
        this._attributes = null;
    }

    protected DeserializationContext(DeserializationContext src, DeserializerFactory factory) {
        this._cache = src._cache;
        this._factory = factory;
        this._config = src._config;
        this._featureFlags = src._featureFlags;
        this._view = src._view;
        this._parser = src._parser;
        this._injectableValues = src._injectableValues;
        this._attributes = src._attributes;
    }

    protected DeserializationContext(DeserializationContext src, DeserializationConfig config, JsonParser p2, InjectableValues injectableValues) {
        this._cache = src._cache;
        this._factory = src._factory;
        this._config = config;
        this._featureFlags = config.getDeserializationFeatures();
        this._view = config.getActiveView();
        this._parser = p2;
        this._injectableValues = injectableValues;
        this._attributes = config.getAttributes();
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._view;
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public Object getAttribute(Object key2) {
        return this._attributes.getAttribute(key2);
    }

    @Override
    public DeserializationContext setAttribute(Object key2, Object value2) {
        this._attributes = this._attributes.withPerCallAttribute(key2, value2);
        return this;
    }

    public DeserializerFactory getFactory() {
        return this._factory;
    }

    public final boolean isEnabled(DeserializationFeature feat) {
        return (this._featureFlags & feat.getMask()) != 0;
    }

    public final boolean hasDeserializationFeatures(int featureMask) {
        return this._config.hasDeserializationFeatures(featureMask);
    }

    public final JsonParser getParser() {
        return this._parser;
    }

    public final Object findInjectableValue(Object valueId, BeanProperty forProperty, Object beanInstance) {
        if (this._injectableValues == null) {
            throw new IllegalStateException("No 'injectableValues' configured, can not inject value with id [" + valueId + "]");
        }
        return this._injectableValues.findInjectableValue(valueId, this, forProperty, beanInstance);
    }

    public final Base64Variant getBase64Variant() {
        return this._config.getBase64Variant();
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._config.getNodeFactory();
    }

    public Locale getLocale() {
        return this._config.getLocale();
    }

    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    @Deprecated
    public boolean hasValueDeserializerFor(JavaType type2) {
        return this.hasValueDeserializerFor(type2, null);
    }

    public boolean hasValueDeserializerFor(JavaType type2, AtomicReference<Throwable> cause2) {
        try {
            return this._cache.hasValueDeserializerFor(this, this._factory, type2);
        }
        catch (JsonMappingException e) {
            if (cause2 != null) {
                cause2.set(e);
            }
        }
        catch (RuntimeException e) {
            if (cause2 == null) {
                throw e;
            }
            cause2.set(e);
        }
        return false;
    }

    public final JsonDeserializer<Object> findContextualValueDeserializer(JavaType type2, BeanProperty prop) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._cache.findValueDeserializer(this, this._factory, type2);
        if (deser != null) {
            deser = this.handleSecondaryContextualization(deser, prop);
        }
        return deser;
    }

    public final JsonDeserializer<Object> findRootValueDeserializer(JavaType type2) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._cache.findValueDeserializer(this, this._factory, type2);
        if (deser == null) {
            return null;
        }
        deser = this.handleSecondaryContextualization(deser, null);
        TypeDeserializer typeDeser = this._factory.findTypeDeserializer(this._config, type2);
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(null);
            return new TypeWrappedDeserializer(typeDeser, deser);
        }
        return deser;
    }

    public final KeyDeserializer findKeyDeserializer(JavaType keyType, BeanProperty prop) throws JsonMappingException {
        KeyDeserializer kd = this._cache.findKeyDeserializer(this, this._factory, keyType);
        if (kd instanceof ContextualKeyDeserializer) {
            kd = ((ContextualKeyDeserializer)((Object)kd)).createContextual(this, prop);
        }
        return kd;
    }

    public abstract ReadableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2, ObjectIdResolver var3);

    @Deprecated
    public abstract ReadableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2);

    public abstract void checkUnresolvedObjectId() throws UnresolvedForwardReference;

    public final JavaType constructType(Class<?> cls) {
        return this._config.constructType(cls);
    }

    public Class<?> findClass(String className) throws ClassNotFoundException {
        return ClassUtil.findClass(className);
    }

    public final ObjectBuffer leaseObjectBuffer() {
        ObjectBuffer buf = this._objectBuffer;
        if (buf == null) {
            buf = new ObjectBuffer();
        } else {
            this._objectBuffer = null;
        }
        return buf;
    }

    public final void returnObjectBuffer(ObjectBuffer buf) {
        if (this._objectBuffer == null || buf.initialCapacity() >= this._objectBuffer.initialCapacity()) {
            this._objectBuffer = buf;
        }
    }

    public final ArrayBuilders getArrayBuilders() {
        if (this._arrayBuilders == null) {
            this._arrayBuilders = new ArrayBuilders();
        }
        return this._arrayBuilders;
    }

    public abstract JsonDeserializer<Object> deserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public abstract KeyDeserializer keyDeserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public JsonDeserializer<?> handlePrimaryContextualization(JsonDeserializer<?> deser, BeanProperty prop) throws JsonMappingException {
        if (deser != null && deser instanceof ContextualDeserializer) {
            deser = ((ContextualDeserializer)((Object)deser)).createContextual(this, prop);
        }
        return deser;
    }

    public JsonDeserializer<?> handleSecondaryContextualization(JsonDeserializer<?> deser, BeanProperty prop) throws JsonMappingException {
        if (deser != null && deser instanceof ContextualDeserializer) {
            deser = ((ContextualDeserializer)((Object)deser)).createContextual(this, prop);
        }
        return deser;
    }

    public Date parseDate(String dateStr) throws IllegalArgumentException {
        try {
            DateFormat df = this.getDateFormat();
            return df.parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse Date value '" + dateStr + "': " + e.getMessage());
        }
    }

    public Calendar constructCalendar(Date d) {
        Calendar c = Calendar.getInstance(this.getTimeZone());
        c.setTime(d);
        return c;
    }

    public <T> T readValue(JsonParser p2, Class<T> type2) throws IOException {
        return this.readValue(p2, this.getTypeFactory().constructType(type2));
    }

    public <T> T readValue(JsonParser p2, JavaType type2) throws IOException {
        JsonDeserializer<Object> deser = this.findRootValueDeserializer(type2);
        if (deser == null) {
            // empty if block
        }
        return (T)deser.deserialize(p2, this);
    }

    public <T> T readPropertyValue(JsonParser p2, BeanProperty prop, Class<T> type2) throws IOException {
        return this.readPropertyValue(p2, prop, this.getTypeFactory().constructType(type2));
    }

    public <T> T readPropertyValue(JsonParser p2, BeanProperty prop, JavaType type2) throws IOException {
        JsonDeserializer<Object> deser = this.findContextualValueDeserializer(type2, prop);
        if (deser == null) {
            // empty if block
        }
        return (T)deser.deserialize(p2, this);
    }

    public boolean handleUnknownProperty(JsonParser p2, JsonDeserializer<?> deser, Object instanceOrClass, String propName) throws IOException, JsonProcessingException {
        LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers();
        if (h != null) {
            while (h != null) {
                if (h.value().handleUnknownProperty(this, p2, deser, instanceOrClass, propName)) {
                    return true;
                }
                h = h.next();
            }
        }
        return false;
    }

    public void reportUnknownProperty(Object instanceOrClass, String fieldName, JsonDeserializer<?> deser) throws JsonMappingException {
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            return;
        }
        Collection<Object> propIds = deser == null ? null : deser.getKnownPropertyNames();
        throw UnrecognizedPropertyException.from(this._parser, instanceOrClass, fieldName, propIds);
    }

    public JsonMappingException mappingException(Class<?> targetClass) {
        return this.mappingException(targetClass, this._parser.getCurrentToken());
    }

    public JsonMappingException mappingException(Class<?> targetClass, JsonToken token) {
        return JsonMappingException.from(this._parser, "Can not deserialize instance of " + this._calcName(targetClass) + " out of " + (Object)((Object)token) + " token");
    }

    public JsonMappingException mappingException(String message2) {
        return JsonMappingException.from(this.getParser(), message2);
    }

    public JsonMappingException instantiationException(Class<?> instClass, Throwable t) {
        return JsonMappingException.from(this._parser, "Can not construct instance of " + instClass.getName() + ", problem: " + t.getMessage(), t);
    }

    public JsonMappingException instantiationException(Class<?> instClass, String msg) {
        return JsonMappingException.from(this._parser, "Can not construct instance of " + instClass.getName() + ", problem: " + msg);
    }

    @Deprecated
    public JsonMappingException weirdStringException(Class<?> instClass, String msg) {
        return this.weirdStringException(null, instClass, msg);
    }

    public JsonMappingException weirdStringException(String value2, Class<?> instClass, String msg) {
        return InvalidFormatException.from(this._parser, "Can not construct instance of " + instClass.getName() + " from String value '" + this._valueDesc() + "': " + msg, value2, instClass);
    }

    @Deprecated
    public JsonMappingException weirdNumberException(Class<?> instClass, String msg) {
        return this.weirdStringException(null, instClass, msg);
    }

    public JsonMappingException weirdNumberException(Number value2, Class<?> instClass, String msg) {
        return InvalidFormatException.from(this._parser, "Can not construct instance of " + instClass.getName() + " from number value (" + this._valueDesc() + "): " + msg, null, instClass);
    }

    public JsonMappingException weirdKeyException(Class<?> keyClass, String keyValue, String msg) {
        return InvalidFormatException.from(this._parser, "Can not construct Map key of type " + keyClass.getName() + " from String \"" + this._desc(keyValue) + "\": " + msg, keyValue, keyClass);
    }

    public JsonMappingException wrongTokenException(JsonParser p2, JsonToken expToken, String msg0) {
        String msg = "Unexpected token (" + (Object)((Object)p2.getCurrentToken()) + "), expected " + (Object)((Object)expToken);
        if (msg0 != null) {
            msg = msg + ": " + msg0;
        }
        return JsonMappingException.from(p2, msg);
    }

    public JsonMappingException unknownTypeException(JavaType type2, String id2) {
        return JsonMappingException.from(this._parser, "Could not resolve type id '" + id2 + "' into a subtype of " + type2);
    }

    public JsonMappingException endOfInputException(Class<?> instClass) {
        return JsonMappingException.from(this._parser, "Unexpected end-of-input when trying to deserialize a " + instClass.getName());
    }

    protected DateFormat getDateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat df = this._config.getDateFormat();
        this._dateFormat = df = (DateFormat)df.clone();
        return df;
    }

    protected String determineClassName(Object instance) {
        return ClassUtil.getClassDescription(instance);
    }

    protected String _calcName(Class<?> cls) {
        if (cls.isArray()) {
            return this._calcName(cls.getComponentType()) + "[]";
        }
        return cls.getName();
    }

    protected String _valueDesc() {
        try {
            return this._desc(this._parser.getText());
        }
        catch (Exception e) {
            return "[N/A]";
        }
    }

    protected String _desc(String desc) {
        if (desc.length() > 500) {
            desc = desc.substring(0, 500) + "]...[" + desc.substring(desc.length() - 500);
        }
        return desc;
    }
}

