/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.util;

public class DnsUtils {
    private DnsUtils() {
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static String normalize(String s2) {
        int remaining;
        if (s2 == null) {
            return null;
        }
        int pos2 = 0;
        for (remaining = s2.length(); remaining > 0 && !DnsUtils.isUpper(s2.charAt(pos2)); --remaining) {
            ++pos2;
        }
        if (remaining > 0) {
            StringBuilder buf = new StringBuilder(s2.length());
            buf.append(s2, 0, pos2);
            while (remaining > 0) {
                char c = s2.charAt(pos2);
                if (DnsUtils.isUpper(c)) {
                    buf.append((char)(c + 32));
                } else {
                    buf.append(c);
                }
                ++pos2;
                --remaining;
            }
            return buf.toString();
        }
        return s2;
    }
}

