/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ResourceBundle;
import org.apache.log4j.Level;
import org.apache.log4j.LogXF;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public final class LogSF
extends LogXF {
    private static final String FQCN = LogSF.class.getName();

    private LogSF() {
    }

    private static String format(String pattern, Object[] arguments) {
        if (pattern != null) {
            String retval = "";
            int count2 = 0;
            int prev = 0;
            int pos2 = pattern.indexOf("{");
            while (pos2 >= 0) {
                if (pos2 == 0 || pattern.charAt(pos2 - 1) != '\\') {
                    retval = retval + pattern.substring(prev, pos2);
                    if (pos2 + 1 < pattern.length() && pattern.charAt(pos2 + 1) == '}') {
                        retval = arguments != null && count2 < arguments.length ? retval + arguments[count2++] : retval + "{}";
                        prev = pos2 + 2;
                    } else {
                        retval = retval + "{";
                        prev = pos2 + 1;
                    }
                } else {
                    retval = retval + pattern.substring(prev, pos2 - 1) + "{";
                    prev = pos2 + 1;
                }
                pos2 = pattern.indexOf("{", prev);
            }
            return retval + pattern.substring(prev);
        }
        return null;
    }

    private static String format(String pattern, Object arg0) {
        if (pattern != null) {
            if (pattern.indexOf("\\{") >= 0) {
                return LogSF.format(pattern, new Object[]{arg0});
            }
            int pos2 = pattern.indexOf("{}");
            if (pos2 >= 0) {
                return pattern.substring(0, pos2) + arg0 + pattern.substring(pos2 + 2);
            }
        }
        return pattern;
    }

    private static String format(String resourceBundleName, String key2, Object[] arguments) {
        String pattern;
        if (resourceBundleName != null) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(resourceBundleName);
                pattern = bundle.getString(key2);
            }
            catch (Exception ex) {
                pattern = key2;
            }
        } else {
            pattern = key2;
        }
        return LogSF.format(pattern, arguments);
    }

    private static void forcedLog(Logger logger, Level level2, String msg) {
        logger.callAppenders(new LoggingEvent(FQCN, logger, level2, msg, null));
    }

    private static void forcedLog(Logger logger, Level level2, String msg, Throwable t) {
        logger.callAppenders(new LoggingEvent(FQCN, logger, level2, msg, t));
    }

    public static void trace(Logger logger, String pattern, Object[] arguments) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, arguments));
        }
    }

    public static void debug(Logger logger, String pattern, Object[] arguments) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, arguments));
        }
    }

    public static void info(Logger logger, String pattern, Object[] arguments) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, arguments));
        }
    }

    public static void warn(Logger logger, String pattern, Object[] arguments) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, arguments));
        }
    }

    public static void error(Logger logger, String pattern, Object[] arguments) {
        if (logger.isEnabledFor(Level.ERROR)) {
            LogSF.forcedLog(logger, Level.ERROR, LogSF.format(pattern, arguments));
        }
    }

    public static void fatal(Logger logger, String pattern, Object[] arguments) {
        if (logger.isEnabledFor(Level.FATAL)) {
            LogSF.forcedLog(logger, Level.FATAL, LogSF.format(pattern, arguments));
        }
    }

    public static void trace(Logger logger, Throwable t, String pattern, Object[] arguments) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, arguments), t);
        }
    }

    public static void debug(Logger logger, Throwable t, String pattern, Object[] arguments) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, arguments), t);
        }
    }

    public static void info(Logger logger, Throwable t, String pattern, Object[] arguments) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, arguments), t);
        }
    }

    public static void warn(Logger logger, Throwable t, String pattern, Object[] arguments) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, arguments), t);
        }
    }

    public static void error(Logger logger, Throwable t, String pattern, Object[] arguments) {
        if (logger.isEnabledFor(Level.ERROR)) {
            LogSF.forcedLog(logger, Level.ERROR, LogSF.format(pattern, arguments), t);
        }
    }

    public static void fatal(Logger logger, Throwable t, String pattern, Object[] arguments) {
        if (logger.isEnabledFor(Level.FATAL)) {
            LogSF.forcedLog(logger, Level.FATAL, LogSF.format(pattern, arguments), t);
        }
    }

    public static void trace(Logger logger, String pattern, boolean argument) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger, String pattern, char argument) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger, String pattern, byte argument) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger, String pattern, short argument) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger, String pattern, int argument) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger, String pattern, long argument) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger, String pattern, float argument) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger, String pattern, double argument) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void trace(Logger logger, String pattern, Object argument) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, argument));
        }
    }

    public static void trace(Logger logger, String pattern, Object arg0, Object arg1) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, LogSF.toArray(arg0, arg1)));
        }
    }

    public static void trace(Logger logger, String pattern, Object arg0, Object arg1, Object arg2) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, LogSF.toArray(arg0, arg1, arg2)));
        }
    }

    public static void trace(Logger logger, String pattern, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (logger.isEnabledFor(TRACE)) {
            LogSF.forcedLog(logger, TRACE, LogSF.format(pattern, LogSF.toArray(arg0, arg1, arg2, arg3)));
        }
    }

    public static void debug(Logger logger, String pattern, boolean argument) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger, String pattern, char argument) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger, String pattern, byte argument) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger, String pattern, short argument) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger, String pattern, int argument) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger, String pattern, long argument) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger, String pattern, float argument) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger, String pattern, double argument) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void debug(Logger logger, String pattern, Object argument) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, argument));
        }
    }

    public static void debug(Logger logger, String pattern, Object arg0, Object arg1) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, LogSF.toArray(arg0, arg1)));
        }
    }

    public static void debug(Logger logger, String pattern, Object arg0, Object arg1, Object arg2) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, LogSF.toArray(arg0, arg1, arg2)));
        }
    }

    public static void debug(Logger logger, String pattern, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (logger.isDebugEnabled()) {
            LogSF.forcedLog(logger, Level.DEBUG, LogSF.format(pattern, LogSF.toArray(arg0, arg1, arg2, arg3)));
        }
    }

    public static void info(Logger logger, String pattern, boolean argument) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void info(Logger logger, String pattern, char argument) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void info(Logger logger, String pattern, byte argument) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void info(Logger logger, String pattern, short argument) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void info(Logger logger, String pattern, int argument) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void info(Logger logger, String pattern, long argument) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void info(Logger logger, String pattern, float argument) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void info(Logger logger, String pattern, double argument) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void info(Logger logger, String pattern, Object argument) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, argument));
        }
    }

    public static void info(Logger logger, String pattern, Object arg0, Object arg1) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, LogSF.toArray(arg0, arg1)));
        }
    }

    public static void info(Logger logger, String pattern, Object arg0, Object arg1, Object arg2) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, LogSF.toArray(arg0, arg1, arg2)));
        }
    }

    public static void info(Logger logger, String pattern, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (logger.isInfoEnabled()) {
            LogSF.forcedLog(logger, Level.INFO, LogSF.format(pattern, LogSF.toArray(arg0, arg1, arg2, arg3)));
        }
    }

    public static void warn(Logger logger, String pattern, boolean argument) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger, String pattern, char argument) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger, String pattern, byte argument) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger, String pattern, short argument) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger, String pattern, int argument) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger, String pattern, long argument) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger, String pattern, float argument) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger, String pattern, double argument) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, LogSF.valueOf(argument)));
        }
    }

    public static void warn(Logger logger, String pattern, Object argument) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, argument));
        }
    }

    public static void warn(Logger logger, String pattern, Object arg0, Object arg1) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, LogSF.toArray(arg0, arg1)));
        }
    }

    public static void warn(Logger logger, String pattern, Object arg0, Object arg1, Object arg2) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, LogSF.toArray(arg0, arg1, arg2)));
        }
    }

    public static void warn(Logger logger, String pattern, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (logger.isEnabledFor(Level.WARN)) {
            LogSF.forcedLog(logger, Level.WARN, LogSF.format(pattern, LogSF.toArray(arg0, arg1, arg2, arg3)));
        }
    }

    public static void log(Logger logger, Level level2, String pattern, Object[] parameters2) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, parameters2));
        }
    }

    public static void log(Logger logger, Level level2, Throwable t, String pattern, Object[] parameters2) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, parameters2), t);
        }
    }

    public static void log(Logger logger, Level level2, String pattern, Object param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, LogSF.toArray(param1)));
        }
    }

    public static void log(Logger logger, Level level2, String pattern, boolean param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void log(Logger logger, Level level2, String pattern, byte param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void log(Logger logger, Level level2, String pattern, char param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void log(Logger logger, Level level2, String pattern, short param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void log(Logger logger, Level level2, String pattern, int param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void log(Logger logger, Level level2, String pattern, long param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void log(Logger logger, Level level2, String pattern, float param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void log(Logger logger, Level level2, String pattern, double param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void log(Logger logger, Level level2, String pattern, Object arg0, Object arg1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, LogSF.toArray(arg0, arg1)));
        }
    }

    public static void log(Logger logger, Level level2, String pattern, Object arg0, Object arg1, Object arg2) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, LogSF.toArray(arg0, arg1, arg2)));
        }
    }

    public static void log(Logger logger, Level level2, String pattern, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(pattern, LogSF.toArray(arg0, arg1, arg2, arg3)));
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, Object[] parameters2) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, parameters2));
        }
    }

    public static void logrb(Logger logger, Level level2, Throwable t, String bundleName, String key2, Object[] parameters2) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, parameters2), t);
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, Object param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, LogSF.toArray(param1)));
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, boolean param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, char param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, byte param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, short param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, int param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, long param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, float param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, double param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, LogSF.toArray(LogSF.valueOf(param1))));
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, Object param0, Object param1) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, LogSF.toArray(param0, param1)));
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, Object param0, Object param1, Object param2) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, LogSF.toArray(param0, param1, param2)));
        }
    }

    public static void logrb(Logger logger, Level level2, String bundleName, String key2, Object param0, Object param1, Object param2, Object param3) {
        if (logger.isEnabledFor(level2)) {
            LogSF.forcedLog(logger, level2, LogSF.format(bundleName, key2, LogSF.toArray(param0, param1, param2, param3)));
        }
    }
}

