/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yetus.audience.tools;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

class RootDocProcessor {
    static String stability = "-unstable";
    static boolean treatUnannotatedClassesAsPrivate = false;
    private static Map<Object, Object> proxies = new WeakHashMap<Object, Object>();

    RootDocProcessor() {
    }

    public static RootDoc process(RootDoc root) {
        return (RootDoc)RootDocProcessor.process(root, RootDoc.class);
    }

    private static Object process(Object obj, Class<?> type2) {
        if (obj == null) {
            return null;
        }
        Class<?> cls = obj.getClass();
        if (cls.getName().startsWith("com.sun.")) {
            return RootDocProcessor.getProxy(obj);
        }
        if (obj instanceof Object[]) {
            Class<?> componentType = type2.isArray() ? type2.getComponentType() : cls.getComponentType();
            Object[] array = (Object[])obj;
            Object[] newArray = (Object[])Array.newInstance(componentType, array.length);
            for (int i2 = 0; i2 < array.length; ++i2) {
                newArray[i2] = RootDocProcessor.process(array[i2], componentType);
            }
            return newArray;
        }
        return obj;
    }

    private static Object getProxy(Object obj) {
        Object proxy2 = proxies.get(obj);
        if (proxy2 == null) {
            proxy2 = Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), (InvocationHandler)new ExcludeHandler(obj));
            proxies.put(obj, proxy2);
        }
        return proxy2;
    }

    private static class ExcludeHandler
    implements InvocationHandler {
        private Object target;

        public ExcludeHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy2, Method method2, Object[] args2) throws Throwable {
            String methodName = method2.getName();
            if (this.target instanceof Doc) {
                if (methodName.equals("isIncluded")) {
                    Doc doc = (Doc)this.target;
                    return !ExcludeHandler.exclude(doc) && doc.isIncluded();
                }
                if (this.target instanceof RootDoc) {
                    if (methodName.equals("classes")) {
                        return ExcludeHandler.filter((Doc[])((RootDoc)this.target).classes(), ClassDoc.class);
                    }
                    if (methodName.equals("specifiedClasses")) {
                        return ExcludeHandler.filter((Doc[])((RootDoc)this.target).specifiedClasses(), ClassDoc.class);
                    }
                    if (methodName.equals("specifiedPackages")) {
                        return ExcludeHandler.filter((Doc[])((RootDoc)this.target).specifiedPackages(), PackageDoc.class);
                    }
                } else if (this.target instanceof ClassDoc) {
                    if (this.isFiltered(args2)) {
                        if (methodName.equals("methods")) {
                            return ExcludeHandler.filter((Doc[])((ClassDoc)this.target).methods(true), MethodDoc.class);
                        }
                        if (methodName.equals("fields")) {
                            return ExcludeHandler.filter((Doc[])((ClassDoc)this.target).fields(true), FieldDoc.class);
                        }
                        if (methodName.equals("innerClasses")) {
                            return ExcludeHandler.filter((Doc[])((ClassDoc)this.target).innerClasses(true), ClassDoc.class);
                        }
                        if (methodName.equals("constructors")) {
                            return ExcludeHandler.filter((Doc[])((ClassDoc)this.target).constructors(true), ConstructorDoc.class);
                        }
                    }
                } else if (this.target instanceof PackageDoc) {
                    if (methodName.equals("allClasses")) {
                        if (this.isFiltered(args2)) {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).allClasses(true), ClassDoc.class);
                        }
                        return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).allClasses(), ClassDoc.class);
                    }
                    if (methodName.equals("annotationTypes")) {
                        return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).annotationTypes(), AnnotationTypeDoc.class);
                    }
                    if (methodName.equals("enums")) {
                        return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).enums(), ClassDoc.class);
                    }
                    if (methodName.equals("errors")) {
                        return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).errors(), ClassDoc.class);
                    }
                    if (methodName.equals("exceptions")) {
                        return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).exceptions(), ClassDoc.class);
                    }
                    if (methodName.equals("interfaces")) {
                        return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).interfaces(), ClassDoc.class);
                    }
                    if (methodName.equals("ordinaryClasses")) {
                        return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).ordinaryClasses(), ClassDoc.class);
                    }
                }
            }
            if (args2 != null && (methodName.equals("compareTo") || methodName.equals("equals") || methodName.equals("overrides") || methodName.equals("subclassOf"))) {
                args2[0] = this.unwrap(args2[0]);
            }
            try {
                return RootDocProcessor.process(method2.invoke(this.target, args2), method2.getReturnType());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private static boolean exclude(Doc doc) {
            AnnotationDesc[] annotations2 = null;
            if (doc instanceof ProgramElementDoc) {
                annotations2 = ((ProgramElementDoc)doc).annotations();
            } else if (doc instanceof PackageDoc) {
                annotations2 = ((PackageDoc)doc).annotations();
            }
            if (annotations2 != null) {
                String qualifiedTypeName;
                for (AnnotationDesc annotation2 : annotations2) {
                    qualifiedTypeName = annotation2.annotationType().qualifiedTypeName();
                    if (qualifiedTypeName.equals(InterfaceAudience.Private.class.getCanonicalName()) || qualifiedTypeName.equals(InterfaceAudience.LimitedPrivate.class.getCanonicalName())) {
                        return true;
                    }
                    if (stability.equals("-evolving") && qualifiedTypeName.equals(InterfaceStability.Unstable.class.getCanonicalName())) {
                        return true;
                    }
                    if (!stability.equals("-stable") || !qualifiedTypeName.equals(InterfaceStability.Unstable.class.getCanonicalName()) && !qualifiedTypeName.equals(InterfaceStability.Evolving.class.getCanonicalName())) continue;
                    return true;
                }
                for (AnnotationDesc annotation2 : annotations2) {
                    qualifiedTypeName = annotation2.annotationType().qualifiedTypeName();
                    if (!qualifiedTypeName.equals(InterfaceAudience.Public.class.getCanonicalName())) continue;
                    return false;
                }
            }
            if (treatUnannotatedClassesAsPrivate) {
                return doc.isClass() || doc.isInterface() || doc.isAnnotationType();
            }
            return false;
        }

        private static Object[] filter(Doc[] array, Class<?> componentType) {
            if (array == null || array.length == 0) {
                return array;
            }
            ArrayList<Object> list2 = new ArrayList<Object>(array.length);
            for (Doc entry : array) {
                if (ExcludeHandler.exclude(entry)) continue;
                list2.add(RootDocProcessor.process(entry, componentType));
            }
            return list2.toArray((Object[])Array.newInstance(componentType, list2.size()));
        }

        private Object unwrap(Object proxy2) {
            if (proxy2 instanceof Proxy) {
                return ((ExcludeHandler)Proxy.getInvocationHandler((Object)proxy2)).target;
            }
            return proxy2;
        }

        private boolean isFiltered(Object[] args2) {
            return args2 != null && Boolean.TRUE.equals(args2[0]);
        }
    }
}

