/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum.flexible;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumHierarchical
implements QuorumVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumHierarchical.class);
    private HashMap<Long, Long> serverWeight = new HashMap();
    private HashMap<Long, Long> serverGroup = new HashMap();
    private HashMap<Long, Long> groupWeight = new HashMap();
    private int numGroups = 0;
    private Map<Long, QuorumPeer.QuorumServer> allMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private Map<Long, QuorumPeer.QuorumServer> participatingMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private Map<Long, QuorumPeer.QuorumServer> observingMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private long version = 0L;

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof QuorumHierarchical)) {
            return false;
        }
        QuorumHierarchical qm = (QuorumHierarchical)o;
        if (qm.getVersion() == this.version) {
            return true;
        }
        if (this.allMembers.size() != qm.getAllMembers().size() || this.serverWeight.size() != qm.serverWeight.size() || this.groupWeight.size() != qm.groupWeight.size() || this.serverGroup.size() != qm.serverGroup.size()) {
            return false;
        }
        for (QuorumPeer.QuorumServer quorumServer : this.allMembers.values()) {
            QuorumPeer.QuorumServer qso = qm.getAllMembers().get(quorumServer.id);
            if (qso != null && quorumServer.equals(qso)) continue;
            return false;
        }
        for (Map.Entry entry : this.serverWeight.entrySet()) {
            if (((Long)entry.getValue()).equals(qm.serverWeight.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry entry : this.groupWeight.entrySet()) {
            if (((Long)entry.getValue()).equals(qm.groupWeight.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry entry : this.serverGroup.entrySet()) {
            if (((Long)entry.getValue()).equals(qm.serverGroup.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public QuorumHierarchical(String filename2) throws QuorumPeerConfig.ConfigException {
        this.readConfigFile(filename2);
    }

    public QuorumHierarchical(Properties qp) throws QuorumPeerConfig.ConfigException {
        this.parse(qp);
        LOG.info(this.serverWeight.size() + ", " + this.serverGroup.size() + ", " + this.groupWeight.size());
    }

    @Override
    public long getWeight(long id2) {
        return this.serverWeight.get(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigFile(String filename2) throws QuorumPeerConfig.ConfigException {
        File configFile = new File(filename2);
        LOG.info("Reading configuration from: " + configFile);
        try {
            if (!configFile.exists()) {
                throw new IllegalArgumentException(configFile.toString() + " file is missing");
            }
            Properties cfg = new Properties();
            try (FileInputStream in = new FileInputStream(configFile);){
                cfg.load(in);
            }
            this.parse(cfg);
        }
        catch (IOException e) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + filename2, e);
        }
        catch (IllegalArgumentException e) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + filename2, e);
        }
    }

    private void parse(Properties quorumProp) throws QuorumPeerConfig.ConfigException {
        for (Map.Entry<Object, Object> entry : quorumProp.entrySet()) {
            long sid;
            int dot;
            String key2 = entry.getKey().toString();
            String value2 = entry.getValue().toString();
            if (key2.startsWith("server.")) {
                dot = key2.indexOf(46);
                sid = Long.parseLong(key2.substring(dot + 1));
                QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(sid, value2);
                this.allMembers.put(sid, qs);
                if (qs.type == QuorumPeer.LearnerType.PARTICIPANT) {
                    this.participatingMembers.put(sid, qs);
                    continue;
                }
                this.observingMembers.put(sid, qs);
                continue;
            }
            if (key2.startsWith("group")) {
                String[] parts;
                dot = key2.indexOf(46);
                long gid2 = Long.parseLong(key2.substring(dot + 1));
                ++this.numGroups;
                for (String s2 : parts = value2.split(":")) {
                    long sid2 = Long.parseLong(s2);
                    if (this.serverGroup.containsKey(sid2)) {
                        throw new QuorumPeerConfig.ConfigException("Server " + sid2 + "is in multiple groups");
                    }
                    this.serverGroup.put(sid2, gid2);
                }
                continue;
            }
            if (key2.startsWith("weight")) {
                dot = key2.indexOf(46);
                sid = Long.parseLong(key2.substring(dot + 1));
                this.serverWeight.put(sid, Long.parseLong(value2));
                continue;
            }
            if (!key2.equals("version")) continue;
            this.version = Long.parseLong(value2, 16);
        }
        for (QuorumPeer.QuorumServer qs : this.allMembers.values()) {
            Long id2 = qs.id;
            if (qs.type != QuorumPeer.LearnerType.PARTICIPANT) continue;
            if (!this.serverGroup.containsKey(id2)) {
                throw new QuorumPeerConfig.ConfigException("Server " + id2 + "is not in a group");
            }
            if (this.serverWeight.containsKey(id2)) continue;
            this.serverWeight.put(id2, 1L);
        }
        this.computeGroupWeight();
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getAllMembers() {
        return this.allMembers;
    }

    @Override
    public String toString() {
        Long sid;
        StringWriter sw = new StringWriter();
        for (QuorumPeer.QuorumServer member : this.getAllMembers().values()) {
            String string2 = "server." + member.id;
            String value3 = member.toString();
            sw.append(string2);
            sw.append('=');
            sw.append(value3);
            sw.append('\n');
        }
        HashMap<Long, String> groups2 = new HashMap<Long, String>();
        for (Map.Entry<Long, Long> entry : this.serverGroup.entrySet()) {
            sid = entry.getKey();
            Long gid2 = entry.getValue();
            String str = (String)groups2.get(gid2);
            str = str == null ? sid.toString() : str.concat(":").concat(sid.toString());
            groups2.put(gid2, str);
        }
        for (Map.Entry<Long, Long> entry : groups2.entrySet()) {
            Long gid3 = entry.getKey();
            String key2 = "group." + gid3.toString();
            String value2 = (String)((Object)entry.getValue());
            sw.append(key2);
            sw.append('=');
            sw.append(value2);
            sw.append('\n');
        }
        for (Map.Entry<Long, Long> entry : this.serverWeight.entrySet()) {
            sid = entry.getKey();
            String key2 = "weight." + sid.toString();
            String value2 = entry.getValue().toString();
            sw.append(key2);
            sw.append('=');
            sw.append(value2);
            sw.append('\n');
        }
        sw.append("version=" + Long.toHexString(this.version));
        return sw.toString();
    }

    private void computeGroupWeight() {
        for (Map.Entry<Long, Long> entry : this.serverGroup.entrySet()) {
            Long sid = entry.getKey();
            Long gid2 = entry.getValue();
            if (!this.groupWeight.containsKey(gid2)) {
                this.groupWeight.put(gid2, this.serverWeight.get(sid));
                continue;
            }
            long totalWeight = this.serverWeight.get(sid) + this.groupWeight.get(gid2);
            this.groupWeight.put(gid2, totalWeight);
        }
        Iterator<Object> iterator = this.groupWeight.values().iterator();
        while (iterator.hasNext()) {
            long weight = (Long)iterator.next();
            LOG.debug("Group weight: " + weight);
            if (weight != 0L) continue;
            --this.numGroups;
            LOG.debug("One zero-weight group: 1, " + this.numGroups);
        }
    }

    @Override
    public boolean containsQuorum(Set<Long> set) {
        Long gid2;
        HashMap<Long, Long> expansion = new HashMap<Long, Long>();
        if (set.size() == 0) {
            return false;
        }
        LOG.debug("Set size: " + set.size());
        for (long sid : set) {
            gid2 = this.serverGroup.get(sid);
            if (gid2 == null) continue;
            if (!expansion.containsKey(gid2)) {
                expansion.put(gid2, this.serverWeight.get(sid));
                continue;
            }
            long totalWeight = this.serverWeight.get(sid) + (Long)expansion.get(gid2);
            expansion.put(gid2, totalWeight);
        }
        int majGroupCounter = 0;
        for (Map.Entry entry : expansion.entrySet()) {
            gid2 = (Long)entry.getKey();
            LOG.debug("Group info: {}, {}, {}", entry.getValue(), gid2, this.groupWeight.get(gid2));
            if ((Long)entry.getValue() <= this.groupWeight.get(gid2) / 2L) continue;
            ++majGroupCounter;
        }
        LOG.debug("Majority group counter: {}, {}", (Object)majGroupCounter, (Object)this.numGroups);
        if (majGroupCounter > this.numGroups / 2) {
            LOG.debug("Positive set size: {}", (Object)set.size());
            return true;
        }
        LOG.debug("Negative set size: {}", (Object)set.size());
        return false;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getVotingMembers() {
        return this.participatingMembers;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getObservingMembers() {
        return this.observingMembers;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long ver2) {
        this.version = ver2;
    }
}

