/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.transcode;

import org.jcodings.exception.InternalException;
import org.jcodings.transcode.AsciiCompatibility;
import org.jcodings.transcode.GenericTranscoder;
import org.jcodings.transcode.Transcoding;
import org.jcodings.transcode.TranscodingInstruction;
import org.jcodings.util.ArrayReader;
import org.jcodings.util.BytesHash;
import org.jcodings.util.ObjHash;

public abstract class Transcoder
implements TranscodingInstruction {
    final byte[] source;
    final byte[] destination;
    final int hashCode;
    final int treeStart;
    final byte[] byteArray;
    final int[] intArray;
    public final int inputUnitLength;
    public final int maxInput;
    public final int maxOutput;
    public final AsciiCompatibility compatibility;
    final int stateSize;
    static final ObjHash<String, byte[]> byteArrayHash = new ObjHash();
    static final ObjHash<String, int[]> wordArrayHash = new ObjHash();

    protected Transcoder(byte[] source2, byte[] destination, int treeStart, String arrayKey, int inputUnitLength, int maxInput, int maxOutput, AsciiCompatibility compatibility, int stateSize) {
        this.source = source2;
        this.destination = destination;
        this.hashCode = BytesHash.hashCode(this.source, 0, this.source.length);
        this.treeStart = treeStart;
        byte[] bytes2 = byteArrayHash.get(arrayKey);
        if (bytes2 == null) {
            bytes2 = ArrayReader.readByteArray("Transcoder_" + arrayKey + "_ByteArray");
            byteArrayHash.put(arrayKey, bytes2);
        }
        this.byteArray = bytes2;
        int[] ints = wordArrayHash.get(arrayKey);
        if (ints == null) {
            ints = ArrayReader.readIntArray("Transcoder_" + arrayKey + "_WordArray");
            wordArrayHash.put(arrayKey, ints);
        }
        this.intArray = ints;
        this.inputUnitLength = inputUnitLength;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.compatibility = compatibility;
        this.stateSize = stateSize;
    }

    protected Transcoder(String source2, String destination, int treeStart, String arrayKey, int inputUnitLength, int maxInput, int maxOutput, AsciiCompatibility compatibility, int stateSize) {
        this(source2.getBytes(), destination.getBytes(), treeStart, arrayKey, inputUnitLength, maxInput, maxOutput, compatibility, stateSize);
    }

    public byte[] getSource() {
        return this.source;
    }

    public byte[] getDestination() {
        return this.destination;
    }

    public boolean hasStateInit() {
        return false;
    }

    public int stateInit(byte[] statep) {
        return 0;
    }

    public int stateFinish(byte[] stateFinish) {
        return 0;
    }

    public int infoToInfo(byte[] statep, int o) {
        throw new RuntimeException("unimplemented infoToInfo needed in " + this);
    }

    public int startToInfo(byte[] statep, byte[] s2, int sStart, int l) {
        throw new RuntimeException("unimplemented startToInfo needed in " + this);
    }

    public int infoToOutput(byte[] statep, int nextInfo, byte[] p2, int start2, int size2) {
        throw new RuntimeException("unimplemented intoToOutput needed in " + this);
    }

    public boolean hasFinish() {
        return false;
    }

    public int finish(byte[] statep, byte[] p2, int start2, int size2) {
        return 0;
    }

    public int resetSize(byte[] statep) {
        return 0;
    }

    public int resetState(byte[] statep, byte[] p2, int start2, int size2) {
        return 0;
    }

    public int startToOutput(byte[] statep, byte[] s2, int sStart, int l, byte[] o, int oStart, int oSize) {
        throw new RuntimeException("unimplemented startToOutput needed in " + this);
    }

    public int startInfoToOutput(byte[] statep, byte[] s2, int sStart, int l, int info, byte[] o, int oStart, int oSize) {
        throw new RuntimeException("unimplemented startInfoToOutput needed in " + this);
    }

    public final Transcoding transcoding(int flags) {
        Transcoding tc = new Transcoding(this, flags);
        if (this.hasStateInit()) {
            this.stateInit(tc.state);
        }
        return tc;
    }

    public static Transcoder load(String name2) {
        Class<?> encClass;
        String encClassName = name2;
        try {
            encClass = Class.forName(encClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InternalException("transcoder class <%n> not found", encClassName);
        }
        try {
            return (Transcoder)encClass.getField("INSTANCE").get(encClass);
        }
        catch (Exception e) {
            throw new InternalException("problem loading transcoder <%n>", encClassName);
        }
    }

    public String toString() {
        return new String(this.source) + " => " + new String(this.destination);
    }

    public String toStringFull() {
        int i2;
        String s2 = "Transcoder (" + new String(this.source) + " => " + new String(this.destination) + ")\n";
        s2 = s2 + "  class: " + this.getClass().getSimpleName() + "\n";
        s2 = s2 + "  treeStart: " + this.treeStart + "\n";
        s2 = s2 + "  byteArray:" + this.byteArray.length + " (";
        for (i2 = 0; i2 < 20; ++i2) {
            s2 = s2 + (this.byteArray[i2] & 0xFF) + ", ";
        }
        s2 = s2 + "...)\n";
        s2 = s2 + "  wordArray:" + this.intArray.length + " (";
        for (i2 = 0; i2 < 20; ++i2) {
            s2 = s2 + ((long)this.intArray[i2] & 0xFFFFFFFFL) + ", ";
        }
        s2 = s2 + "...)\n";
        s2 = s2 + "  input unit length: " + this.inputUnitLength + "\n";
        s2 = s2 + "  max input: " + this.maxInput + "\n";
        s2 = s2 + "  max output: " + this.maxOutput + "\n";
        s2 = s2 + "  compatibility: " + (Object)((Object)this.compatibility) + "\n";
        s2 = s2 + "  state size: " + this.stateSize + "\n";
        return s2;
    }

    static final class GenericTranscoderEntry {
        final byte[] source;
        final byte[] destination;
        final String arrayKey;
        final int treeStart;
        final int inputUnitLength;
        final int maxInput;
        final int maxOutput;
        final int stateSize;
        final AsciiCompatibility compatibility;

        GenericTranscoderEntry(String source2, String destination, int treeStart, String arrayKey, int inputUnitLength, int maxInput, int maxOutput, AsciiCompatibility compatibility, int stateSize) {
            this.source = source2.getBytes();
            this.destination = destination.getBytes();
            this.treeStart = treeStart;
            this.arrayKey = arrayKey;
            this.inputUnitLength = inputUnitLength;
            this.maxInput = maxInput;
            this.maxOutput = maxOutput;
            this.compatibility = compatibility;
            this.stateSize = stateSize;
        }

        Transcoder createTranscoder() {
            return new GenericTranscoder(this.source, this.destination, this.treeStart, this.arrayKey, this.inputUnitLength, this.maxInput, this.maxOutput, this.compatibility, this.stateSize);
        }
    }
}

