/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.interpreter;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.compiler.ir.IRBuilder;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.IRScript;
import org.jruby.compiler.ir.instructions.BREAK_Instr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.ReturnInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.representations.CFG;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Interpreter {
    private static boolean debug = Boolean.parseBoolean(System.getProperty("jruby.ir.debug", "false"));
    private static int interpInstrsCount = 0;

    public static IRubyObject interpret(Ruby runtime2, Node rootNode, IRubyObject self) {
        IRScope scope = new IRBuilder().buildRoot((RootNode)rootNode);
        scope.prepareForInterpretation();
        return Interpreter.interpretTop(runtime2, scope, self);
    }

    public static boolean isDebug() {
        return debug;
    }

    public static IRubyObject interpretTop(Ruby runtime2, IRScope scope, IRubyObject self) {
        assert (scope instanceof IRScript) : "Must be an IRScript scope at Top!!!";
        IRScript root = (IRScript)scope;
        if (root.getStaticScope().getModule() == null) {
            root.getStaticScope().setModule(runtime2.getObject());
        }
        IRMethod rootMethod = root.getRootClass().getRootMethod();
        RubyClass metaclass = self.getMetaClass();
        InterpretedIRMethod method2 = new InterpretedIRMethod(rootMethod, metaclass);
        IRubyObject rv = method2.call(runtime2.getCurrentContext(), self, (RubyModule)metaclass, "", new IRubyObject[0]);
        if (debug) {
            System.out.println("-- Interpreted " + interpInstrsCount + " instructions");
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject interpret(ThreadContext context, CFG cfg, InterpreterContext interp) {
        IRubyObject iRubyObject;
        boolean inClosure = cfg.getScope() instanceof IRClosure;
        try {
            interp.setMethodExitLabel(cfg.getExitBB().getLabel());
            IRubyObject self = (IRubyObject)interp.getSelf();
            Instr[] instrs = cfg.prepareForInterpretation();
            int n = instrs.length;
            int ipc = 0;
            Instr lastInstr = null;
            while (ipc < n) {
                ++interpInstrsCount;
                lastInstr = instrs[ipc];
                if (debug) {
                    System.out.println("EXEC'ing: " + lastInstr);
                }
                try {
                    Label jumpTarget = lastInstr.interpret(interp, self);
                    ipc = jumpTarget == null ? ipc + 1 : jumpTarget.getTargetPC();
                }
                catch (RaiseException re) {
                    ipc = cfg.getRescuerPC(lastInstr);
                    if (ipc == -1) {
                        throw re;
                    }
                    interp.setException(re.getException());
                }
            }
            IRubyObject rv = (IRubyObject)interp.getReturnValue();
            if (lastInstr instanceof ReturnInstr) {
                if (inClosure) {
                    throw RuntimeHelpers.returnJump(rv, context);
                }
            } else if (lastInstr instanceof BREAK_Instr) {
                if (inClosure) {
                    RuntimeHelpers.breakJump(context, rv);
                } else {
                    throw context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.BREAK, rv, "unexpected break");
                }
            }
            iRubyObject = rv;
            Object var12_14 = null;
        }
        catch (JumpException.ReturnJump rj) {
            try {
                if (inClosure) {
                    throw rj;
                }
                IRubyObject iRubyObject2 = (IRubyObject)rj.getValue();
                Object var12_15 = null;
                if (interp.getFrame() != null) {
                    context.popFrame();
                    interp.setFrame(null);
                }
                if (interp.hasAllocatedDynamicScope()) {
                    context.postMethodScopeOnly();
                }
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                block21: {
                    Object var12_16 = null;
                    if (interp.getFrame() != null) {
                        context.popFrame();
                        interp.setFrame(null);
                    }
                    if (!interp.hasAllocatedDynamicScope()) break block21;
                    context.postMethodScopeOnly();
                }
                throw throwable;
            }
        }
        if (interp.getFrame() != null) {
            context.popFrame();
            interp.setFrame(null);
        }
        if (interp.hasAllocatedDynamicScope()) {
            context.postMethodScopeOnly();
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static IRubyObject INTERPRET_METHOD(ThreadContext context, CFG cfg, InterpreterContext interp, String name, RubyModule implClass, boolean isTraceable) {
        block13: {
            block12: {
                runtime = interp.getRuntime();
                syntheticMethod = name == null || name.equals("") != false;
                try {
                    className = implClass.getName();
                    if (!syntheticMethod) {
                        ThreadContext.pushBacktrace(context, className, name, context.getFile(), context.getLine());
                    }
                    if (isTraceable) {
                        Interpreter.methodPreTrace(runtime, context, name, implClass);
                    }
                    var9_9 = Interpreter.interpret(context, cfg, interp);
                    var11_10 = null;
                    if (!isTraceable) break block12;
                }
                catch (Throwable var10_18) {
                    block14: {
                        var11_11 = null;
                        if (isTraceable) {
                            try {
                                Interpreter.methodPostTrace(runtime, context, name, implClass);
                                var13_14 = null;
                                if (syntheticMethod) break block14;
                            }
                            catch (Throwable var12_17) {
                                var13_15 = null;
                                if (!syntheticMethod) {
                                    ThreadContext.popBacktrace(context);
                                }
                                throw var12_17;
                            }
                            ThreadContext.popBacktrace(context);
                            {
                                break block14;
                            }
                        }
                        if (syntheticMethod) break block14;
                        ThreadContext.popBacktrace(context);
                    }
                    throw var10_18;
                }
                try {
                    Interpreter.methodPostTrace(runtime, context, name, implClass);
                    var13_12 = null;
                    ** if (syntheticMethod) goto lbl-1000
                }
                catch (Throwable var12_16) {
                    var13_13 = null;
                    if (!syntheticMethod) {
                        ThreadContext.popBacktrace(context);
                    }
                    throw var12_16;
                }
lbl-1000:
                // 1 sources

                {
                    ThreadContext.popBacktrace(context);
                }
lbl-1000:
                // 2 sources

                {
                    break block13;
                }
            }
            if (!syntheticMethod) {
                ThreadContext.popBacktrace(context);
            }
        }
        return var9_9;
    }

    private static void methodPreTrace(Ruby runtime2, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime2.hasEventHooks()) {
            context.trace(RubyEvent.CALL, name2, implClass);
        }
    }

    private static void methodPostTrace(Ruby runtime2, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime2.hasEventHooks()) {
            context.trace(RubyEvent.RETURN, name2, implClass);
        }
    }
}

