/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.realm.kerberos;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.filter.authc.PassThruAuthenticationFilter;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.zeppelin.realm.kerberos.KerberosRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticationFilter
extends PassThruAuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosAuthenticationFilter.class);

    protected void saveRequestAndRedirectToLogin(ServletRequest request, ServletResponse response) {
    }

    public void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        KerberosRealm kerberosRealm = null;
        String key = ThreadContext.SECURITY_MANAGER_KEY;
        DefaultWebSecurityManager defaultWebSecurityManager = (DefaultWebSecurityManager)ThreadContext.get((Object)key);
        Collection realms = defaultWebSecurityManager.getRealms();
        for (Object realm : realms) {
            if (!(realm instanceof KerberosRealm)) continue;
            kerberosRealm = (KerberosRealm)((Object)realm);
            break;
        }
        if (kerberosRealm != null) {
            kerberosRealm.doKerberosAuth(request, response, filterChain);
        } else {
            LOG.error("Looks like this filter is enabled without enabling KerberosRealm, please refer to https://zeppelin.apache.org/docs/latest/security/shiroauthentication.html#kerberos-auth");
        }
    }
}

