/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.service;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.BadRequestException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.zeppelin.rest.message.LoggerRequest;

public class AdminService {
    public List<Logger> getLoggers() {
        final Enumeration loggers = LogManager.getCurrentLoggers();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<Logger>(){

            @Override
            public boolean hasNext() {
                return loggers.hasMoreElements();
            }

            @Override
            public Logger next() {
                return (Logger)Logger.class.cast(loggers.nextElement());
            }
        }, 16), false).collect(Collectors.toList());
    }

    public Logger getLogger(String name) {
        return LogManager.getLogger((String)name);
    }

    public void setLoggerLevel(LoggerRequest loggerRequest) throws BadRequestException {
        try {
            Class.forName(loggerRequest.getName());
        }
        catch (Throwable ignore) {
            throw new BadRequestException("The class of '" + loggerRequest.getName() + "' doesn't exists");
        }
        Logger logger = LogManager.getLogger((String)loggerRequest.getName());
        if (null == logger) {
            throw new BadRequestException("The name of the logger is wrong");
        }
        Level level = Level.toLevel((String)loggerRequest.getLevel(), null);
        if (null == level) {
            throw new BadRequestException("The level of the logger is wrong");
        }
        logger.setLevel(level);
    }
}

