/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.el.ext.AbstractCallableMethod;
import com.hubspot.jinjava.el.ext.JinjavaBeanELResolver;
import com.hubspot.jinjava.el.ext.JinjavaListELResolver;
import com.hubspot.jinjava.el.ext.NamedParameter;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.DisabledException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.LazyExpression;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.objects.PyWrapper;
import com.hubspot.jinjava.objects.collections.PyList;
import com.hubspot.jinjava.objects.collections.PyMap;
import com.hubspot.jinjava.objects.date.FormattedDate;
import com.hubspot.jinjava.objects.date.PyishDate;
import com.hubspot.jinjava.objects.date.StrftimeFormatter;
import com.hubspot.jinjava.util.Logging;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import jinjava.de.odysseus.el.util.SimpleResolver;
import jinjava.javax.el.ArrayELResolver;
import jinjava.javax.el.CompositeELResolver;
import jinjava.javax.el.ELContext;
import jinjava.javax.el.ELResolver;
import jinjava.javax.el.MapELResolver;
import jinjava.javax.el.PropertyNotFoundException;
import jinjava.javax.el.ResourceBundleELResolver;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;

public class JinjavaInterpreterResolver
extends SimpleResolver {
    public static final ELResolver DEFAULT_RESOLVER_READ_ONLY = new CompositeELResolver(){
        {
            this.add(new ArrayELResolver(true));
            this.add(new JinjavaListELResolver(true));
            this.add(new MapELResolver(true));
            this.add(new ResourceBundleELResolver());
            this.add(new JinjavaBeanELResolver(true));
        }
    };
    public static final ELResolver DEFAULT_RESOLVER_READ_WRITE = new CompositeELResolver(){
        {
            this.add(new ArrayELResolver(false));
            this.add(new JinjavaListELResolver(false));
            this.add(new MapELResolver(false));
            this.add(new ResourceBundleELResolver());
            this.add(new JinjavaBeanELResolver(false));
        }
    };
    private final JinjavaInterpreter interpreter;

    public JinjavaInterpreterResolver(JinjavaInterpreter interpreter) {
        super(interpreter.getConfig().getElResolver());
        this.interpreter = interpreter;
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        try {
            Object methodProperty = this.getValue(context, base, method, false);
            if (methodProperty instanceof AbstractCallableMethod) {
                context.setPropertyResolved(true);
                return this.interpreter.getContext().isValidationMode() ? "" : ((AbstractCallableMethod)methodProperty).evaluate(params);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.interpreter.getContext().isValidationMode() ? "" : super.invoke(context, base, method, paramTypes, this.generateMethodParams(method, params));
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        return this.getValue(context, base, property, true);
    }

    private Object[] generateMethodParams(Object method, Object[] astParams) {
        if (!"filter".equals(method)) {
            return astParams;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        LinkedHashMap<String, Object> kwargs = new LinkedHashMap<String, Object>();
        for (Object param : Arrays.asList(astParams).subList(2, astParams.length)) {
            if (param instanceof NamedParameter) {
                NamedParameter namedParameter = (NamedParameter)param;
                kwargs.put(namedParameter.getName(), namedParameter.getValue());
                continue;
            }
            args.add(param);
        }
        return new Object[]{astParams[0], astParams[1], args.toArray(), kwargs};
    }

    private Object getValue(ELContext context, Object base, Object property, boolean errOnUnknownProp) {
        Object value;
        block17: {
            String propertyName = Objects.toString(property, "");
            value = null;
            this.interpreter.getContext().addResolvedValue(propertyName);
            TemplateError.ErrorItem item = TemplateError.ErrorItem.PROPERTY;
            try {
                if ("____int3rpr3t3r____".equals(property)) {
                    value = this.interpreter;
                    break block17;
                }
                if (propertyName.startsWith("filter:")) {
                    item = TemplateError.ErrorItem.FILTER;
                    value = this.interpreter.getContext().getFilter(StringUtils.substringAfter(propertyName, "filter:"));
                    break block17;
                }
                if (propertyName.startsWith("exptest:")) {
                    item = TemplateError.ErrorItem.EXPRESSION_TEST;
                    value = this.interpreter.getContext().getExpTest(StringUtils.substringAfter(propertyName, "exptest:"));
                    break block17;
                }
                if (base == null) {
                    value = this.interpreter.retraceVariable((String)property, this.interpreter.getLineNumber(), -1);
                    break block17;
                }
                try {
                    int propertyNum;
                    if (base instanceof Optional) {
                        Optional optBase = (Optional)base;
                        if (!optBase.isPresent()) {
                            return null;
                        }
                        base = optBase.get();
                    }
                    if (base instanceof LazyExpression) {
                        base = ((LazyExpression)base).get();
                    }
                    if (base.getClass().isArray() && (property instanceof Integer || property instanceof Long) && (propertyNum = ((Number)property).intValue()) < 0) {
                        propertyName = String.valueOf(propertyNum += ((Object[])base).length);
                    }
                    if ((value = super.getValue(context, base, propertyName)) instanceof Optional) {
                        Optional optValue = (Optional)value;
                        if (!optValue.isPresent()) {
                            return null;
                        }
                        value = optValue.get();
                    }
                    if (value instanceof LazyExpression) {
                        value = ((LazyExpression)value).get();
                    }
                    if (value instanceof DeferredValue) {
                        throw new DeferredValueException(propertyName, this.interpreter.getLineNumber(), this.interpreter.getPosition());
                    }
                }
                catch (PropertyNotFoundException e) {
                    if (errOnUnknownProp) {
                        this.interpreter.addError(TemplateError.fromUnknownProperty(base, propertyName, this.interpreter.getLineNumber(), -1));
                    }
                }
            }
            catch (DisabledException e) {
                this.interpreter.addError(new TemplateError(TemplateError.ErrorType.FATAL, TemplateError.ErrorReason.DISABLED, item, e.getMessage(), propertyName, this.interpreter.getLineNumber(), -1, e));
            }
        }
        context.setPropertyResolved(true);
        return this.wrap(value);
    }

    Object wrap(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LazyExpression) {
            value = ((LazyExpression)value).get();
        }
        if (value instanceof PyWrapper) {
            return value;
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            return new PyList((List)value);
        }
        if (Map.class.isAssignableFrom(value.getClass())) {
            return new PyMap((Map)value);
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return new PyishDate(JinjavaInterpreterResolver.localizeDateTime(this.interpreter, ZonedDateTime.ofInstant(Instant.ofEpochMilli(((Date)value).getTime()), ZoneOffset.UTC)));
        }
        if (ZonedDateTime.class.isAssignableFrom(value.getClass())) {
            return new PyishDate(JinjavaInterpreterResolver.localizeDateTime(this.interpreter, (ZonedDateTime)value));
        }
        if (FormattedDate.class.isAssignableFrom(value.getClass())) {
            return JinjavaInterpreterResolver.formattedDateToString(this.interpreter, (FormattedDate)value);
        }
        return value;
    }

    private static ZonedDateTime localizeDateTime(JinjavaInterpreter interpreter, ZonedDateTime dt) {
        Logging.ENGINE_LOG.debug("Using timezone: {} to localize datetime: {}", (Object)interpreter.getConfig().getTimeZone(), (Object)dt);
        return dt.withZoneSameInstant(interpreter.getConfig().getTimeZone());
    }

    private static String formattedDateToString(JinjavaInterpreter interpreter, FormattedDate d) {
        DateTimeFormatter formatter = JinjavaInterpreterResolver.getFormatter(interpreter, d).withLocale(JinjavaInterpreterResolver.getLocale(interpreter, d));
        return formatter.format(JinjavaInterpreterResolver.localizeDateTime(interpreter, d.getDate()));
    }

    private static DateTimeFormatter getFormatter(JinjavaInterpreter interpreter, FormattedDate d) {
        if (!StringUtils.isBlank(d.getFormat())) {
            try {
                return StrftimeFormatter.formatter(d.getFormat(), interpreter.getConfig().getLocale());
            }
            catch (IllegalArgumentException e) {
                interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.SYNTAX_ERROR, TemplateError.ErrorItem.OTHER, e.getMessage(), null, interpreter.getLineNumber(), -1, null, BasicTemplateErrorCategory.UNKNOWN_DATE, ImmutableMap.of("date", d.getDate().toString(), "exception", e.getMessage(), "lineNumber", String.valueOf(interpreter.getLineNumber()))));
            }
        }
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
    }

    private static Locale getLocale(JinjavaInterpreter interpreter, FormattedDate d) {
        if (!StringUtils.isBlank(d.getLanguage())) {
            try {
                return LocaleUtils.toLocale(d.getLanguage());
            }
            catch (IllegalArgumentException e) {
                interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.SYNTAX_ERROR, TemplateError.ErrorItem.OTHER, e.getMessage(), null, interpreter.getLineNumber(), -1, null, BasicTemplateErrorCategory.UNKNOWN_LOCALE, ImmutableMap.of("date", d.getDate().toString(), "exception", e.getMessage(), "lineNumber", String.valueOf(interpreter.getLineNumber()))));
            }
        }
        return Locale.US;
    }
}

