/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.util.List;

public class HelperStringTokenizer
extends AbstractIterator<String> {
    private final char[] value;
    private final int length;
    private int currPost = 0;
    private int tokenStart = 0;
    private char lastChar = (char)32;
    private boolean useComma = false;
    private char quoteChar = '\u0000';
    private boolean inQuote = false;

    public HelperStringTokenizer(String s2) {
        this.value = s2.toCharArray();
        this.length = this.value.length;
    }

    public HelperStringTokenizer splitComma(boolean onOrOff) {
        this.useComma = onOrOff;
        return this;
    }

    @Override
    protected String computeNext() {
        while (this.currPost < this.length) {
            String token = this.makeToken();
            this.lastChar = this.value[this.currPost - 1];
            if (token == null) continue;
            return token;
        }
        this.endOfData();
        return null;
    }

    private String makeToken() {
        char c;
        if ((c = this.value[this.currPost++]) == '\"' || c == '\'') {
            if (this.inQuote) {
                if (this.quoteChar == c) {
                    this.inQuote = false;
                }
            } else {
                this.inQuote = true;
                this.quoteChar = c;
            }
        }
        if ((Character.isWhitespace(c) || this.useComma && c == ',') && !this.inQuote) {
            return this.newToken();
        }
        if (this.currPost == this.length) {
            return this.getEndToken();
        }
        return null;
    }

    private String getEndToken() {
        return String.copyValueOf(this.value, this.tokenStart, this.currPost - this.tokenStart);
    }

    private String newToken() {
        int lastStart = this.tokenStart;
        this.tokenStart = this.currPost;
        if (Character.isWhitespace(this.lastChar) || this.useComma && this.lastChar == ',') {
            return null;
        }
        return String.copyValueOf(this.value, lastStart, this.currPost - lastStart - 1);
    }

    public List<String> allTokens() {
        return Lists.newArrayList(this);
    }
}

