/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.shell.terminal.websocket;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.Map;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.zeppelin.shell.terminal.TerminalManager;
import org.apache.zeppelin.shell.terminal.service.TerminalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
@ServerEndpoint(value="/")
public class TerminalSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminalSocket.class);
    private TerminalService terminalService;
    private TerminalManager terminalManager = TerminalManager.getInstance();
    private String noteId;
    private String paragraphId;

    public TerminalSocket() {
        this.terminalService = this.terminalManager.addTerminalService(this);
    }

    @OnOpen
    public void onWebSocketConnect(Session sess) {
        LOGGER.info("Socket Connected: " + sess);
        this.terminalService.onWebSocketConnect(sess);
    }

    @OnMessage
    public void onWebSocketText(String message) {
        Map<String, String> messageMap;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received TEXT message: " + message);
        }
        if ((messageMap = this.getMessageMap(message)).containsKey("type")) {
            String type;
            switch (type = messageMap.get("type")) {
                case "TERMINAL_INIT": {
                    this.terminalService.onTerminalInit();
                    this.noteId = messageMap.get("noteId");
                    this.paragraphId = messageMap.get("paragraphId");
                    this.terminalManager.onWebSocketConnect(this.noteId, this.paragraphId);
                    break;
                }
                case "TERMINAL_READY": {
                    this.terminalService.onTerminalReady();
                    this.noteId = messageMap.get("noteId");
                    this.paragraphId = messageMap.get("paragraphId");
                    this.terminalManager.onWebSocketConnect(this.noteId, this.paragraphId);
                    break;
                }
                case "TERMINAL_COMMAND": {
                    this.terminalService.onCommand(messageMap.get("command"));
                    break;
                }
                case "TERMINAL_RESIZE": {
                    this.terminalService.onTerminalResize(messageMap.get("columns"), messageMap.get("rows"));
                    break;
                }
                default: {
                    LOGGER.error("Unrecodnized action: " + message);
                }
            }
        }
    }

    @OnClose
    public void onWebSocketClose(CloseReason reason) {
        LOGGER.info("Socket Closed: " + reason);
        this.terminalManager.onWebSocketClose(this, this.noteId, this.paragraphId);
    }

    @OnError
    public void onWebSocketError(Throwable cause) {
        LOGGER.warn(cause.getMessage(), cause);
        this.terminalManager.onWebSocketError(this, this.noteId, this.paragraphId);
    }

    private Map<String, String> getMessageMap(String message) {
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(message, new TypeToken<Map<String, String>>(){}.getType());
        return map;
    }
}

