/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.submarine;

import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.apache.zeppelin.python.PythonInterpreter;
import org.apache.zeppelin.submarine.IPySubmarineInterpreter;
import org.apache.zeppelin.submarine.SubmarineContext;
import org.apache.zeppelin.submarine.SubmarineInterpreter;
import org.apache.zeppelin.submarine.job.SubmarineJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PySubmarineInterpreter
extends PythonInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PySubmarineInterpreter.class);
    private SubmarineInterpreter submarineInterpreter = null;
    private SubmarineContext submarineContext = SubmarineContext.getInstance();

    public PySubmarineInterpreter(Properties property) {
        super(property);
    }

    @Override
    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        SubmarineJob submarineJob;
        String checkpointPath;
        this.setParagraphConfig(context);
        String algorithmPath = this.properties.getProperty("submarine.algorithm.hdfs.path", "");
        if (algorithmPath.contains("${username}")) {
            algorithmPath = algorithmPath.replace("${username}", this.userName);
            this.properties.setProperty("submarine.algorithm.hdfs.path", algorithmPath);
        }
        if ((checkpointPath = this.properties.getProperty("tf.checkpoint.path", "")).contains("${username}")) {
            checkpointPath = checkpointPath.replace("${username}", this.userName);
            this.properties.setProperty("tf.checkpoint.path", checkpointPath);
        }
        if (null == this.submarineInterpreter) {
            this.submarineInterpreter = (SubmarineInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(SubmarineInterpreter.class));
            if (null != this.submarineInterpreter) {
                this.submarineInterpreter.setPythonWorkDir(context.getNoteId(), this.getPythonWorkDir());
            }
        }
        if (null != (submarineJob = this.submarineContext.addOrGetSubmarineJob(this.properties, context)) && null != submarineJob.getHdfsClient()) {
            try {
                String noteId = context.getNoteId();
                List paragraphInfos = context.getIntpEventClient().getParagraphList(this.userName, noteId);
                submarineJob.getHdfsClient().saveParagraphToFiles(noteId, paragraphInfos, this.getPythonWorkDir().getAbsolutePath(), this.properties);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        return super.interpret(st, context);
    }

    private void setParagraphConfig(InterpreterContext context) {
        context.getConfig().put("editorHide", false);
        context.getConfig().put("title", true);
    }

    @Override
    protected IPythonInterpreter getIPythonInterpreter() throws InterpreterException {
        return (IPythonInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(IPySubmarineInterpreter.class, false));
    }
}

