/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.submarine.commons;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hubspot.jinjava.Jinjava;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutput;
import org.apache.zeppelin.submarine.commons.SubmarineCommand;
import org.apache.zeppelin.submarine.commons.SubmarineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmarineUI {
    private Logger LOGGER = LoggerFactory.getLogger(SubmarineUI.class);
    InterpreterContext intpContext;
    private static final String SUBMARINE_DASHBOARD_JINJA = "ui_templates/submarine-dashboard.jinja";
    private static final String SUBMARINE_USAGE_JINJA = "ui_templates/submarine-usage.jinja";
    private static final String SUBMARINE_COMMAND_OPTIONS_JSON = "ui_templates/submarine-command-options.json";
    private static final String SUBMARINE_LOG_HEAD_JINJA = "ui_templates/submarine-log-head.jinja";

    public SubmarineUI(InterpreterContext context) {
        this.intpContext = context;
        this.createUILayer();
    }

    public void createUILayer() {
        try {
            this.intpContext.out.setType(InterpreterResult.Type.ANGULAR);
            this.intpContext.out.setType(InterpreterResult.Type.ANGULAR);
        }
        catch (IOException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    public void createSubmarineUI(SubmarineCommand submarineCmd) {
        try {
            HashMap<String, Object> mapParams = new HashMap<String, Object>();
            mapParams.put(SubmarineUtils.unifyKey("PARAGRAPH_ID"), this.intpContext.getParagraphId());
            mapParams.put(SubmarineUtils.unifyKey("COMMAND_TYPE"), submarineCmd.getCommand());
            String templateName = "";
            switch (submarineCmd) {
                case USAGE: {
                    templateName = SUBMARINE_USAGE_JINJA;
                    List<CommandlineOption> commandlineOptions = this.getCommandlineOptions();
                    mapParams.put("COMMANDLINE_OPTIONS", commandlineOptions);
                    break;
                }
                default: {
                    templateName = SUBMARINE_DASHBOARD_JINJA;
                }
            }
            URL urlTemplate = Resources.getResource(templateName);
            String template = Resources.toString(urlTemplate, Charsets.UTF_8);
            Jinjava jinjava = new Jinjava();
            String submarineUsage = jinjava.render(template, mapParams);
            InterpreterResultMessageOutput outputUI = this.intpContext.out.getOutputAt(0);
            outputUI.clear();
            outputUI.write(submarineUsage);
            outputUI.flush();
            InterpreterResultMessageOutput outputLOG = this.intpContext.out.getOutputAt(1);
            outputLOG.clear();
            outputLOG.flush();
        }
        catch (IOException e) {
            this.LOGGER.error("Can't print usage", e);
        }
    }

    public List<CommandlineOption> getCommandlineOptions() throws IOException {
        String line;
        ArrayList<CommandlineOption> commandlineOptions = new ArrayList();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/ui_templates/submarine-command-options.json")));
        StringBuffer strbuf = new StringBuffer();
        int licensedLineCount = 14;
        while ((line = bufferedReader.readLine()) != null) {
            if (licensedLineCount-- > 0) continue;
            strbuf.append(line);
        }
        Gson gson = new Gson();
        commandlineOptions = (List)gson.fromJson(strbuf.toString(), new TypeToken<List<CommandlineOption>>(){}.getType());
        return commandlineOptions;
    }

    public void createUsageUI() {
        try {
            List<CommandlineOption> commandlineOptions = this.getCommandlineOptions();
            HashMap<String, Object> mapParams = new HashMap<String, Object>();
            mapParams.put(SubmarineUtils.unifyKey("PARAGRAPH_ID"), this.intpContext.getParagraphId());
            mapParams.put("COMMANDLINE_OPTIONS", commandlineOptions);
            URL urlTemplate = Resources.getResource(SUBMARINE_USAGE_JINJA);
            String template = Resources.toString(urlTemplate, Charsets.UTF_8);
            Jinjava jinjava = new Jinjava();
            String submarineUsage = jinjava.render(template, mapParams);
            InterpreterResultMessageOutput outputUI = this.intpContext.out.getOutputAt(0);
            outputUI.clear();
            outputUI.write(submarineUsage);
            outputUI.flush();
            InterpreterResultMessageOutput outputLOG = this.intpContext.out.getOutputAt(1);
            outputLOG.clear();
            outputLOG.flush();
        }
        catch (IOException e) {
            this.LOGGER.error("Can't print usage", e);
        }
    }

    public void createLogHeadUI() {
        try {
            HashMap mapParams = new HashMap();
            URL urlTemplate = Resources.getResource(SUBMARINE_LOG_HEAD_JINJA);
            String template = Resources.toString(urlTemplate, Charsets.UTF_8);
            Jinjava jinjava = new Jinjava();
            String submarineUsage = jinjava.render(template, mapParams);
            InterpreterResultMessageOutput outputUI = this.intpContext.out.getOutputAt(1);
            outputUI.clear();
            outputUI.write(submarineUsage);
            outputUI.flush();
        }
        catch (IOException e) {
            this.LOGGER.error("Can't print usage", e);
        }
    }

    public void printCommnadUI(SubmarineCommand submarineCmd) {
        try {
            HashMap<String, String> mapParams = new HashMap<String, String>();
            mapParams.put(SubmarineUtils.unifyKey("PARAGRAPH_ID"), this.intpContext.getParagraphId());
            URL urlTemplate = Resources.getResource(SUBMARINE_DASHBOARD_JINJA);
            String template = Resources.toString(urlTemplate, Charsets.UTF_8);
            Jinjava jinjava = new Jinjava();
            String submarineUsage = jinjava.render(template, mapParams);
            InterpreterResultMessageOutput outputUI = this.intpContext.out.getOutputAt(0);
            outputUI.clear();
            outputUI.write(submarineUsage);
            outputUI.flush();
            InterpreterResultMessageOutput outputLOG = this.intpContext.out.getOutputAt(1);
            outputLOG.clear();
            outputLOG.flush();
        }
        catch (IOException e) {
            this.LOGGER.error("Can't print usage", e);
        }
    }

    public void outputLog(String title, String message) {
        try {
            StringBuffer formatMsg = new StringBuffer();
            InterpreterResultMessageOutput output = null;
            output = this.intpContext.out.getOutputAt(1);
            formatMsg.append("<div style=\"width:100%\">");
            if (!StringUtils.isEmpty(title)) {
                formatMsg.append(title);
            }
            formatMsg.append("<pre style=\"max-height:120px\">");
            formatMsg.append(message);
            formatMsg.append("</pre>");
            formatMsg.append("</div>\n");
            output.write(formatMsg.toString());
            output.flush();
        }
        catch (IOException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    class CommandlineOption {
        private String name;
        private String description;

        CommandlineOption(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

