/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.user;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.user.UserCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationInfo
implements JsonSerializable {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationInfo.class);
    private static final Gson GSON = new Gson();
    String user;
    Set<String> roles;
    String ticket;
    UserCredentials userCredentials;
    public static final AuthenticationInfo ANONYMOUS = new AuthenticationInfo("anonymous", new HashSet<String>(), "anonymous");

    public AuthenticationInfo() {
    }

    public AuthenticationInfo(String user) {
        this.user = user;
    }

    public AuthenticationInfo(String user, Set<String> roles, String ticket) {
        this.user = user;
        this.ticket = ticket;
        this.roles = roles;
    }

    public AuthenticationInfo(String user, String roles, String ticket) {
        this.user = user;
        this.ticket = ticket;
        List rolesList = (List)GSON.fromJson(roles, ArrayList.class);
        this.roles = roles == null ? new HashSet<String>() : new HashSet<String>(rolesList);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public List<String> getUsersAndRoles() {
        ArrayList<String> usersAndRoles = new ArrayList<String>();
        if (this.roles != null) {
            usersAndRoles.addAll(this.roles);
        }
        if (this.user != null) {
            usersAndRoles.add(this.user);
        }
        return usersAndRoles;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public UserCredentials getUserCredentials() {
        return this.userCredentials;
    }

    public void setUserCredentials(UserCredentials userCredentials) {
        this.userCredentials = userCredentials;
    }

    public static boolean isAnonymous(AuthenticationInfo subject) {
        if (subject == null) {
            LOG.warn("Subject is null, assuming anonymous. Not recommended to use subject as null except in tests");
            return true;
        }
        return subject.isAnonymous();
    }

    public boolean isAnonymous() {
        return ANONYMOUS.equals(this) || "anonymous".equalsIgnoreCase(this.getUser()) || StringUtils.isEmpty((CharSequence)this.getUser());
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public static AuthenticationInfo fromJson(String json) {
        return (AuthenticationInfo)GSON.fromJson(json, AuthenticationInfo.class);
    }
}

