/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.dependency;

import com.vladsch.flexmark.util.collection.iteration.ReversibleIndexedIterator;
import com.vladsch.flexmark.util.dependency.Dependent;
import com.vladsch.flexmark.util.dependency.DependentItem;
import com.vladsch.flexmark.util.dependency.DependentItemMap;
import com.vladsch.flexmark.util.dependency.FirstDependent;
import com.vladsch.flexmark.util.dependency.LastDependent;
import com.vladsch.flexmark.util.misc.Ref;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyResolver {
    @NotNull
    public static <D extends Dependent> List<D> resolveFlatDependencies(@NotNull List<D> dependentsList, @Nullable Function<DependentItemMap<D>, DependentItemMap<D>> itemSorter, @Nullable Function<? super D, Class<?>> classExtractor) {
        List<List<D>> list = DependencyResolver.resolveDependencies(dependentsList, itemSorter, classExtractor);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        int totalSize = 0;
        for (List<D> subList : list) {
            totalSize += subList.size();
        }
        ArrayList<? super D> flatList = new ArrayList<D>(totalSize);
        for (List<? super D> list2 : list) {
            flatList.addAll(list2);
        }
        return flatList;
    }

    @NotNull
    public static <D extends Dependent> List<List<D>> resolveDependencies(@NotNull List<D> dependentsList, @Nullable Function<DependentItemMap<D>, DependentItemMap<D>> itemSorter, @Nullable Function<? super D, Class<?>> classExtractor) {
        DependentItem item;
        if (dependentsList.size() == 0) {
            return Collections.emptyList();
        }
        if (dependentsList.size() == 1) {
            return Collections.singletonList(dependentsList);
        }
        int dependentCount = dependentsList.size();
        DependentItemMap dependentItemMap = new DependentItemMap(dependentCount);
        if (classExtractor == null) {
            classExtractor = Object::getClass;
        }
        for (Dependent dependent : dependentsList) {
            Class<Object> dependentClass = classExtractor.apply(dependent);
            if (dependentItemMap.containsKey(dependentClass)) {
                throw new IllegalStateException("Dependent class " + dependentClass + " is duplicated. Only one instance can be present in the list");
            }
            item = new DependentItem(dependentItemMap.size(), dependent, classExtractor.apply(dependent), dependent.affectsGlobalScope());
            dependentItemMap.put(dependentClass, item);
        }
        for (Map.Entry entry : dependentItemMap) {
            Set<Class<?>> beforeDependents;
            Class<?> dependentClass22;
            DependentItem item2 = (DependentItem)entry.getValue();
            Set<Class<?>> afterDependencies = ((Dependent)item2.dependent).getAfterDependents();
            if (afterDependencies != null && afterDependencies.size() > 0) {
                for (Class<?> dependentClass22 : afterDependencies) {
                    if (dependentClass22 == LastDependent.class) {
                        for (Object dependentItem : dependentItemMap.valueIterable()) {
                            if (dependentItem == null || dependentItem == item2) continue;
                            item2.addDependency(dependentItem);
                            ((DependentItem)dependentItem).addDependent(item2);
                        }
                        continue;
                    }
                    DependentItem dependentItem = (DependentItem)dependentItemMap.get(dependentClass22);
                    if (dependentItem == null) continue;
                    item2.addDependency(dependentItem);
                    dependentItem.addDependent(item2);
                }
            }
            if ((beforeDependents = ((Dependent)item2.dependent).getBeforeDependents()) == null || beforeDependents.size() <= 0) continue;
            dependentClass22 = beforeDependents.iterator();
            while (dependentClass22.hasNext()) {
                Object dependentItem;
                Class dependentClass3 = (Class)dependentClass22.next();
                if (dependentClass3 == FirstDependent.class) {
                    dependentItem = dependentItemMap.valueIterable().iterator();
                    while (dependentItem.hasNext()) {
                        DependentItem dependentItem2 = (DependentItem)dependentItem.next();
                        if (dependentItem2 == null || dependentItem2 == item2) continue;
                        dependentItem2.addDependency(item2);
                        item2.addDependent(dependentItem2);
                    }
                    continue;
                }
                dependentItem = (DependentItem)dependentItemMap.get(dependentClass3);
                if (dependentItem == null) continue;
                ((DependentItem)dependentItem).addDependency(item2);
                item2.addDependent(dependentItem);
            }
        }
        if (itemSorter != null) {
            dependentItemMap = itemSorter.apply(dependentItemMap);
        }
        dependentCount = dependentItemMap.size();
        BitSet newReady = new BitSet(dependentCount);
        Ref<BitSet> ref = new Ref<BitSet>(newReady);
        ReversibleIndexedIterator iterator = dependentItemMap.valueIterator();
        while (iterator.hasNext()) {
            item = (DependentItem)iterator.next();
            if (item.hasDependencies()) continue;
            ((BitSet)ref.value).set(item.index);
        }
        BitSet dependents = new BitSet(dependentCount);
        dependents.set(0, dependentItemMap.size());
        ArrayList<List<D>> dependencyStages = new ArrayList<List<D>>();
        while (newReady.nextSetBit(0) != -1) {
            int i;
            ArrayList stageDependents = new ArrayList();
            BitSet nextDependents = new BitSet();
            while ((i = newReady.nextSetBit(0)) >= 0) {
                newReady.clear(i);
                DependentItem item3 = (DependentItem)dependentItemMap.getValue(i);
                assert (item3 != null);
                stageDependents.add(item3.dependent);
                dependents.clear(i);
                if (item3.hasDependents()) {
                    int j;
                    while ((j = item3.dependents.nextSetBit(0)) >= 0) {
                        item3.dependents.clear(j);
                        DependentItem dependentItem = (DependentItem)dependentItemMap.getValue(j);
                        assert (dependentItem != null);
                        if (dependentItem.removeDependency(item3)) continue;
                        if (item3.isGlobalScope) {
                            nextDependents.set(j);
                            continue;
                        }
                        newReady.set(j);
                    }
                    continue;
                }
                if (!item3.isGlobalScope) continue;
                nextDependents.or(newReady);
                break;
            }
            newReady = nextDependents;
            dependencyStages.add(stageDependents);
        }
        if (dependents.nextSetBit(0) != -1) {
            throw new IllegalStateException("have dependents with dependency cycles" + dependents);
        }
        return dependencyStages;
    }
}

