/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.session.impl;

import com.google.common.base.MoreObjects;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.EventType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.session.SessionClient;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.concurrent.ThreadContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class DelegatingSessionClient
implements SessionClient {
    private final SessionClient session;

    public DelegatingSessionClient(SessionClient session) {
        this.session = session;
    }

    @Override
    public SessionId sessionId() {
        return this.session.sessionId();
    }

    @Override
    public PartitionId partitionId() {
        return this.session.partitionId();
    }

    @Override
    public ThreadContext context() {
        return this.session.context();
    }

    @Override
    public String name() {
        return this.session.name();
    }

    @Override
    public PrimitiveType type() {
        return this.session.type();
    }

    @Override
    public PrimitiveState getState() {
        return this.session.getState();
    }

    @Override
    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        this.session.addStateChangeListener(listener);
    }

    @Override
    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        this.session.removeStateChangeListener(listener);
    }

    @Override
    public CompletableFuture<byte[]> execute(PrimitiveOperation operation) {
        return this.session.execute(operation);
    }

    @Override
    public void addEventListener(EventType eventType, Consumer<PrimitiveEvent> listener) {
        this.session.addEventListener(eventType, listener);
    }

    @Override
    public void removeEventListener(EventType eventType, Consumer<PrimitiveEvent> listener) {
        this.session.removeEventListener(eventType, listener);
    }

    @Override
    public CompletableFuture<SessionClient> connect() {
        return this.session.connect().thenApply(c -> this);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.session.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("client", (Object)this.session).toString();
    }
}

