/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.common;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.zeppelin.common.JsonSerializable;
import org.slf4j.Logger;

public class Message
implements JsonSerializable {
    private static final Set<OP> disabledForRunningNoteMessages = Collections.unmodifiableSet(new HashSet<OP>(Arrays.asList(OP.COMMIT_PARAGRAPH, OP.RUN_PARAGRAPH, OP.RUN_PARAGRAPH_USING_SPELL, OP.RUN_ALL_PARAGRAPHS, OP.PARAGRAPH_CLEAR_OUTPUT, OP.PARAGRAPH_CLEAR_ALL_OUTPUT, OP.INSERT_PARAGRAPH, OP.MOVE_PARAGRAPH, OP.COPY_PARAGRAPH, OP.PARAGRAPH_REMOVE, OP.MOVE_NOTE_TO_TRASH, OP.DEL_NOTE, OP.PATCH_PARAGRAPH)));
    private static final Gson GSON = new Gson();
    public static final Message EMPTY = new Message(null);
    public OP op;
    public Map<String, Object> data = new HashMap<String, Object>();
    public String ticket = "anonymous";
    public String principal = "anonymous";
    public String roles = "";
    public String msgId = MSG_ID_NOT_DEFINED;
    public static String MSG_ID_NOT_DEFINED = null;

    public Message(OP op) {
        this.op = op;
    }

    public Message withMsgId(String msgId) {
        this.msgId = msgId;
        return this;
    }

    public Message put(String k, Object v) {
        this.data.put(k, v);
        return this;
    }

    public Object get(String k) {
        return this.data.get(k);
    }

    public static boolean isDisabledForRunningNotes(OP eventType) {
        return disabledForRunningNoteMessages.contains((Object)eventType);
    }

    public <T> T getType(String key) {
        return (T)this.data.get(key);
    }

    public <T> T getType(String key, Logger log) {
        try {
            return this.getType(key);
        }
        catch (ClassCastException e) {
            log.error("Failed to get {} from message (Invalid type). ", (Object)key, (Object)e);
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Message{");
        sb.append("data=").append(this.data);
        sb.append(", op=").append((Object)this.op);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public static Message fromJson(String json) {
        return (Message)GSON.fromJson(json, Message.class);
    }

    public static enum OP {
        GET_HOME_NOTE,
        GET_NOTE,
        RELOAD_NOTE,
        NOTE,
        PARAGRAPH,
        PROGRESS,
        NEW_NOTE,
        DEL_NOTE,
        REMOVE_FOLDER,
        MOVE_NOTE_TO_TRASH,
        MOVE_FOLDER_TO_TRASH,
        RESTORE_FOLDER,
        RESTORE_NOTE,
        RESTORE_ALL,
        EMPTY_TRASH,
        CLONE_NOTE,
        IMPORT_NOTE,
        CONVERT_NOTE_NBFORMAT,
        CONVERTED_NOTE_NBFORMAT,
        NOTE_UPDATE,
        NOTE_RENAME,
        UPDATE_PERSONALIZED_MODE,
        FOLDER_RENAME,
        RUN_PARAGRAPH,
        COMMIT_PARAGRAPH,
        CANCEL_PARAGRAPH,
        MOVE_PARAGRAPH,
        INSERT_PARAGRAPH,
        COPY_PARAGRAPH,
        EDITOR_SETTING,
        COMPLETION,
        COMPLETION_LIST,
        LIST_NOTES,
        RELOAD_NOTES_FROM_REPO,
        NOTES_INFO,
        PARAGRAPH_REMOVE,
        PARAGRAPH_CLEAR_OUTPUT,
        PARAGRAPH_CLEAR_ALL_OUTPUT,
        PARAGRAPH_APPEND_OUTPUT,
        PARAGRAPH_UPDATE_OUTPUT,
        PING,
        AUTH_INFO,
        ANGULAR_OBJECT_UPDATE,
        ANGULAR_OBJECT_REMOVE,
        ANGULAR_OBJECT_UPDATED,
        ANGULAR_OBJECT_CLIENT_BIND,
        ANGULAR_OBJECT_CLIENT_UNBIND,
        LIST_CONFIGURATIONS,
        CONFIGURATIONS_INFO,
        CHECKPOINT_NOTE,
        LIST_REVISION_HISTORY,
        NOTE_REVISION,
        SET_NOTE_REVISION,
        NOTE_REVISION_FOR_COMPARE,
        APP_APPEND_OUTPUT,
        APP_UPDATE_OUTPUT,
        APP_LOAD,
        APP_STATUS_CHANGE,
        LIST_NOTE_JOBS,
        LIST_UPDATE_NOTE_JOBS,
        UNSUBSCRIBE_UPDATE_NOTE_JOBS,
        GET_INTERPRETER_BINDINGS,
        SAVE_INTERPRETER_BINDINGS,
        INTERPRETER_BINDINGS,
        GET_INTERPRETER_SETTINGS,
        INTERPRETER_SETTINGS,
        ERROR_INFO,
        SESSION_LOGOUT,
        WATCHER,
        PARAGRAPH_ADDED,
        PARAGRAPH_REMOVED,
        PARAGRAPH_MOVED,
        NOTE_UPDATED,
        RUN_ALL_PARAGRAPHS,
        PARAGRAPH_EXECUTED_BY_SPELL,
        RUN_PARAGRAPH_USING_SPELL,
        PARAS_INFO,
        SAVE_NOTE_FORMS,
        REMOVE_NOTE_FORMS,
        INTERPRETER_INSTALL_STARTED,
        INTERPRETER_INSTALL_RESULT,
        COLLABORATIVE_MODE_STATUS,
        PATCH_PARAGRAPH,
        NOTE_RUNNING_STATUS,
        NOTICE;

    }
}

